/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine;

import android.support.annotation.NonNull;
import com.ss.ttvideoengine.SubDesInfoModelProvider;
import com.ss.ttvideoengine.SubModel;
import com.ss.ttvideoengine.SubModelProvider;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SubDesInfoModel
implements SubDesInfoModelProvider {
    private final ArrayList<SubModelProvider> mSubModelList = new ArrayList();

    public SubDesInfoModel(@NonNull JSONObject obj) {
        if (obj.has("list")) {
            JSONArray jsonList = obj.optJSONArray("list");
            if (jsonList == null) {
                return;
            }
            for (int i = 0; i < jsonList.length(); ++i) {
                JSONObject json = jsonList.optJSONObject(i);
                if (json == null || !json.has("language_id") || !json.has("format") || !json.has("url") || !json.has("sub_id")) continue;
                SubModel model = new SubModel(json);
                this.mSubModelList.add(model);
            }
        }
    }

    public ArrayList<SubModelProvider> getSubModelList() {
        return this.mSubModelList;
    }

    public SubDesInfoModel(@NonNull ArrayList<SubModelProvider> models) {
        if (models.size() <= 0) {
            return;
        }
        for (int i = 0; i < models.size(); ++i) {
            SubModelProvider model = models.get(i);
            JSONObject jsonModel = model.toJson();
            if (jsonModel == null) {
                return;
            }
            if (!jsonModel.has("url") || !jsonModel.has("language_id") || !jsonModel.has("format") || !jsonModel.has("sub_id")) continue;
            this.mSubModelList.add(model);
        }
    }

    @Override
    public void addSubModel(@NonNull SubModelProvider model) {
        JSONObject jsonModel = model.toJson();
        if (jsonModel == null) {
            return;
        }
        if (jsonModel.has("url") && jsonModel.has("language_id") && jsonModel.has("format") && jsonModel.has("sub_id")) {
            this.mSubModelList.add(model);
        }
    }

    @Override
    public int subtitleCount() {
        return this.mSubModelList.size();
    }

    @Override
    public String toString() {
        String jsonString = null;
        if (this.mSubModelList.size() > 0) {
            JSONObject jsonObj = new JSONObject();
            JSONArray jsonArr = new JSONArray();
            for (int i = 0; i < this.mSubModelList.size(); ++i) {
                SubModelProvider model = this.mSubModelList.get(i);
                JSONObject jsonModel = model.toJson();
                if (jsonModel == null || !jsonModel.has("url") || !jsonModel.has("language_id") || !jsonModel.has("format") || !jsonModel.has("sub_id")) continue;
                jsonArr.put((Object)jsonModel);
            }
            try {
                jsonObj.putOpt("list", (Object)jsonArr);
                jsonString = jsonObj.toString();
            }
            catch (JSONException e) {
                TTVideoEngineLog.d(e);
            }
        }
        return jsonString;
    }
}

