/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.log;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import com.ss.ttvideoengine.log.LoggerUtils;
import com.ss.ttvideoengine.log.VideoEventBase;
import com.ss.ttvideoengine.log.VideoEventManager;
import com.ss.ttvideoengine.utils.EngineThreadPool;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import org.json.JSONObject;

public class VideoEventOneError {
    private static final String TAG = "VideoEventOneError";
    public static final String monitorName = "videoplayer_oneerror";
    public VideoEventBase mEventBase;
    public int mRetryCount = 0;
    public boolean mFirstFrameShown;
    public int mErrorCode = Integer.MIN_VALUE;
    public int mErrorType = Integer.MIN_VALUE;
    public String mErrorStage = "";
    public String mCDNUrl = "";
    public String mCDNIP = "";
    public int vsc = Integer.MIN_VALUE;
    public String vscMessage = "";
    public int mDisAbleV3Async = 0;

    VideoEventOneError(VideoEventBase base) {
        this.mEventBase = base;
        this.mRetryCount = 0;
        this.mFirstFrameShown = false;
    }

    public void reset() {
        this.mRetryCount = 0;
        this.mFirstFrameShown = false;
    }

    public void showedFirstFrame() {
        this.mFirstFrameShown = true;
    }

    public void movieShouldRetry(Error error, int retryStrategy, int apiVersion) {
        ++this.mRetryCount;
    }

    public void errorHappened(Error error) {
        this.mErrorCode = error.code;
        this.mErrorType = error.getType();
        this.sendErrorEvent();
    }

    public void errorHappened(int status, String message) {
        this.vsc = status;
        this.vscMessage = message;
        this.sendErrorEvent();
    }

    public void sendErrorEvent() {
        this.mErrorStage = this.mFirstFrameShown ? "playing" : "beforePlay";
        if (this.mDisAbleV3Async == 1) {
            TTVideoEngineLog.i(TAG, "report sync");
            VideoEventManager.instance.addEventV2(this.mEventBase.isUploadLogEnabled, this.toJsonObject(), monitorName);
        } else {
            TTVideoEngineLog.i(TAG, "report async");
            EngineThreadPool.addExecuteTask(new AsyncGetLogDataRunnable(this.mEventBase.mContext, this, this.mEventBase));
        }
    }

    private JSONObject toJsonObject() {
        HashMap map = new HashMap();
        if (this.mEventBase != null) {
            LoggerUtils.putToMap(map, "player_sessionid", this.mEventBase.mSessionID);
            if (this.mEventBase.mCurURL == null || this.mEventBase.mCurURL.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_url", this.mEventBase.mInitialURL);
            } else {
                LoggerUtils.putToMap(map, "cdn_url", this.mEventBase.mCurURL);
            }
            if (this.mEventBase.mCurIP == null || this.mEventBase.mCurIP.isEmpty()) {
                LoggerUtils.putToMap(map, "cdn_ip", this.mEventBase.mInitialIP);
            } else {
                LoggerUtils.putToMap(map, "cdn_ip", this.mEventBase.mCurIP);
            }
            LoggerUtils.putToMap(map, "resolution", this.mEventBase.mCurrentResolution);
            LoggerUtils.putToMap(map, "source_type", this.mEventBase.mSourceTypeStr);
            LoggerUtils.putToMap(map, "v", this.mEventBase.mVid);
            LoggerUtils.putToMap(map, "pv", this.mEventBase.pv);
            LoggerUtils.putToMap(map, "pc", this.mEventBase.pc);
            LoggerUtils.putToMap(map, "sv", this.mEventBase.sv);
            LoggerUtils.putToMap(map, "tag", this.mEventBase.mTag);
            LoggerUtils.putToMap(map, "subtag", this.mEventBase.mSubTag);
            LoggerUtils.putToMap(map, "sdk_version", this.mEventBase.sdk_version);
            LoggerUtils.putToMap(map, "video_hw", this.mEventBase.mVideoHW);
            LoggerUtils.putToMap(map, "vtype", this.mEventBase.vtype);
            LoggerUtils.putToMap(map, "p2p_cdn_type", this.mEventBase.mP2PCDNType);
            LoggerUtils.putToMap(map, "codec", this.mEventBase.codec_type);
            LoggerUtils.putToMap(map, "video_codec_nameid", this.mEventBase.videoCodecNameId);
            LoggerUtils.putToMap(map, "audio_codec_nameid", this.mEventBase.audioCodecNameId);
            LoggerUtils.putToMap(map, "format_type", this.mEventBase.formatType);
            LoggerUtils.putToMap(map, "drm_type", this.mEventBase.mDrmType);
            LoggerUtils.putToMap(map, "drm_token_url", this.mEventBase.mDrmTokenUrl);
            LoggerUtils.putToMap(map, "cur_req_pos", this.mEventBase.mdlVideoInfo.mdl_cur_req_pos);
            LoggerUtils.putToMap(map, "cur_end_pos", this.mEventBase.mdlVideoInfo.mdl_cur_end_pos);
            LoggerUtils.putToMap(map, "cur_cache_pos", this.mEventBase.mdlVideoInfo.mdl_cur_cache_pos);
            LoggerUtils.putToMap(map, "cache_type", this.mEventBase.mdlVideoInfo.mdl_cache_type);
            LoggerUtils.putToMap(map, "cur_ip", this.mEventBase.mdlVideoInfo.mdl_cur_ip);
            LoggerUtils.putToMap(map, "cur_host", this.mEventBase.mdlVideoInfo.mdl_cur_host);
            LoggerUtils.putToMap(map, "reply_size", this.mEventBase.mdlVideoInfo.mdl_reply_size);
            LoggerUtils.putToMap(map, "down_pos", this.mEventBase.mdlVideoInfo.mdl_down_pos);
            LoggerUtils.putToMap(map, "player_wait_time", this.mEventBase.mdlVideoInfo.mdl_player_wait_time);
            LoggerUtils.putToMap(map, "player_wait_num", this.mEventBase.mdlVideoInfo.mdl_player_wait_num);
            LoggerUtils.putToMap(map, "mdl_stage", this.mEventBase.mdlVideoInfo.mdl_stage);
            LoggerUtils.putToMap(map, "mdl_ec", this.mEventBase.mdlVideoInfo.mdl_error_code);
            LoggerUtils.putToMap(map, "mdl_speed", this.mEventBase.mdlVideoInfo.mdl_speed);
            LoggerUtils.putToMap(map, "mdl_file_key", this.mEventBase.mdlVideoInfo.mdl_file_key);
            LoggerUtils.putToMap(map, "mdl_is_socrf", this.mEventBase.mdlVideoInfo.mdl_is_socrf);
            LoggerUtils.putToMap(map, "mdl_req_num", this.mEventBase.mdlVideoInfo.mdl_req_num);
            LoggerUtils.putToMap(map, "mdl_url_index", this.mEventBase.mdlVideoInfo.mdl_url_index);
            LoggerUtils.putToMap(map, "mdl_re_url", this.mEventBase.mdlVideoInfo.mdl_re_url);
            LoggerUtils.putToMap(map, "net_type", this.mEventBase.mNetworkType);
            LoggerUtils.putToMap(map, "mdl_fs", this.mEventBase.mdlVideoInfo.mdl_fs);
            LoggerUtils.putToMap(map, "req_t", this.mEventBase.mdlVideoInfo.mdl_req_t);
            LoggerUtils.putToMap(map, "end_t", this.mEventBase.mdlVideoInfo.mdl_end_t);
            LoggerUtils.putToMap(map, "dns_t", this.mEventBase.mdlVideoInfo.mdl_dns_t);
            LoggerUtils.putToMap(map, "tcp_con_start_t", this.mEventBase.mdlVideoInfo.mdl_tcp_start_t);
            LoggerUtils.putToMap(map, "tcp_con_t", this.mEventBase.mdlVideoInfo.mdl_tcp_end_t);
            LoggerUtils.putToMap(map, "tcp_first_pack_t", this.mEventBase.mdlVideoInfo.mdl_ttfp);
            LoggerUtils.putToMap(map, "http_first_body_t", this.mEventBase.mdlVideoInfo.mdl_httpfb);
            LoggerUtils.putToMap(map, "http_open_end_t", this.mEventBase.mdlVideoInfo.mdl_http_open_end_t);
            LoggerUtils.putToMap(map, "http_code", this.mEventBase.mdlVideoInfo.mdl_http_code);
            LoggerUtils.putToMap(map, "mdl_extra_info", this.mEventBase.mdlVideoInfo.mdl_extra_info);
            LoggerUtils.putToMap(map, "mdl_version", this.mEventBase.mMdlVersion);
            LoggerUtils.putToMap(map, "mdl_ip_list", this.mEventBase.mdlVideoInfo.mdl_ip_list);
            LoggerUtils.putToMap(map, "mdl_blocked_ips", this.mEventBase.mdlVideoInfo.mdl_blocked_ips);
        }
        LoggerUtils.putToMap(map, "errt", this.mErrorType);
        LoggerUtils.putToMap(map, "errc", this.mErrorCode);
        LoggerUtils.putToMap(map, "es", this.mErrorStage);
        LoggerUtils.putToMap(map, "vsc", this.vsc);
        LoggerUtils.putToMap(map, "vsc_message", this.vscMessage);
        LoggerUtils.putToMap(map, "retry_count", this.mRetryCount);
        return new JSONObject(map);
    }

    private static class AsyncGetLogDataRunnable
    implements Runnable {
        private VideoEventOneError rEvent;
        private Handler rHandler;
        private VideoEventBase rEventBase;
        private Context rContext;

        public AsyncGetLogDataRunnable(Context context, VideoEventOneError event, VideoEventBase base) {
            this.rEvent = event;
            this.rEventBase = base;
            this.rContext = context;
            this.rHandler = new Handler(Looper.getMainLooper());
        }

        @Override
        public void run() {
            if (this.rEvent == null) {
                return;
            }
            if (this.rEventBase != null) {
                this.rEventBase.updateMDLInfo();
                this.rEventBase.mNetworkType = VideoEventBase.getNetType();
            }
            final boolean isUpload = this.rEventBase != null && this.rEventBase.isUploadLogEnabled;
            final JSONObject jsonEvent = this.rEvent.toJsonObject();
            if (this.rHandler == null || this.rHandler.getLooper() == null) {
                VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneError.monitorName);
                return;
            }
            this.rHandler.post(new Runnable(){

                @Override
                public void run() {
                    VideoEventManager.instance.addEventV2(isUpload, jsonEvent, VideoEventOneError.monitorName);
                }
            });
        }
    }
}

