/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.net;

import android.os.Handler;
import android.os.Message;
import com.ss.ttvideoengine.net.DNSCompletionListener;
import com.ss.ttvideoengine.net.TTHTTPNetwork;
import com.ss.ttvideoengine.net.TTVNetClient;
import com.ss.ttvideoengine.utils.Error;
import com.ss.ttvideoengine.utils.TTHelper;
import java.lang.ref.WeakReference;
import org.json.JSONObject;

public class BaseDNS {
    private static final int MSG_IS_CANCELLED = 0;
    private static final int MSG_IS_RETRY = 1;
    private static final int MSG_IS_ERROR = 2;
    private static final int MSG_IS_SUCCESS = 3;
    protected Handler mHandler;
    protected boolean mCancelled = false;
    protected String mHostname;
    protected DNSCompletionListener mListener;
    protected TTVNetClient mNetClient = null;

    public BaseDNS(String hostname) {
        this.mHostname = hostname;
        this.mHandler = new MyHandler(this);
    }

    public BaseDNS(String hostname, TTVNetClient client) {
        this.mHostname = hostname;
        this.mHandler = new MyHandler(this);
        if (client == null) {
            client = new TTHTTPNetwork();
        }
        this.mNetClient = client;
    }

    public void setCompletionListener(DNSCompletionListener listener) {
        this.mListener = listener;
    }

    public void start() {
    }

    public void cancel() {
    }

    public void close() {
    }

    protected void notifyRetry(Error error) {
        Message message = this.mHandler.obtainMessage(1, (Object)error);
        this.mHandler.sendMessage(message);
    }

    protected void notifyError(Error error) {
        Message message = this.mHandler.obtainMessage(2, (Object)error);
        this.mHandler.sendMessage(message);
    }

    protected void notifyCancelled() {
        this.mHandler.sendEmptyMessage(0);
    }

    protected void notifySuccess(JSONObject ipJSON) {
        Message message = this.mHandler.obtainMessage(3, (Object)ipJSON);
        this.mHandler.sendMessage(message);
    }

    private static class MyHandler
    extends Handler {
        private final WeakReference<BaseDNS> mDNSRef;

        public MyHandler(BaseDNS dns) {
            super(TTHelper.getLooper());
            this.mDNSRef = new WeakReference<BaseDNS>(dns);
        }

        public void handleMessage(Message msg) {
            BaseDNS dns = (BaseDNS)this.mDNSRef.get();
            if (dns == null) {
                return;
            }
            DNSCompletionListener listener = dns.mListener;
            if (listener == null) {
                return;
            }
            if (dns.mCancelled) {
                return;
            }
            switch (msg.what) {
                case 0: {
                    listener.onCancelled();
                    break;
                }
                case 1: {
                    dns.close();
                    Error error = (Error)msg.obj;
                    listener.onRetry(error);
                    break;
                }
                case 2: {
                    dns.close();
                    Error error = (Error)msg.obj;
                    listener.onCompletion(null, error);
                    break;
                }
                case 3: {
                    dns.close();
                    JSONObject ip = (JSONObject)msg.obj;
                    listener.onCompletion(ip, null);
                    break;
                }
            }
        }
    }
}

