/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.playermetrcis;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;

public class BatteryListener {
    private Context mContext;
    private BatteryBroadcastReceiver receiver;
    private BatteryStateListener mBatteryStateListener;
    private boolean mInitialState;

    public BatteryListener(Context context) {
        this.mContext = context;
        this.receiver = new BatteryBroadcastReceiver();
    }

    public void register(BatteryStateListener listener) {
        this.mBatteryStateListener = listener;
        if (this.mContext != null && this.receiver != null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.intent.action.ACTION_POWER_CONNECTED");
            filter.addAction("android.intent.action.ACTION_POWER_DISCONNECTED");
            Intent intent = this.mContext.registerReceiver((BroadcastReceiver)this.receiver, filter);
            if (intent != null) {
                int state = intent.getIntExtra("plugged", -1);
                TTVideoEngineLog.i("BatteryListener", "BatteryListener state: " + state);
                this.mInitialState = state == 2;
            }
        }
    }

    public boolean getInitialCharging() {
        return this.mInitialState;
    }

    public void unregister() {
        if (this.receiver != null) {
            this.mContext.unregisterReceiver((BroadcastReceiver)this.receiver);
        }
    }

    public static interface BatteryStateListener {
        public void onStatePowerConnected();

        public void onStatePowerDisconnected();
    }

    private class BatteryBroadcastReceiver
    extends BroadcastReceiver {
        private BatteryBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (intent != null) {
                String acyion;
                switch (acyion = intent.getAction()) {
                    case "android.intent.action.ACTION_POWER_CONNECTED": {
                        if (BatteryListener.this.mBatteryStateListener == null) break;
                        BatteryListener.this.mBatteryStateListener.onStatePowerConnected();
                        break;
                    }
                    case "android.intent.action.ACTION_POWER_DISCONNECTED": {
                        if (BatteryListener.this.mBatteryStateListener == null) break;
                        BatteryListener.this.mBatteryStateListener.onStatePowerDisconnected();
                    }
                }
            }
        }
    }
}

