/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.portrait;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.ss.ttvideoengine.log.PortraitNetworkScore;
import com.ss.ttvideoengine.model.IVideoModel;
import com.ss.ttvideoengine.portrait.IPortrait;
import com.ss.ttvideoengine.portrait.PortraitChangeListener;
import com.ss.ttvideoengine.utils.TTVideoEngineLog;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.json.JSONException;
import org.json.JSONObject;

public class PortraitEngine {
    private static final String TAG = "PortraitEngine";
    public static final String VOD_KEY = "vod";
    public static final String PORTRAIT_ENGINE_KEY = "portrait_engine";
    public static final String LABEL_NET_QUALITY_SPEED = "clinet_quality_speed";
    public static final String LABEL_NET_QUALITY_STABILITY = "clinet_quality_stability";
    public static final String LABEL_REBUF = "rebuf_label";
    public static final String LABEL_FF = "ff_label";
    public static final String LABEL_SEEK = "seek_label";
    public static final String LABEL_WATCH_DURATION = "watch_duration";
    public static final String LABEL_FIRST_FRAME = "first_frame";
    public static final String LABEL_REBUFFERING = "rebuffering";
    public static final String LABEL_USER_ENGER_FULL_SCREEN = "user_enter_full_screen";
    public static final String LABEL_SCENE_COUNT_PER_100VV = "scene_count_per_100vv";
    public static final String LABEL_USER_QUALITY_SENSITIVITY = "user_quality_sensitivity";
    public static final String LABEL_DEVICE_SCORE = "device_score";
    public static final String KEY_LABEL_USAGE = "label_usage";
    private final ConcurrentHashMap<String, Object> mLabelMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Object> mLabelUsage = new ConcurrentHashMap();
    private final CopyOnWriteArrayList<PortraitChangeListener> mListeners = new CopyOnWriteArrayList();
    private final IPortrait mPortraitNetwork = PortraitNetworkScore.getInstance();

    public void addPortraitListener(PortraitChangeListener listener) {
        this.mListeners.add(listener);
    }

    public void removePortraitListener(PortraitChangeListener listener) {
        this.mListeners.remove(listener);
    }

    public void setLabel(@NonNull String key, @NonNull Object value) {
        if (this.mLabelMap.containsKey(key) && this.mLabelMap.get(key) != null && !this.mLabelMap.get(key).equals(value)) {
            this.notifyPortraitChange(key, value);
        } else if (!this.mLabelMap.containsKey(key)) {
            this.notifyPortraitChange(key, value);
        } else {
            TTVideoEngineLog.d(TAG, "same label");
        }
        this.mLabelMap.put(key, value);
    }

    @Nullable
    public Object getLabel(@NonNull String key) {
        return this.mLabelMap.get(key);
    }

    @Nullable
    public Map<String, Object> getAllLabels() {
        HashMap<String, Object> labels = new HashMap<String, Object>(this.mLabelMap);
        return labels;
    }

    public void updateLabelByVideoModel(@NonNull IVideoModel model) {
        String labelUsage = model.getVideoRefStr(245);
        if (!TextUtils.isEmpty((CharSequence)labelUsage)) {
            try {
                JSONObject usage = new JSONObject(labelUsage);
                this.mLabelUsage.putAll(this.jsonToMap(usage));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateLabelBySettings(String key, String value) {
        if (!TextUtils.isEmpty((CharSequence)key) && key.equals(VOD_KEY)) {
            TTVideoEngineLog.d(TAG, "updateLabelBySettings key: " + key + "value: " + value);
            if (!TextUtils.isEmpty((CharSequence)value)) {
                try {
                    JSONObject portraitEngine;
                    JSONObject obj = new JSONObject(value);
                    if (obj.has(PORTRAIT_ENGINE_KEY) && (portraitEngine = obj.optJSONObject(PORTRAIT_ENGINE_KEY)) != null) {
                        if (portraitEngine.has(LABEL_NET_QUALITY_SPEED)) {
                            this.setLabel(LABEL_NET_QUALITY_SPEED, portraitEngine.optInt(LABEL_NET_QUALITY_SPEED));
                        }
                        if (portraitEngine.has(LABEL_NET_QUALITY_STABILITY)) {
                            this.setLabel(LABEL_NET_QUALITY_STABILITY, portraitEngine.optInt(LABEL_NET_QUALITY_STABILITY));
                        }
                        if (portraitEngine.has(LABEL_REBUF)) {
                            this.setLabel(LABEL_REBUF, portraitEngine.optInt(LABEL_REBUF));
                        }
                        if (portraitEngine.has(LABEL_FF)) {
                            this.setLabel(LABEL_FF, portraitEngine.optInt(LABEL_FF));
                        }
                        if (portraitEngine.has(LABEL_SEEK)) {
                            this.setLabel(LABEL_SEEK, portraitEngine.optInt(LABEL_SEEK));
                        }
                        if (portraitEngine.has(LABEL_WATCH_DURATION)) {
                            this.setLabel(LABEL_WATCH_DURATION, portraitEngine.optInt(LABEL_WATCH_DURATION));
                        }
                        if (portraitEngine.has(LABEL_FIRST_FRAME)) {
                            this.setLabel(LABEL_FIRST_FRAME, portraitEngine.optInt(LABEL_FIRST_FRAME));
                        }
                        if (portraitEngine.has(LABEL_REBUFFERING)) {
                            this.setLabel(LABEL_REBUFFERING, portraitEngine.optInt(LABEL_REBUFFERING));
                        }
                        if (portraitEngine.has(LABEL_USER_ENGER_FULL_SCREEN)) {
                            this.setLabel(LABEL_USER_ENGER_FULL_SCREEN, portraitEngine.optInt(LABEL_USER_ENGER_FULL_SCREEN));
                        }
                        if (portraitEngine.has(LABEL_SCENE_COUNT_PER_100VV)) {
                            this.setLabel(LABEL_SCENE_COUNT_PER_100VV, portraitEngine.optDouble(LABEL_SCENE_COUNT_PER_100VV));
                        }
                        if (portraitEngine.has(LABEL_USER_QUALITY_SENSITIVITY)) {
                            this.setLabel(LABEL_USER_QUALITY_SENSITIVITY, portraitEngine.optDouble(LABEL_USER_QUALITY_SENSITIVITY));
                        }
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private Map<String, Object> jsonToMap(JSONObject json) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator iterator = json.keys();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            Object value = json.opt(key);
            if (value == null) continue;
            map.put(key, value);
        }
        return map;
    }

    private void notifyPortraitChange(String key, Object value) {
        for (PortraitChangeListener listener : this.mListeners) {
            listener.onPortraitChange(key, value);
        }
    }

    public HashMap<String, Object> getEventData(Map<String, Object> event) {
        HashMap<String, Object> map = new HashMap<String, Object>(this.mLabelMap);
        if (!this.mLabelUsage.isEmpty()) {
            HashMap<String, Object> usageMap = new HashMap<String, Object>(this.mLabelUsage);
            if (event.containsKey(KEY_LABEL_USAGE)) {
                try {
                    usageMap.putAll((Map)event.get(KEY_LABEL_USAGE));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            map.put(KEY_LABEL_USAGE, usageMap);
        }
        return map;
    }

    @NonNull
    public IPortrait getPortrait(int id) {
        if (id == 1) {
            return this.mPortraitNetwork;
        }
        return IPortrait.EMPTY;
    }

    public static PortraitEngine getInstance() {
        return Holder.Instance;
    }

    private static class Holder {
        private static final PortraitEngine Instance = new PortraitEngine();

        private Holder() {
        }
    }
}

