/*
 * Decompiled with CFR 0.152.
 */
package com.ss.ttvideoengine.selector.shift;

import java.io.Serializable;

class Shift
implements Comparable<Shift>,
Serializable {
    private static final long serialVersionUID = 7003130400674500845L;
    public final double mRate;
    public final double mDownThreshold;
    public final double mUpThreshold;

    public Shift(double rate, double downThreshold, double upThreshold) {
        this.mRate = rate;
        this.mDownThreshold = downThreshold;
        this.mUpThreshold = upThreshold;
    }

    public double getMedianThreshold() {
        return (this.mDownThreshold + this.mUpThreshold) / 2.0;
    }

    public String toString() {
        return "Shift{mRate=" + this.mRate + ", mDownThreshold=" + this.mDownThreshold + ", mUpThreshold=" + this.mUpThreshold + '}';
    }

    @Override
    public int compareTo(Shift other) {
        return Double.compare(this.mRate, other.mRate);
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.mRate);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mDownThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.mUpThreshold);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Shift)) {
            return false;
        }
        Shift shift = (Shift)o;
        if (Double.compare(shift.mRate, this.mRate) != 0) {
            return false;
        }
        if (Double.compare(shift.mDownThreshold, this.mDownThreshold) != 0) {
            return false;
        }
        return Double.compare(shift.mUpThreshold, this.mUpThreshold) == 0;
    }
}

