/*
 * Decompiled with CFR 0.152.
 */
package com.pandora.vod;

import android.content.Context;
import com.pandora.common.env.config.Config;
import com.pandora.common.env.config.VodConfig;
import com.ss.ttvideoengine.TTVideoEngine;
import java.io.File;
import java.util.HashMap;

public class VodSDK {
    public static void init(Config config) {
        HashMap<String, String> appinfoMap = new HashMap<String, String>();
        appinfoMap.put("appname", config.getAppName());
        appinfoMap.put("appid", config.getAppID());
        appinfoMap.put("appchannel", config.getAppChannel());
        appinfoMap.put("region", config.getAppRegion());
        appinfoMap.put("appversion", config.getAppVersion());
        TTVideoEngine.setAppInfo((Context)config.getApplicationContext(), appinfoMap);
        VodSDK.initMDL(config);
    }

    private static void initMDL(Config config) {
        Context context = config.getApplicationContext();
        VodConfig vodConfig = config.getVodConfig();
        int maxCacheSize = vodConfig.getMaxCacheSize();
        String cacheDirPath = vodConfig.getCacheDirPath();
        int loaderType = vodConfig.getLoaderType();
        VodSDK.setCacheDir(cacheDirPath);
        TTVideoEngine.setIntValue((int)1, (int)maxCacheSize);
        TTVideoEngine.setIntValue((int)9008, (int)1);
        TTVideoEngine.setIntValue((int)5, (int)loaderType);
        try {
            TTVideoEngine.startDataLoader((Context)context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setCacheDir(String cacheDirPath) {
        File cacheDir = new File(cacheDirPath);
        if (cacheDir.exists() || cacheDir.mkdirs()) {
            TTVideoEngine.setStringValue((int)0, (String)cacheDir.getAbsolutePath());
        }
    }
}

