/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioAuxSinkProxy;
import com.bytedance.bae.ByteAudioNativeFunctions;
import com.bytedance.bae.ByteAudioSinkInterface;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.ByteAudioStreamOption;

public class ByteAudioAuxStream {
    public ByteAudioAuxSinkProxy sinkProxy = null;
    public boolean mute;
    public int gain;
    public int stream_id;
    public long nativeEnginePtr = 0L;
    public long nativeStreamPtr = 0L;
    public long nativeAuxStreamSink = 0L;
    public final Object streamLock = new Object();

    public ByteAudioAuxStream(long nativeEnginePtr, String name) {
        this.nativeEnginePtr = nativeEnginePtr;
        if (nativeEnginePtr != 0L) {
            this.nativeStreamPtr = ByteAudioNativeFunctions.nativeCreateAuxStream(nativeEnginePtr, name);
            if (this.nativeStreamPtr == 0L) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L && this.nativeEnginePtr != 0L) {
                ByteAudioNativeFunctions.nativeDestroyAuxStream(this.nativeEnginePtr, this.nativeStreamPtr);
                this.nativeStreamPtr = 0L;
                if (this.nativeAuxStreamSink != 0L) {
                    ByteAudioNativeFunctions.nativeReleaseAuxStreamSink(this.nativeAuxStreamSink);
                    this.nativeAuxStreamSink = 0L;
                }
                if (this.sinkProxy != null) {
                    this.sinkProxy.releaseProxySink();
                }
                this.sinkProxy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeAuxStreamStart(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeAuxStreamStop(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pauseStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeAuxStreamPause(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int resumeStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeAuxStreamResume(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setGain(int gain) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                this.gain = gain;
                int res = ByteAudioNativeFunctions.nativeAuxStreamSetGain(this.nativeStreamPtr, gain);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStreamFormat(ByteAudioStreamFormat streamFormat) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeAuxStreamSetFormat(this.nativeStreamPtr, streamFormat);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int auxStreamSetValue(int key, ByteAudioStreamOption value) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeAuxStreamSetValue(this.nativeStreamPtr, key, value);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteAudioStreamOption auxStreamGetValue(int key) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeAuxStreamGetValue(this.nativeStreamPtr, key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSink(ByteAudioSinkInterface.ByteAudioAuxSink sink) {
        Object object = this.streamLock;
        synchronized (object) {
            this.sinkProxy = new ByteAudioAuxSinkProxy(sink, this);
            if (this.nativeStreamPtr != 0L) {
                this.nativeAuxStreamSink = ByteAudioNativeFunctions.nativeAuxStreamSetSink(this.nativeStreamPtr, this.sinkProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                ByteAudioNativeFunctions.nativeAuxStreamSetPath(this.nativeStreamPtr, path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeAuxStreamGetName(this.nativeStreamPtr);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeAuxStreamGetId(this.nativeStreamPtr);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addInputStreamNameForMix(String stream_name) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                ByteAudioNativeFunctions.nativeAddInputStreamNameForMix(this.nativeStreamPtr, stream_name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInputStreamNameForMix() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                ByteAudioNativeFunctions.nativeClearInputStreamNameForMix(this.nativeStreamPtr);
            }
        }
    }
}

