/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioInputStream;
import com.bytedance.bae.ByteAudioSinkInterface;
import com.bytedance.bae.ByteAudioStreamBuffer;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.base.CalledByNative;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteAudioInputSinkProxy {
    private ByteBuffer pushDirectBuffer;
    private ByteAudioStreamBuffer pushStreamBuffer = null;
    private long nativeSinkPtr = 0L;
    private ByteAudioSinkInterface.ByteAudioInputSink sink = null;
    private ByteAudioInputStream stream = null;

    public ByteAudioInputSinkProxy(ByteAudioSinkInterface.ByteAudioInputSink sink, ByteAudioInputStream stream) {
        this.sink = sink;
        this.stream = stream;
        this.pushDirectBuffer = ByteBuffer.allocateDirect(15360);
        this.pushDirectBuffer.order(ByteOrder.nativeOrder());
        int type = 0;
        ByteAudioStreamFormat format = new ByteAudioStreamFormat(0, 0, type, 0);
        this.pushStreamBuffer = new ByteAudioStreamBuffer(this.pushDirectBuffer, 0, format, 0);
    }

    public void releaseProxySink() {
        this.sink = null;
        this.stream = null;
        this.pushStreamBuffer = null;
    }

    public void setNativeSink(long nativeSinkPtr) {
        this.nativeSinkPtr = nativeSinkPtr;
    }

    @CalledByNative
    public int onPushAudioBufferFromStream(long currentNativeStreamPtr) {
        int res = -1;
        if (this.sink != null) {
            this.pushDirectBuffer.position(this.pushStreamBuffer.getLength());
            this.pushDirectBuffer.flip();
            res = this.sink.onPushAudioBufferFromStream(this.stream, this.pushStreamBuffer);
            this.pushDirectBuffer.clear();
        }
        return res;
    }

    @CalledByNative
    public ByteBuffer getDirectBuffer() {
        return this.pushDirectBuffer;
    }

    @CalledByNative
    public ByteAudioStreamBuffer getStreamBuffer() {
        return this.pushStreamBuffer;
    }
}

