/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioInputSinkProxy;
import com.bytedance.bae.ByteAudioNativeFunctions;
import com.bytedance.bae.ByteAudioSinkInterface;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.ByteAudioStreamOption;
import java.util.LinkedHashMap;

public class ByteAudioInputStream {
    public ByteAudioInputSinkProxy sinkProxy = null;
    public boolean mute;
    public int gain;
    public int stream_id;
    public long nativeEnginePtr = 0L;
    public long nativeStreamPtr = 0L;
    public long nativeInputStreamSink = 0L;
    public final Object streamLock = new Object();

    public ByteAudioInputStream(long nativeEnginePtr, String name) {
        this.nativeEnginePtr = nativeEnginePtr;
        if (nativeEnginePtr != 0L) {
            this.nativeStreamPtr = ByteAudioNativeFunctions.nativeCreateInputStream(nativeEnginePtr, name);
            if (this.nativeStreamPtr == 0L) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L && this.nativeEnginePtr != 0L) {
                ByteAudioNativeFunctions.nativeDestroyInputStream(this.nativeEnginePtr, this.nativeStreamPtr);
                this.nativeStreamPtr = 0L;
                if (this.nativeInputStreamSink != 0L) {
                    ByteAudioNativeFunctions.nativeReleaseInputStreamSink(this.nativeInputStreamSink);
                    this.nativeInputStreamSink = 0L;
                }
                if (this.sinkProxy != null) {
                    this.sinkProxy.releaseProxySink();
                }
                this.sinkProxy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeInputStreamStart(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeInputStreamStop(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setGain(int gain) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                this.gain = gain;
                int res = ByteAudioNativeFunctions.nativeInputStreamSetGain(this.nativeStreamPtr, gain);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStreamFormat(ByteAudioStreamFormat streamFormat) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeInputStreamSetFormat(this.nativeStreamPtr, streamFormat);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateStreamFormat(ByteAudioStreamFormat streamFormat) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeInputStreamUpdateFormat(this.nativeStreamPtr, streamFormat);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int inputStreamSetValue(int key, ByteAudioStreamOption value) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeInputStreamSetValue(this.nativeStreamPtr, key, value);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteAudioStreamOption inputStreamGetValue(int key) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeInputStreamGetValue(this.nativeStreamPtr, key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSink(ByteAudioSinkInterface.ByteAudioInputSink sink) {
        Object object = this.streamLock;
        synchronized (object) {
            this.sinkProxy = new ByteAudioInputSinkProxy(sink, this);
            if (this.nativeStreamPtr != 0L) {
                this.nativeInputStreamSink = ByteAudioNativeFunctions.nativeInputStreamSetSink(this.nativeStreamPtr, this.sinkProxy);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap getStatsReport() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeInputStreamGetStatsReport(this.nativeStreamPtr);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeInputStreamGetName(this.nativeStreamPtr);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeInputStreamGetId(this.nativeStreamPtr);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMute(boolean enable) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeInputStreamSetMute(this.nativeStreamPtr, enable);
            }
            return -1;
        }
    }
}

