/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import android.support.annotation.NonNull;

public class ByteAudioModeStrategyTable {
    @NonNull
    public final Option buildIn;
    @NonNull
    public final Option wiredHeadset;
    @NonNull
    public final Option btHeadset;

    public ByteAudioModeStrategyTable() {
        this.buildIn = new Option(Mode.Communication, Mode.Media);
        this.wiredHeadset = new Option(Mode.Media, Mode.Media);
        this.btHeadset = new Option(Mode.Media, Mode.Media);
    }

    public ByteAudioModeStrategyTable(ByteAudioModeStrategyTable other) {
        this.buildIn = new Option(other.buildIn);
        this.wiredHeadset = new Option(other.wiredHeadset);
        this.btHeadset = new Option(other.btHeadset);
    }

    public ByteAudioModeStrategyTable(@NonNull Option buildIn, @NonNull Option wiredHeadset, @NonNull Option btHeadset) {
        this.buildIn = buildIn;
        this.wiredHeadset = wiredHeadset;
        this.btHeadset = btHeadset;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ByteAudioModeStrategyTable that = (ByteAudioModeStrategyTable)o;
        if (!this.buildIn.equals(that.buildIn)) {
            return false;
        }
        if (!this.wiredHeadset.equals(that.wiredHeadset)) {
            return false;
        }
        return this.btHeadset.equals(that.btHeadset);
    }

    public int hashCode() {
        int result = this.buildIn.hashCode();
        result = 31 * result + this.wiredHeadset.hashCode();
        result = 31 * result + this.btHeadset.hashCode();
        return result;
    }

    public static class Option {
        public Mode micOn;
        public Mode micOff;

        public Option() {
            this.micOn = Mode.Media;
            this.micOff = Mode.Media;
        }

        public Option(Mode all) {
            this.micOn = all;
            this.micOff = all;
        }

        public Option(Mode micOn, Mode micOff) {
            this.micOn = micOn;
            this.micOff = micOff;
        }

        public Option(Option other) {
            this.micOn = other.micOn;
            this.micOff = other.micOff;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Option option = (Option)o;
            return this.micOn == option.micOn && this.micOff == option.micOff;
        }

        public int hashCode() {
            int result = this.micOn.hashCode();
            result = 31 * result + this.micOff.hashCode();
            return result;
        }
    }

    public static enum Mode {
        Media(0),
        Communication(1);

        public final int value;

        private Mode(int value) {
            this.value = value;
        }
    }
}

