/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx.video.memory;

import android.opengl.EGLContext;
import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.video.RXPixelFormat;
import com.bytedance.realx.video.RXVideoMemoryType;
import com.bytedance.realx.video.RXVideoRotation;
import com.bytedance.realx.video.RXVideoScaleFilter;
import com.bytedance.realx.video.memory.RXVideoTextureMemory;

public class NativeTextureVideoMemory
extends RXVideoTextureMemory {
    private long nativeHandle;

    @CalledByNative
    public NativeTextureVideoMemory(long nativeHandle) {
        this.nativeHandle = nativeHandle;
        this.setReleaseCallback(() -> {
            if (this.nativeHandle != 0L) {
                NativeTextureVideoMemory.nativeReleaseTextureVideoMemory(this.nativeHandle);
                this.nativeHandle = 0L;
            }
        });
    }

    @Override
    public int getWidth() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeTextureVideoMemory.nativeGetWidth(this.nativeHandle);
    }

    @Override
    public int getHeight() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeTextureVideoMemory.nativeGetHeight(this.nativeHandle);
    }

    @Override
    public RXVideoRotation getRotation() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeTextureVideoMemory.nativeGetRotation(this.nativeHandle);
    }

    @Override
    public RXVideoMemoryType getMemoryType() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeTextureVideoMemory.nativeGetVideoMemoryType(this.nativeHandle);
    }

    @Override
    public int getTextureId() {
        if (this.nativeHandle == 0L) {
            return 0;
        }
        return NativeTextureVideoMemory.nativeGetTextureId(this.nativeHandle);
    }

    @Override
    public float[] getTextureMatrix() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeTextureVideoMemory.nativeGetTextureMatrix(this.nativeHandle);
    }

    @Override
    public RXPixelFormat getTextureTarget() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeTextureVideoMemory.nativeGetTextureTarget(this.nativeHandle);
    }

    @Override
    public long getNativeEGLContext() {
        if (this.nativeHandle == 0L) {
            return 0L;
        }
        return NativeTextureVideoMemory.nativeGetNativeEGLContext(this.nativeHandle);
    }

    @Override
    public EGLContext getEGLContext() {
        if (this.nativeHandle == 0L) {
            return null;
        }
        return NativeTextureVideoMemory.nativeGetJavaEGLContext(this.nativeHandle);
    }

    @Override
    public int getUnScaledWidth() {
        return NativeTextureVideoMemory.nativeGetUnscaledWidth(this.nativeHandle);
    }

    @Override
    public int getUnScaledHeight() {
        return NativeTextureVideoMemory.nativeGetUnscaledHeight(this.nativeHandle);
    }

    @Override
    public RXVideoScaleFilter getScaleFilter() {
        return NativeTextureVideoMemory.nativeGetScaleFilter(this.nativeHandle);
    }

    private static native void nativeReleaseTextureVideoMemory(long var0);

    private static native int nativeGetUnscaledWidth(long var0);

    private static native int nativeGetUnscaledHeight(long var0);

    private static native int nativeGetWidth(long var0);

    private static native int nativeGetHeight(long var0);

    private static native RXVideoRotation nativeGetRotation(long var0);

    private static native RXVideoMemoryType nativeGetVideoMemoryType(long var0);

    private static native int nativeGetTextureId(long var0);

    private static native float[] nativeGetTextureMatrix(long var0);

    private static native RXPixelFormat nativeGetTextureTarget(long var0);

    private static native long nativeGetNativeEGLContext(long var0);

    private static native EGLContext nativeGetJavaEGLContext(long var0);

    private static native RXVideoScaleFilter nativeGetScaleFilter(long var0);
}

