/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.data;

import android.content.Context;
import android.content.SharedPreferences;
import android.support.annotation.Nullable;
import org.webrtc.CalledByNative;
import org.webrtc.ContextUtils;

public class RtcPreferences {
    private static final String RTC_PREFERENCE = "rtc_preference";
    public static final String PREF_CONFIGURE = "pref_configure";
    public static final String PREF_FEEDBACK = "pref_rtc_feedback_data";
    public static final String PREF_HOST_RTT_HISTORY = "pref_host_rtt_history";
    public static final String ONER_RTC_PREFERENCE = "oner_rtc_preference";
    private static volatile RtcPreferences sInstance;
    private final SharedPreferences mSharedPreferences;

    private RtcPreferences(Context applicationContext) {
        this.mSharedPreferences = applicationContext.getSharedPreferences(RTC_PREFERENCE, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RtcPreferences instance(@Nullable Context context) {
        if (sInstance != null) return sInstance;
        Class<RtcPreferences> clazz = RtcPreferences.class;
        synchronized (RtcPreferences.class) {
            if (context == null) {
                throw new RuntimeException("unable to init RtcPreferences without context");
            }
            if (sInstance != null) return sInstance;
            sInstance = new RtcPreferences(context);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return sInstance;
        }
    }

    @CalledByNative
    public void remove(String key) {
        if (key == null) {
            return;
        }
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.remove(key);
        editor.apply();
    }

    @CalledByNative
    public void putInt(String key, int value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putInt(key, value);
        editor.apply();
    }

    @CalledByNative
    public int getInt(String key, int defValue) {
        return this.mSharedPreferences.getInt(key, defValue);
    }

    @CalledByNative
    public void putString(String key, String value) {
        SharedPreferences.Editor editor = this.mSharedPreferences.edit();
        editor.putString(key, value);
        editor.apply();
    }

    @CalledByNative
    public String getString(String key, String defValue) {
        return this.mSharedPreferences.getString(key, defValue);
    }

    @CalledByNative
    private static RtcPreferences getInstance() {
        return RtcPreferences.instance(ContextUtils.getApplicationContext());
    }
}

