/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.media.AudioFocusRequest;
import android.media.AudioManager;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

public class AudioFocusManager {
    private boolean isAudioFocusLoss = false;
    private Context mContext;
    private Callback mCallback;
    private AudioManager mAudioManager;
    private AudioManager.OnAudioFocusChangeListener onAudioFocusChangeListener;
    private Application.ActivityLifecycleCallbacks mActivityLifecycleCallback = new Application.ActivityLifecycleCallbacks(){

        public void onActivityCreated(@NonNull Activity activity, @Nullable Bundle savedInstanceState) {
        }

        public void onActivityStarted(@NonNull Activity activity) {
        }

        public void onActivityResumed(@NonNull Activity activity) {
            int result = 0;
            AudioManager audioManager = AudioFocusManager.this.getAudioManager();
            if (AudioFocusManager.this.isAudioFocusLoss && audioManager != null) {
                result = Build.VERSION.SDK_INT < 26 ? audioManager.requestAudioFocus(AudioFocusManager.this.onAudioFocusChangeListener, 3, 1) : audioManager.requestAudioFocus(new AudioFocusRequest.Builder(1).setOnAudioFocusChangeListener(AudioFocusManager.this.onAudioFocusChangeListener).build());
                if (result == 1) {
                    AudioFocusManager.this.mCallback.startMicrophone();
                    AudioFocusManager.this.mCallback.startSpeakerphone();
                }
                AudioFocusManager.this.isAudioFocusLoss = false;
            }
        }

        public void onActivityPaused(@NonNull Activity activity) {
        }

        public void onActivityStopped(@NonNull Activity activity) {
        }

        public void onActivitySaveInstanceState(@NonNull Activity activity, @NonNull Bundle outState) {
        }

        public void onActivityDestroyed(@NonNull Activity activity) {
        }
    };

    public AudioFocusManager(final Context context, Callback callback) {
        this.mContext = context;
        this.mCallback = callback;
        this.onAudioFocusChangeListener = new AudioManager.OnAudioFocusChangeListener(){
            AudioManager audioManager;
            {
                this.audioManager = (AudioManager)context.getSystemService("audio");
            }

            public void onAudioFocusChange(int focusChange) {
                if (focusChange == -2) {
                    AudioFocusManager.this.mCallback.stopSpeakerphone();
                    AudioFocusManager.this.mCallback.stopMicrophone();
                } else if (focusChange == 1) {
                    AudioFocusManager.this.mCallback.higherVolume();
                    AudioFocusManager.this.mCallback.startSpeakerphone();
                    AudioFocusManager.this.mCallback.startMicrophone();
                } else if (focusChange == -1) {
                    AudioFocusManager.this.mCallback.stopSpeakerphone();
                    AudioFocusManager.this.mCallback.stopMicrophone();
                    AudioFocusManager.this.releaseAudioFocus(true);
                } else if (focusChange == -3) {
                    AudioFocusManager.this.mCallback.lowerVolume();
                }
            }
        };
        if (this.mContext instanceof Application) {
            ((Application)this.mContext).registerActivityLifecycleCallbacks(this.mActivityLifecycleCallback);
        }
    }

    public void requestAudioFocus() {
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null) {
            if (Build.VERSION.SDK_INT < 26) {
                audioManager.requestAudioFocus(this.onAudioFocusChangeListener, 3, 1);
            } else {
                audioManager.requestAudioFocus(new AudioFocusRequest.Builder(1).setOnAudioFocusChangeListener(this.onAudioFocusChangeListener).build());
            }
            this.isAudioFocusLoss = false;
        }
    }

    public void releaseAudioFocus() {
        this.releaseAudioFocus(false);
    }

    public void release() {
        if (this.mContext instanceof Application) {
            ((Application)this.mContext).unregisterActivityLifecycleCallbacks(this.mActivityLifecycleCallback);
        }
        this.releaseAudioFocus();
    }

    private AudioManager getAudioManager() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getApplicationContext().getSystemService("audio");
        }
        return this.mAudioManager;
    }

    private void releaseAudioFocus(boolean isAudioFocusLoss) {
        AudioManager audioManager = this.getAudioManager();
        if (audioManager != null) {
            if (Build.VERSION.SDK_INT < 26) {
                audioManager.abandonAudioFocus(this.onAudioFocusChangeListener);
            } else {
                audioManager.abandonAudioFocusRequest(new AudioFocusRequest.Builder(1).setOnAudioFocusChangeListener(this.onAudioFocusChangeListener).build());
            }
            this.isAudioFocusLoss = isAudioFocusLoss;
        }
    }

    public static interface Callback {
        public void startSpeakerphone();

        public void stopSpeakerphone();

        public void startMicrophone();

        public void stopMicrophone();

        public void lowerVolume();

        public void higherVolume();
    }
}

