/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.IAudioFrameProcessor;
import com.ss.bytertc.engine.data.AudioChannel;
import com.ss.bytertc.engine.data.AudioSampleRate;
import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.utils.AudioFrameImpl;
import com.ss.bytertc.engine.utils.IAudioFrame;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.webrtc.CalledByNative;

public class NativeAudioFrameProcessor {
    private static final String TAG = "NativeAudioFrameProcessor";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public NativeAudioFrameProcessor(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public NativeAudioFrameProcessor(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    int onProcessRecordAudioFrame(IAudioFrame frame) {
        RTCVideoImpl strongVideo;
        IAudioFrameProcessor audioFilter;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFilter = strongEngine.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessRecordAudioFrame(frame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFilter = strongVideo.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessRecordAudioFrame(frame);
        }
        return -1;
    }

    @CalledByNative
    int onProcessPlayBackAudioFrame(IAudioFrame frame) {
        RTCVideoImpl strongVideo;
        IAudioFrameProcessor audioFilter;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFilter = strongEngine.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessPlayBackAudioFrame(frame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFilter = strongVideo.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessPlayBackAudioFrame(frame);
        }
        return -1;
    }

    @CalledByNative
    int onProcessRemoteUserAudioFrame(String user_id, String room_id, int stream_index, IAudioFrame frame) {
        RTCVideoImpl strongVideo;
        IAudioFrameProcessor audioFilter;
        RTCEngineImpl strongEngine;
        RemoteStreamKey stream_info = new RemoteStreamKey(room_id, user_id, StreamIndex.fromId(stream_index));
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFilter = strongEngine.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessRemoteUserAudioFrame(stream_info, frame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFilter = strongVideo.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessRemoteUserAudioFrame(stream_info, frame);
        }
        return -1;
    }

    @CalledByNative
    int onProcessEarMonitorFrame(IAudioFrame frame) {
        RTCVideoImpl strongVideo;
        IAudioFrameProcessor audioFilter;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFilter = strongEngine.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessEarMonitorAudioFrame(frame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFilter = strongVideo.getAudioFrameProcessor()) != null) {
            return audioFilter.onProcessEarMonitorAudioFrame(frame);
        }
        return -1;
    }

    @CalledByNative
    private static IAudioFrame createAudioFrameImpl(ByteBuffer buffer, int samples_per_channel, int sampleRate, int channel) {
        buffer.order(ByteOrder.nativeOrder());
        return new AudioFrameImpl(buffer, samples_per_channel, AudioSampleRate.fromId(sampleRate), AudioChannel.fromId(channel));
    }
}

