/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import com.ss.bytertc.engine.data.AudioChannel;
import com.ss.bytertc.engine.data.AudioFrameType;
import com.ss.bytertc.engine.data.AudioSampleRate;
import com.ss.bytertc.engine.utils.IAudioFrame;
import java.nio.ByteBuffer;

public class AudioFrameImpl
implements IAudioFrame {
    private ByteBuffer byteBuffer = null;
    private int samples_per_channel = 0;
    private AudioSampleRate sampleRate;
    private AudioChannel channel;
    private AudioFrameType frameType = AudioFrameType.FRAME_TYPE_PCM16;
    private long timestamp = 0L;

    @Override
    public long timestamp_us() {
        return this.timestamp;
    }

    @Override
    public AudioSampleRate sample_rate() {
        return this.sampleRate;
    }

    @Override
    public AudioChannel channel() {
        return this.channel;
    }

    @Override
    public ByteBuffer getDataBuffer() {
        return this.byteBuffer;
    }

    @Override
    public int data_size() {
        return this.samples_per_channel * this.channel.value() * 2;
    }

    @Override
    public AudioFrameType frame_type() {
        return this.frameType;
    }

    @Override
    public void release() {
    }

    public AudioFrameImpl() {
    }

    public AudioFrameImpl(byte[] buffer, int samples_per_channel, AudioSampleRate sampleRate, AudioChannel channel) {
        this(ByteBuffer.wrap(buffer), samples_per_channel, sampleRate, channel);
    }

    public AudioFrameImpl(ByteBuffer buffer, int samples_per_channel, AudioSampleRate sampleRate, AudioChannel channel) {
        this.byteBuffer = buffer;
        this.samples_per_channel = samples_per_channel;
        this.sampleRate = sampleRate;
        this.channel = channel;
    }
}

