/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.content.Context;
import android.os.Build;
import com.ss.bytertc.base.utils.RtcContextUtils;
import com.ss.bytertc.engine.utils.GetDeviceHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import org.webrtc.CalledByNative;

public final class RTCBuildInfo {
    public static final int DEVICE_INFO_UNKNOWN = -1;
    public static final int BUFFER_SIZE = 8192;
    private static final String MEMORY_INFO_PATH = "/proc/meminfo";
    private static final FileFilter CPU_FILTER = new FileFilter(){

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getName();
            if (path.startsWith("cpu")) {
                for (int i = 3; i < path.length(); ++i) {
                    if (Character.isDigit(path.charAt(i))) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
    };

    @CalledByNative
    public static String getDevice() {
        return Build.DEVICE;
    }

    @CalledByNative
    public static String getDeviceModel() {
        return Build.MODEL;
    }

    @CalledByNative
    public static String getProduct() {
        return Build.PRODUCT;
    }

    @CalledByNative
    public static String getBrand() {
        return Build.BRAND;
    }

    @CalledByNative
    public static String getDeviceManufacturer() {
        return Build.MANUFACTURER;
    }

    @CalledByNative
    public static String getAndroidBuildId() {
        return Build.ID;
    }

    @CalledByNative
    public static String getBuildType() {
        return Build.TYPE;
    }

    @CalledByNative
    public static String getBuildRelease() {
        return Build.VERSION.RELEASE;
    }

    @CalledByNative
    public static int getSdkVersion() {
        return Build.VERSION.SDK_INT;
    }

    @CalledByNative
    public static String getCpuName() {
        return Build.HARDWARE;
    }

    @CalledByNative
    public static String getGpuName() {
        return GetDeviceHelper.getGpuName();
    }

    @CalledByNative
    public static int getMemSize() {
        int memSize = 0;
        try {
            Context context = RtcContextUtils.getApplicationContext();
            if (context == null) {
                return memSize;
            }
            memSize = GetDeviceHelper.getTotalMemory(context);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return memSize;
    }

    @CalledByNative
    public static int getCpuCores() {
        int cores;
        try {
            File[] fs;
            cores = RTCBuildInfo.getCoresFromFileInfo("/sys/devices/system/cpu/possible");
            if (cores == -1) {
                cores = RTCBuildInfo.getCoresFromFileInfo("/sys/devices/system/cpu/present");
            }
            if (cores == -1 && (fs = new File("/sys/devices/system/cpu/").listFiles(CPU_FILTER)) != null) {
                cores = fs.length;
            }
        }
        catch (SecurityException e) {
            cores = -1;
        }
        catch (NullPointerException e) {
            cores = -1;
        }
        return cores;
    }

    @CalledByNative
    public static int getCpuThreads() {
        return RTCBuildInfo.getCpuCores();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CalledByNative
    public static int getCpuFrequency() {
        int maxFreq = -1;
        try {
            for (int i = 0; i < RTCBuildInfo.getCpuCores(); ++i) {
                String filename = "/sys/devices/system/cpu/cpu" + i + "/cpufreq/cpuinfo_max_freq";
                File cpuInfoMaxFreqFile = new File(filename);
                if (!cpuInfoMaxFreqFile.exists() || !cpuInfoMaxFreqFile.canRead()) continue;
                byte[] buffer = new byte[128];
                try (FileInputStream stream = new FileInputStream(cpuInfoMaxFreqFile);){
                    int endIndex;
                    int num = stream.read(buffer);
                    if (num == -1) continue;
                    for (endIndex = 0; Character.isDigit(buffer[endIndex]) && endIndex < buffer.length; ++endIndex) {
                    }
                    String str = new String(buffer, 0, endIndex, Charset.defaultCharset());
                    Integer freqBound = Integer.parseInt(str);
                    if (freqBound <= maxFreq) continue;
                    maxFreq = freqBound;
                    continue;
                }
            }
            if (maxFreq == -1) {
                String freqBoundStr = RTCBuildInfo.getValueFromCpuInfoFile("cpu MHz", "-1");
                int freqBound = (int)Double.parseDouble(freqBoundStr);
                if ((freqBound *= 1000) > maxFreq) {
                    maxFreq = freqBound;
                }
            }
        }
        catch (IOException e) {
            maxFreq = -1;
        }
        return maxFreq / 1000000;
    }

    public static String getValueFromCpuInfoFile(String key, String defaultValue) {
        FileInputStream is = null;
        BufferedReader br = null;
        String value = defaultValue;
        try {
            String text;
            is = new FileInputStream("/proc/cpuinfo");
            br = new BufferedReader(new InputStreamReader((InputStream)is, Charset.defaultCharset()));
            String split = ":";
            while ((text = br.readLine()) != null) {
                String[] str;
                if (!text.contains(":") || (str = text.split(":")).length <= 1 || !str[0].contains(key)) continue;
                value = str[1];
                break;
            }
            br.close();
            ((InputStream)is).close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int getCoresFromFileInfo(String fileLocation) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(fileLocation);
            BufferedReader buf = new BufferedReader(new InputStreamReader((InputStream)is, Charset.defaultCharset()));
            String fileContents = buf.readLine();
            buf.close();
            int n = RTCBuildInfo.getCoresFromFileString(fileContents);
            return n;
        }
        catch (IOException e) {
            int n = -1;
            return n;
        }
        finally {
            if (is != null) {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static int getCoresFromFileString(String str) {
        if (str == null || !str.matches("0-[\\d]+$")) {
            return -1;
        }
        return Integer.valueOf(str.substring(2)) + 1;
    }

    @CalledByNative
    public static String getAppRootPath() {
        String rootPath = "";
        try {
            Context context = RtcContextUtils.getApplicationContext();
            if (context == null) {
                return rootPath;
            }
            rootPath = context.getFilesDir().getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rootPath;
    }

    public static String getSerialNumber() {
        String serial = "";
        return serial;
    }

    public static String getIMEI() {
        String imei = "";
        return imei;
    }

    public static String getIMEI(Context context) {
        String imei = "";
        return imei;
    }

    @CalledByNative
    public static String getDeviceTag() {
        String deviceTag = "";
        deviceTag = RTCBuildInfo.getSerialNumber() + RTCBuildInfo.getIMEI();
        return deviceTag;
    }
}

