/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.utils;

import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.opengl.EGLContext;
import com.ss.bytertc.engine.utils.EglContextCarrier;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.utils.TextureHelper;
import com.ss.bytertc.engine.video.ITextureBuffer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.FilterType;
import org.webrtc.RendererCommon;
import org.webrtc.VideoFrame;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer,
EglContextCarrier,
ITextureBuffer {
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private FilterType scaleFilter;
    private final Matrix transformMatrix;
    private final TextureHelper textureHelper;
    private final Runnable releaseCallback;
    private final Object refCountLock = new Object();
    private int refCount;
    private YuvImage yuvImage;
    private EglBase.Context mEglBaseContext;

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, TextureHelper textureHelper, Runnable releaseCallback) {
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.textureHelper = textureHelper;
        this.releaseCallback = releaseCallback;
        this.refCount = 1;
    }

    @CalledByNative
    public TextureBufferImpl(int width, int height, int type, final int id, final TextureHelper textureHelper) {
        this.width = width;
        this.height = height;
        this.type = type == VideoFrame.TextureBuffer.Type.OES.getGlTarget() ? VideoFrame.TextureBuffer.Type.OES : VideoFrame.TextureBuffer.Type.RGB;
        this.id = id;
        this.transformMatrix = new Matrix();
        this.transformMatrix.reset();
        this.textureHelper = textureHelper;
        this.releaseCallback = new Runnable(){

            @Override
            public void run() {
                textureHelper.releaseTextureID(id);
            }
        };
        this.refCount = 1;
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    @CalledByNative
    public int getTypeGlTarget() {
        return this.type.getGlTarget();
    }

    @Override
    @CalledByNative
    public int getTextureId() {
        return this.id;
    }

    @Override
    @CalledByNative
    public long getNativeEglContext() {
        if (this.textureHelper != null) {
            return this.textureHelper.getNativeEglContext();
        }
        return 0L;
    }

    @Override
    public EGLContext getEglContext() {
        if (this.textureHelper != null) {
            return this.textureHelper.getEglBaseContext().getEgl14Context();
        }
        return null;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    @CalledByNative
    public float[] nativeGetTransFormMatrix() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @CalledByNative
    public void setTransFormMatrix(float[] matrix) {
        RendererCommon.convertMatrixToAndroidGraphicsMatrix(matrix);
    }

    @CalledByNative
    public TextureHelper getTextureHelper() {
        return this.textureHelper;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    @CalledByNative
    public FilterType getScaleFilter() {
        return FilterType.Origin;
    }

    @Override
    @CalledByNative
    public int getUnscaledWidth() {
        return this.width;
    }

    @Override
    @CalledByNative
    public int getUnscaledHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        return this.textureHelper.textureToYuv(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CalledByNative
    public void retain() {
        Object object = this.refCountLock;
        synchronized (object) {
            ++this.refCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @CalledByNative
    public void release() {
        Object object = this.refCountLock;
        synchronized (object) {
            if (--this.refCount == 0 && this.releaseCallback != null) {
                this.releaseCallback.run();
            }
        }
    }

    @Override
    @CalledByNative
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        this.retain();
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        this.scaleFilter = null;
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(cropAndScaleMatrix);
        return new TextureBufferImpl(scaleWidth, scaleHeight, this.type, this.id, newMatrix, this.textureHelper, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }

    @Override
    public VideoFrame.Buffer cropAndScaleWithFilter(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int scaleFilter) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        this.scaleFilter = FilterType.fromValue(scaleFilter);
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(cropAndScaleMatrix);
        return new TextureBufferImpl(scaleWidth, scaleHeight, this.type, this.id, newMatrix, this.textureHelper, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int dstWidth, int dstHeight, int offsetX, int offsetY) {
        Matrix scaleAndFillMatrix = new Matrix();
        int src_scaled_width = Math.min(dstWidth, this.getWidth() * dstHeight / this.getHeight());
        int src_scaled_height = Math.min(dstHeight, this.getHeight() * dstWidth / this.getWidth());
        scaleAndFillMatrix.preScale((float)src_scaled_width / (float)this.getWidth(), (float)src_scaled_height / (float)this.getHeight());
        int offsetYFromBottom = dstHeight - (offsetY + src_scaled_height);
        scaleAndFillMatrix.preTranslate((float)(offsetX / dstWidth), (float)(offsetYFromBottom / dstHeight));
        return new TextureBufferImpl(dstWidth, dstHeight, this.type, this.id, scaleAndFillMatrix, this.textureHelper, new Runnable(){

            @Override
            public void run() {
                TextureBufferImpl.this.release();
            }
        });
    }

    public void saveMyBitmap(String filePath, byte[] data, int width, int high) {
        LogUtil.i("texturebuffer", "saveMyBitmap");
        File f = new File(filePath);
        try {
            f.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        FileOutputStream fOut = null;
        try {
            fOut = new FileOutputStream(f);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        YuvImage yuvImage = new YuvImage(data, 17, this.width, this.height, null);
        try {
            yuvImage.compressToJpeg(new Rect(0, 0, this.width, this.height), 50, (OutputStream)fOut);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fOut.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            fOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setEglBaseContext(EglBase.Context context) {
        this.mEglBaseContext = context;
    }

    @Override
    public EglBase.Context getEglBaseContext() {
        return this.mEglBaseContext;
    }
}

