/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video.converter;

import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.video.VideoFrame;
import java.nio.ByteBuffer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

public class WebRTCConverter {
    public static org.webrtc.VideoFrame convertByteTexFrame2WebrtcTexFrame(VideoFrame byteVideoFrame, Looper textureProcessLooper) {
        if (byteVideoFrame.getFrameType() != VideoFrameType.kVideoFrameTypeGLTexture) {
            return null;
        }
        if (textureProcessLooper == null) {
            return null;
        }
        Matrix matrix = RendererCommon.convertMatrixToAndroidGraphicsMatrix(byteVideoFrame.getTextureMatrix());
        VideoFrame.TextureBuffer.Type type = byteVideoFrame.getPixelFormat() == VideoPixelFormat.kVideoPixelFormatTexture2D ? VideoFrame.TextureBuffer.Type.RGB : VideoFrame.TextureBuffer.Type.OES;
        byteVideoFrame.retain();
        TextureBufferImpl buffer = new TextureBufferImpl(byteVideoFrame.getWidth(), byteVideoFrame.getHeight(), type, byteVideoFrame.getTextureID(), matrix, new Handler(textureProcessLooper), new YuvConverter(), byteVideoFrame::release);
        return new org.webrtc.VideoFrame(buffer, byteVideoFrame.getRotation().value(), byteVideoFrame.getTimeStampUs());
    }

    public static org.webrtc.VideoFrame convertByteI420Frame2WebrtcI420Frame(VideoFrame byteVideoFrame) {
        if (byteVideoFrame.getFrameType() != VideoFrameType.kVideoFrameTypeRawMemory) {
            return null;
        }
        if (byteVideoFrame.getPixelFormat() != VideoPixelFormat.kVideoPixelFormatI420) {
            return null;
        }
        byteVideoFrame.retain();
        int width = byteVideoFrame.getWidth();
        int height = byteVideoFrame.getHeight();
        ByteBuffer bufferY = byteVideoFrame.getPlaneData(0);
        ByteBuffer bufferU = byteVideoFrame.getPlaneData(1);
        ByteBuffer bufferV = byteVideoFrame.getPlaneData(2);
        int strideY = byteVideoFrame.getPlaneStride(0);
        int strideU = byteVideoFrame.getPlaneStride(1);
        int strideV = byteVideoFrame.getPlaneStride(2);
        JavaI420Buffer i420Buffer = JavaI420Buffer.wrap(width, height, bufferY, strideY, bufferU, strideU, bufferV, strideV, byteVideoFrame::release);
        return new org.webrtc.VideoFrame(i420Buffer, byteVideoFrame.getRotation().value(), byteVideoFrame.getTimeStampUs());
    }
}

