/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.content.Context;
import android.media.AudioFormat;
import android.media.AudioManager;
import android.media.AudioPlaybackCaptureConfiguration;
import android.media.AudioRecord;
import android.media.projection.MediaProjection;
import android.os.Build;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.v4.content.ContextCompat;
import android.util.Log;
import java.lang.ref.WeakReference;
import org.webrtc.ScreenAudioCaptureObserver;

public class ScreenAudioCaptureAndroidManager
extends MediaProjection.Callback {
    private static final int NUM_SAMPLES_PER_READ = 1024;
    private static final int SAMPLE_RATE = 48000;
    private ScreenAudioCaptureObserver mCaptureObserver;
    private WeakReference<Context> mContextRef;
    private MediaProjection mMediaProjection;
    private boolean mIsDisposed;
    private AudioRecord mAudioRecord;
    private volatile boolean mIsRecording;
    private int mAudioMode;
    private Thread mRecordingThread;
    private HandlerThread sHandlerThread = new HandlerThread("sdk-audio-share");
    private Handler sHandler;

    public static ScreenAudioCaptureAndroidManager INSTANCE() {
        return HOLDER.INSTANCE;
    }

    private ScreenAudioCaptureAndroidManager() {
        this.sHandlerThread.start();
        this.sHandler = new Handler(this.sHandlerThread.getLooper());
        this.mIsRecording = false;
        this.mCaptureObserver = null;
        this.mAudioRecord = null;
        this.mRecordingThread = null;
        this.mIsDisposed = false;
    }

    private void checkNotDisposed() {
        if (this.mIsDisposed) {
            throw new RuntimeException("screen audio capturer is disposed.");
        }
    }

    public void initialize(Context applicationContext, ScreenAudioCaptureObserver captureObserver) {
        if (captureObserver == null) {
            throw new RuntimeException("audio capture observer not set.");
        }
        this.mCaptureObserver = captureObserver;
        this.mContextRef = new WeakReference<Context>(applicationContext);
        this.mIsDisposed = false;
    }

    private void setMusicMode(boolean music) {
        AudioManager audioManager = (AudioManager)((Context)this.mContextRef.get()).getSystemService("audio");
        try {
            if (music) {
                this.mAudioMode = audioManager.getMode();
                audioManager.setMode(0);
            } else {
                audioManager.setMode(this.mAudioMode);
            }
        }
        catch (Exception e) {
            Log.e((String)"ScreenAudioCapture", (String)(music + ", " + e.getMessage()));
        }
    }

    public void startAudioCapture(MediaProjection projection) {
        this.checkNotDisposed();
        this.sHandler.post(() -> this.startAudioCapture_(projection));
    }

    private void startAudioCapture_(MediaProjection projection) {
        if (Build.VERSION.SDK_INT <= 28) {
            return;
        }
        if (this.mIsRecording) {
            return;
        }
        this.mMediaProjection = projection;
        if (this.mMediaProjection == null) {
            return;
        }
        AudioPlaybackCaptureConfiguration config = new AudioPlaybackCaptureConfiguration.Builder(this.mMediaProjection).addMatchingUsage(1).addMatchingUsage(14).addMatchingUsage(0).build();
        AudioFormat audioFormat = new AudioFormat.Builder().setEncoding(2).setSampleRate(48000).setChannelMask(16).build();
        try {
            this.mAudioRecord = new AudioRecord.Builder().setAudioFormat(audioFormat).setBufferSizeInBytes(2048).setAudioPlaybackCaptureConfig(config).build();
        }
        catch (UnsupportedOperationException e) {
            Log.e((String)"ScreenAudioCapture", (String)e.getMessage());
            return;
        }
        if (this.mAudioRecord.getState() == 0) {
            boolean permission2 = ScreenAudioCaptureAndroidManager.hasPermissions((Context)this.mContextRef.get(), "android.permission.RECORD_AUDIO");
            Log.e((String)"ScreenAudioCapture", (String)("audioRecord init fail, permission: " + permission2));
            this.mAudioRecord = null;
            return;
        }
        this.mMediaProjection.registerCallback((MediaProjection.Callback)this, this.sHandler);
        this.mCaptureObserver.onCapturerStarted();
        this.setMusicMode(true);
        this.mIsRecording = true;
        this.mAudioRecord.startRecording();
        this.mRecordingThread = new Thread(this::doRun);
        this.mRecordingThread.start();
        this.setMusicMode(false);
    }

    private void doRun() {
        short[] sData = new short[1024];
        Thread local = this.mRecordingThread;
        int ret = 0;
        while (this.mIsRecording && this.mAudioRecord != null) {
            ret = this.mAudioRecord.read(sData, 0, 1024);
            if (ret < 0) continue;
            byte[] bData = this.short2byte(sData);
            if (this.mCaptureObserver == null) break;
            this.mCaptureObserver.onAudioFrameCapture(bData, 1024, 48000, 1);
        }
    }

    public void dispose() {
        this.mIsDisposed = true;
    }

    public void onStop() {
        super.onStop();
        this.stopAudioCapture_();
    }

    public void stopAudioCapture() {
        this.checkNotDisposed();
        if (this.mMediaProjection != null) {
            this.mMediaProjection.unregisterCallback((MediaProjection.Callback)this);
        }
        this.sHandler.removeCallbacksAndMessages(null);
        this.sHandler.post(this::stopAudioCapture_);
    }

    private void stopAudioCapture_() {
        if (Build.VERSION.SDK_INT <= 28) {
            return;
        }
        if (!this.mIsRecording) {
            return;
        }
        this.mIsRecording = false;
        if (this.mAudioRecord != null) {
            this.mAudioRecord.stop();
            this.mAudioRecord.release();
            this.mAudioRecord = null;
        }
        this.mCaptureObserver.onCapturerStopped();
        this.mMediaProjection = null;
    }

    private byte[] short2byte(short[] sData) {
        int shortArrsize = sData.length;
        byte[] bytes = new byte[shortArrsize * 2];
        for (int i = 0; i < shortArrsize; ++i) {
            bytes[i * 2] = (byte)(sData[i] & 0xFF);
            bytes[i * 2 + 1] = (byte)(sData[i] >> 8);
            sData[i] = 0;
        }
        return bytes;
    }

    private static boolean hasPermissions(Context context, String ... perms) {
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        for (String perm : perms) {
            boolean hasPerm = ScreenAudioCaptureAndroidManager.selfPermissionGranted(context, perm);
            if (hasPerm) continue;
            return false;
        }
        return true;
    }

    private static boolean selfPermissionGranted(Context context, String permission2) {
        boolean ret = true;
        if (Build.VERSION.SDK_INT >= 23) {
            ret = context.getApplicationInfo().targetSdkVersion >= 23 ? context.checkSelfPermission(permission2) == 0 : ContextCompat.checkSelfPermission((Context)context, (String)permission2) == 0;
        }
        return ret;
    }

    private static final class HOLDER {
        private static final ScreenAudioCaptureAndroidManager INSTANCE = new ScreenAudioCaptureAndroidManager();

        private HOLDER() {
        }
    }
}

