/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Build;
import java.util.concurrent.CountDownLatch;
import org.webrtc.CameraSession;
import org.webrtc.CapturerObserver;
import org.webrtc.ContextUtils;
import org.webrtc.EglBase;
import org.webrtc.RXScreenCaptureService;
import org.webrtc.ScreenCaptureAndroidManager;
import org.webrtc.SurfaceTextureHelper;
import org.webrtc.VideoCapturer;
import org.webrtc.VideoFrame;
import org.webrtc.VideoSink;

@TargetApi(value=21)
public class ScreenCapturerAndroid
implements VideoCapturer,
VideoSink {
    private Context mContext;
    private CountDownLatch mCountDownLatch = new CountDownLatch(1);
    private boolean needStartService = true;

    public ScreenCapturerAndroid(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback) {
        this(mediaProjectionPermissionResultData, mediaProjectionCallback, true);
    }

    public ScreenCapturerAndroid(Intent mediaProjectionPermissionResultData, MediaProjection.Callback mediaProjectionCallback, boolean needStartService) {
        ScreenCaptureAndroidManager.INSTANCE().addLock(this.mCountDownLatch.hashCode(), this.mCountDownLatch);
        ScreenCaptureAndroidManager.INSTANCE().setData(mediaProjectionPermissionResultData, mediaProjectionCallback);
        this.needStartService = needStartService;
    }

    public synchronized void initialize(EglBase.Context sharedContext, Context applicationContext, CapturerObserver capturerObserver) {
        this.mContext = applicationContext;
        ScreenCaptureAndroidManager.INSTANCE().initialize(sharedContext, applicationContext, capturerObserver);
    }

    @Override
    public synchronized void initialize(SurfaceTextureHelper surfaceTextureHelper, Context applicationContext, CapturerObserver capturerObserver) {
        this.mContext = applicationContext;
        ScreenCaptureAndroidManager.INSTANCE().initialize(surfaceTextureHelper, applicationContext, capturerObserver);
    }

    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate, int min_framerate) {
        if (!this.needStartService || Build.VERSION.SDK_INT <= 28) {
            ScreenCaptureAndroidManager.INSTANCE().startCapture(width, height, ignoredFramerate, min_framerate);
        } else {
            Intent data = new Intent();
            data.putExtra("w", width);
            data.putExtra("h", height);
            data.putExtra("if", ignoredFramerate);
            data.putExtra("minfr", min_framerate > 0 ? min_framerate : 4);
            this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 1, data));
        }
    }

    @Override
    public synchronized void startCapture(int width, int height, int ignoredFramerate) {
        this.startCapture(width, height, ignoredFramerate, 4);
    }

    @Override
    public synchronized void stopCapture() {
        if (!this.needStartService || Build.VERSION.SDK_INT <= 28) {
            ScreenCaptureAndroidManager.INSTANCE().stopCapture();
        } else {
            Intent data = new Intent();
            int code = this.mCountDownLatch.hashCode();
            data.putExtra("hc", code);
            this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 2, data));
        }
    }

    @Override
    public synchronized void dispose() {
        if (!this.needStartService || Build.VERSION.SDK_INT <= 28) {
            ScreenCaptureAndroidManager.INSTANCE().dispose();
        } else {
            this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 5, null));
        }
    }

    @Override
    public synchronized void changeCaptureFormat(int width, int height, int ignoredFramerate) {
        if (!this.needStartService || Build.VERSION.SDK_INT <= 28) {
            ScreenCaptureAndroidManager.INSTANCE().changeCaptureFormat(width, height, ignoredFramerate);
        } else {
            Intent data = new Intent();
            data.putExtra("w", width);
            data.putExtra("h", height);
            data.putExtra("if", ignoredFramerate);
            this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 3, data));
        }
    }

    @Override
    public boolean isCameraTorchSupported() {
        return false;
    }

    @Override
    public void turnOnFlashLight() {
    }

    @Override
    public void turnOffFlashLight() {
    }

    @Override
    public boolean isCameraZoomSupported() {
        return false;
    }

    @Override
    public int setCameraZoomRatio(float zoom_val) {
        return 0;
    }

    @Override
    public float getCameraZoomMaxRatio() {
        return 1.0f;
    }

    @Override
    public int enableFollowGravity(boolean enable) {
        return -1;
    }

    @Override
    public int getDeviceOrientation() {
        return CameraSession.getDeviceUIOrientation(ContextUtils.getApplicationContext());
    }

    @Override
    public void onFrame(VideoFrame frame) {
        if (!this.needStartService || Build.VERSION.SDK_INT <= 28) {
            ScreenCaptureAndroidManager.INSTANCE().onFrame(frame);
        } else {
            int index = ScreenCaptureAndroidManager.INSTANCE().addFrame(frame);
            Intent data = new Intent();
            data.putExtra("i", index);
            this.mContext.startForegroundService(RXScreenCaptureService.getServiceIntent(this.mContext, 4, data));
        }
    }

    @Override
    public boolean isScreencast() {
        return true;
    }

    public MediaProjection getMediaProjection() {
        return ScreenCaptureAndroidManager.INSTANCE().getMediaProjection();
    }
}

