/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.graphics.Matrix;
import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Build;
import android.os.Handler;
import android.support.annotation.Nullable;
import org.webrtc.FilterType;
import org.webrtc.RefCountDelegate;
import org.webrtc.RendererCommon;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

public class TextureBufferImpl
implements VideoFrame.TextureBuffer {
    private final int unscaledWidth;
    private final int unscaledHeight;
    private final int width;
    private final int height;
    private final VideoFrame.TextureBuffer.Type type;
    private final int id;
    private FilterType scaleFilter;
    private final Matrix transformMatrix;
    private final Handler toI420Handler;
    private final YuvConverter yuvConverter;
    private final RefCountDelegate refCountDelegate;

    public TextureBufferImpl(int width, int height, VideoFrame.TextureBuffer.Type type, int id, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this.unscaledWidth = width;
        this.unscaledHeight = height;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    private TextureBufferImpl(int unscaledWidth, int unscaledHeight, int width, int height, VideoFrame.TextureBuffer.Type type, int id, FilterType scaleFilter, Matrix transformMatrix, Handler toI420Handler, YuvConverter yuvConverter, @Nullable Runnable releaseCallback) {
        this.unscaledWidth = unscaledWidth;
        this.unscaledHeight = unscaledHeight;
        this.width = width;
        this.height = height;
        this.type = type;
        this.id = id;
        this.scaleFilter = scaleFilter;
        this.transformMatrix = transformMatrix;
        this.toI420Handler = toI420Handler;
        this.yuvConverter = yuvConverter;
        this.refCountDelegate = new RefCountDelegate(releaseCallback);
    }

    @Override
    public EGLContext getEglContext() {
        if (this.toI420Handler == null) {
            return null;
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> EGL14.eglGetCurrentContext());
    }

    @Override
    public long getNativeEglContext() {
        EGLContext eglContext = this.getEglContext();
        if (eglContext == null) {
            return 0L;
        }
        return Build.VERSION.SDK_INT >= 21 ? eglContext.getNativeHandle() : (long)eglContext.getHandle();
    }

    @Override
    public VideoFrame.TextureBuffer.Type getType() {
        return this.type;
    }

    @Override
    public int getTextureId() {
        return this.id;
    }

    @Override
    public Matrix getTransformMatrix() {
        return this.transformMatrix;
    }

    @Override
    public int getTypeGlTarget() {
        return this.type.getGlTarget();
    }

    @Override
    public FilterType getScaleFilter() {
        return this.scaleFilter;
    }

    @Override
    public float[] nativeGetTransFormMatrix() {
        return RendererCommon.convertMatrixFromAndroidGraphicsMatrix(this.transformMatrix);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public VideoFrame.I420Buffer toI420() {
        if (this.scaleFilter == null || this.scaleFilter == FilterType.Origin) {
            return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convert(this));
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.toI420Handler, () -> this.yuvConverter.convert(this, this.scaleFilter, this.unscaledWidth, this.unscaledHeight));
    }

    @Override
    public void retain() {
        this.refCountDelegate.retain();
    }

    @Override
    public void release() {
        this.refCountDelegate.release();
    }

    @Override
    public VideoFrame.Buffer cropAndScale(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        this.scaleFilter = FilterType.Origin;
        return this.applyTransformMatrix(cropAndScaleMatrix, Math.round((float)(this.unscaledWidth * cropWidth) / (float)this.width), Math.round((float)(this.unscaledHeight * cropHeight) / (float)this.height), scaleWidth, scaleHeight);
    }

    @Override
    public VideoFrame.Buffer cropAndScaleWithFilter(int cropX, int cropY, int cropWidth, int cropHeight, int scaleWidth, int scaleHeight, int scaleFilterVal) {
        Matrix cropAndScaleMatrix = new Matrix();
        int cropYFromBottom = this.height - (cropY + cropHeight);
        cropAndScaleMatrix.preTranslate((float)cropX / (float)this.width, (float)cropYFromBottom / (float)this.height);
        cropAndScaleMatrix.preScale((float)cropWidth / (float)this.width, (float)cropHeight / (float)this.height);
        this.scaleFilter = FilterType.fromValue(scaleFilterVal);
        return this.applyTransformMatrix(cropAndScaleMatrix, Math.round((float)(this.unscaledWidth * cropWidth) / (float)this.width), Math.round((float)(this.unscaledHeight * cropHeight) / (float)this.height), scaleWidth, scaleHeight);
    }

    @Override
    public VideoFrame.Buffer scaleAndFill(int dstWidth, int dstHeight, int offsetX, int offsetY) {
        Matrix scaleAndFillMatrix = new Matrix();
        int src_scaled_width = Math.min(dstWidth, this.getWidth() * dstHeight / this.getHeight());
        int src_scaled_height = Math.min(dstHeight, this.getHeight() * dstWidth / this.getWidth());
        scaleAndFillMatrix.preScale((float)src_scaled_width / (float)this.getWidth(), (float)src_scaled_height / (float)this.getHeight());
        int offsetYFromBottom = dstHeight - (offsetY + src_scaled_height);
        scaleAndFillMatrix.preTranslate((float)(offsetX / dstWidth), (float)(offsetYFromBottom / dstHeight));
        return this.applyTransformMatrix(scaleAndFillMatrix, dstWidth, dstHeight);
    }

    @Override
    public int getUnscaledWidth() {
        return this.unscaledWidth;
    }

    @Override
    public int getUnscaledHeight() {
        return this.unscaledHeight;
    }

    public TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int newWidth, int newHeight) {
        return this.applyTransformMatrix(transformMatrix, newWidth, newHeight, newWidth, newHeight);
    }

    private TextureBufferImpl applyTransformMatrix(Matrix transformMatrix, int unscaledWidth, int unscaledHeight, int scaledWidth, int scaledHeight) {
        Matrix newMatrix = new Matrix(this.transformMatrix);
        newMatrix.preConcat(transformMatrix);
        this.retain();
        return new TextureBufferImpl(unscaledWidth, unscaledHeight, scaledWidth, scaledHeight, this.type, this.id, this.scaleFilter, newMatrix, this.toI420Handler, this.yuvConverter, this::release);
    }
}

