/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioNativeFunctions;
import com.bytedance.bae.ByteAudioOutputSinkProxy;
import com.bytedance.bae.ByteAudioSinkInterface;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.ByteAudioStreamOption;
import java.util.LinkedHashMap;

public class ByteAudioOutputStream {
    public ByteAudioOutputSinkProxy sinkProxy = null;
    public boolean mute;
    public int gain;
    public int stream_id;
    public long nativeEnginePtr = 0L;
    public long nativeStreamPtr = 0L;
    public long nativeOutputStreamSink = 0L;
    public final Object streamLock = new Object();

    public ByteAudioOutputStream(long nativeEnginePtr, String name) {
        this.nativeEnginePtr = nativeEnginePtr;
        if (nativeEnginePtr != 0L) {
            this.nativeStreamPtr = ByteAudioNativeFunctions.nativeCreateOutputStream(nativeEnginePtr, name);
            if (this.nativeStreamPtr == 0L) {
                // empty if block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L && this.nativeEnginePtr != 0L) {
                ByteAudioNativeFunctions.nativeDestroyOutputStream(this.nativeEnginePtr, this.nativeStreamPtr);
                this.nativeStreamPtr = 0L;
                if (this.nativeOutputStreamSink != 0L) {
                    ByteAudioNativeFunctions.nativeReleaseOutputStreamSink(this.nativeOutputStreamSink);
                    this.nativeOutputStreamSink = 0L;
                }
                if (this.sinkProxy != null) {
                    this.sinkProxy.releaseProxySink();
                }
                this.sinkProxy = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int startStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeOutputStreamStart(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int stopStream() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeOutputStreamStop(this.nativeStreamPtr);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setGain(int gain) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                this.gain = gain;
                int res = ByteAudioNativeFunctions.nativeOutputStreamSetGain(this.nativeStreamPtr, gain);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setGain(int gain, int fadeInterval) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                this.gain = gain;
                int res = ByteAudioNativeFunctions.nativeOutputStreamSetGainWithFade(this.nativeStreamPtr, gain, fadeInterval);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setStreamFormat(ByteAudioStreamFormat streamFormat) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeOutputStreamSetFormat(this.nativeStreamPtr, streamFormat);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int outputStreamSetValue(int key, ByteAudioStreamOption value) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                int res = ByteAudioNativeFunctions.nativeOutputStreamSetValue(this.nativeStreamPtr, key, value);
                return res;
            }
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ByteAudioStreamOption outputStreamGetValue(int key) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeOutputStreamGetValue(this.nativeStreamPtr, key);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSink(ByteAudioSinkInterface.ByteAudioOutputSink sink) {
        Object object = this.streamLock;
        synchronized (object) {
            this.sinkProxy = new ByteAudioOutputSinkProxy(sink, this);
            if (this.nativeStreamPtr != 0L) {
                this.nativeOutputStreamSink = ByteAudioNativeFunctions.nativeOutputStreamSetSink(this.nativeStreamPtr, this.sinkProxy);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap getStatsReport() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeOutputStreamGetStatsReport(this.nativeStreamPtr);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getName() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeOutputStreamGetName(this.nativeStreamPtr);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getID() {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeOutputStreamGetId(this.nativeStreamPtr);
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setMute(boolean enable) {
        Object object = this.streamLock;
        synchronized (object) {
            if (this.nativeStreamPtr != 0L) {
                return ByteAudioNativeFunctions.nativeOutputStreamSetMute(this.nativeStreamPtr, enable);
            }
            return -1;
        }
    }
}

