/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.base;

import android.support.annotation.Nullable;
import com.bytedance.bae.base.Logging;
import com.bytedance.bae.base.NativeLibraryLoadListener;
import com.bytedance.bae.base.NativeLibraryLoader;

class NativeLibrary {
    private static String TAG = "NativeLibrary";
    private static Object lock = new Object();
    private static boolean libraryLoaded;
    @Nullable
    private static NativeLibraryLoadListener loadListener;

    NativeLibrary() {
    }

    static void setLoadListener(NativeLibraryLoadListener ll) {
        loadListener = ll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void initialize(NativeLibraryLoader loader, String libraryName) {
        Object object = lock;
        synchronized (object) {
            if (libraryLoaded) {
                Logging.i(TAG, "Native library has already been loaded.");
                if (loadListener != null) {
                    loadListener.onLoadAlready(libraryName);
                }
                return;
            }
            Logging.i(TAG, "Loading native library: " + libraryName);
            libraryLoaded = loader.load(libraryName);
            if (loadListener != null) {
                if (libraryLoaded) {
                    loadListener.onLoadSuccess(libraryName);
                } else {
                    loadListener.onLoadError(libraryName);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isLoaded() {
        Object object = lock;
        synchronized (object) {
            return libraryLoaded;
        }
    }

    static void disposeListener() {
        if (loadListener != null) {
            loadListener = null;
        }
    }

    static class DefaultLoader
    implements NativeLibraryLoader {
        DefaultLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean load(String name) {
            Logging.i(TAG, "Loading library: " + name);
            try {
                Object object = lock;
                synchronized (object) {
                    System.loadLibrary(name);
                }
            }
            catch (UnsatisfiedLinkError e) {
                Logging.e(TAG, "Failed to load native library: " + name, e);
                return false;
            }
            return true;
        }
    }
}

