/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx;

import android.content.Context;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.base.RXLogging;
import dalvik.system.BaseDexClassLoader;
import org.webrtc.ContextUtils;

public class Utils {
    private static Context mContext;

    public static void SetContext(Context context) {
        mContext = context;
    }

    @CalledByNative
    public static String getAppPath() {
        RXLogging.enableLogToDebugOutput(RXLogging.Severity.LS_INFO);
        RXLogging.i("Utils", "this is jni logging test");
        if (mContext == null) {
            mContext = ContextUtils.getApplicationContext();
        }
        return mContext.getExternalFilesDir("").toString();
    }

    @CalledByNative
    public static String getAppLibPath(String libName) {
        if (mContext == null) {
            mContext = ContextUtils.getApplicationContext();
        }
        if (TextUtils.isEmpty((CharSequence)libName)) {
            return "";
        }
        String libPath = "";
        try {
            BaseDexClassLoader classLoader = (BaseDexClassLoader)mContext.getClassLoader();
            libPath = classLoader.findLibrary(libName);
            if (libPath == null) {
                libPath = "";
            }
        }
        catch (Exception e) {
            RXLogging.e("realx Utils", "getAppLibPath Exception : " + e.getMessage());
            Log.e((String)"realx Utils", (String)("getAppLibPath Exception : " + e.getMessage()));
            throw e;
        }
        return libPath;
    }
}

