/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import com.ss.bytertc.engine.NativeAudioMixingManagerFunctions;
import com.ss.bytertc.engine.audio.IAudioMixingManager;
import com.ss.bytertc.engine.data.AudioMixingConfig;
import com.ss.bytertc.engine.data.AudioMixingDualMonoMode;
import com.ss.bytertc.engine.data.AudioMixingType;
import com.ss.bytertc.engine.utils.AudioFrame;
import com.ss.bytertc.engine.utils.LogUtil;

public class AudioMixingManager
extends IAudioMixingManager {
    private static final String TAG = "AudioMixingManager";
    private long mNativeAudioMixingManager = 0L;

    public AudioMixingManager(long nativeAudioMixingManager) {
        this.mNativeAudioMixingManager = nativeAudioMixingManager;
    }

    @Override
    public synchronized void startAudioMixing(int mixId, String filePath, AudioMixingConfig config) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, StartAudioMixing failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeStartAudioMixing(this.mNativeAudioMixingManager, mixId, filePath, config.type.value(), config.playCount, config.position, config.callbackOnProgressInterval);
    }

    @Override
    public synchronized void stopAudioMixing(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, StopAudioMixing failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeStopAudioMixing(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized void pauseAudioMixing(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, PauseAudioMixing failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativePauseAudioMixing(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized void resumeAudioMixing(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, ResumeAudioMixing failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeResumeAudioMixing(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized void preloadAudioMixing(int mixId, String file_path) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, PreloadAudioMixing failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativePreloadAudioMixing(this.mNativeAudioMixingManager, mixId, file_path);
    }

    @Override
    public synchronized void unloadAudioMixing(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, UnloadAudioMixing failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeUnloadAudioMixing(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized void setAllAudioMixingVolume(int volume, AudioMixingType type) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, SetAllAudioMixingVolume failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAllAudioMixingVolume(this.mNativeAudioMixingManager, volume, type.value());
    }

    @Override
    public synchronized void setAudioMixingVolume(int mixId, int volume, AudioMixingType type) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, SetAudioMixingVolume failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAudioMixingVolume(this.mNativeAudioMixingManager, mixId, volume, type.value());
    }

    @Override
    public synchronized int getAudioMixingDuration(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, GetAudioMixingDuration failed.");
            return -1;
        }
        return NativeAudioMixingManagerFunctions.nativeGetAudioMixingDuration(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized int getAudioMixingCurrentPosition(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, GetAudioMixingCurrentPosition failed.");
            return -1;
        }
        return NativeAudioMixingManagerFunctions.nativeGetAudioMixingCurrentPosition(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized int getAudioMixingPlaybackDuration(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, getAudioMixingPlaybackDuration failed.");
            return -1;
        }
        return NativeAudioMixingManagerFunctions.nativeGetAudioMixingPlaybackDuration(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized void setAudioMixingPosition(int mixId, int position) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, SetAudioMixingPosition failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAudioMixingPosition(this.mNativeAudioMixingManager, mixId, position);
    }

    @Override
    public synchronized void setAudioMixingPitch(int mixId, int pitch) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, setAudioMixingPitch failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAudioMixingPitch(this.mNativeAudioMixingManager, mixId, pitch);
    }

    @Override
    public synchronized int setAudioMixingPlaybackSpeed(int mixId, int speed) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, setAudioMixingPlaybackSpeed failed.");
            return -1;
        }
        return NativeAudioMixingManagerFunctions.nativeSetAudioMixingPlaybackSpeed(this.mNativeAudioMixingManager, mixId, speed);
    }

    @Override
    public synchronized void setAudioMixingDualMonoMode(int mixId, AudioMixingDualMonoMode mode) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, setAudioMixingDualMonoMode failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAudioMixingDualMonoMode(this.mNativeAudioMixingManager, mixId, mode.value());
    }

    @Override
    public synchronized void setAudioMixingProgressInterval(int mixId, long interval) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, setAudioMixingProgressInterval failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAudioMixingProgressInterval(this.mNativeAudioMixingManager, mixId, interval);
    }

    @Override
    public synchronized void setAudioMixingLoudness(int mixId, float loudness) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, setAudioMixingLoudness failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSetAudioMixingLoudness(this.mNativeAudioMixingManager, mixId, loudness);
    }

    @Override
    public synchronized void enableAudioMixingFrame(int mixId, AudioMixingType type) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, EnableAudioMixingFrame failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeEnableAudioMixingFrame(this.mNativeAudioMixingManager, mixId, type.value());
    }

    @Override
    public synchronized void disableAudioMixingFrame(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, DisableAudioMixingFrame failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeDisableAudioMixingFrame(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized int pushAudioMixingFrame(int mixId, AudioFrame audioFrame) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, PushAudioMixingFrame failed.");
            return -1;
        }
        return NativeAudioMixingManagerFunctions.nativePushAudioMixingFrame(this.mNativeAudioMixingManager, mixId, audioFrame.buffer, audioFrame.samples, audioFrame.sampleRate.value(), audioFrame.channel.value());
    }

    @Override
    public synchronized int getAudioTrackCount(int mixId) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, GetAudioTrackCount failed.");
            return -1;
        }
        return NativeAudioMixingManagerFunctions.nativeGetAudioTrackCount(this.mNativeAudioMixingManager, mixId);
    }

    @Override
    public synchronized void selectAudioTrack(int mixId, int audioTrackIndex) {
        if (this.mNativeAudioMixingManager == 0L) {
            LogUtil.e(TAG, "native AudioMixingManager is invalid, SelectAudioTrack failed.");
            return;
        }
        NativeAudioMixingManagerFunctions.nativeSelectAudioTrack(this.mNativeAudioMixingManager, mixId, audioTrackIndex);
    }

    public synchronized void destroy() {
        this.mNativeAudioMixingManager = 0L;
    }
}

