/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Handler;
import android.os.HandlerThread;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.Log;
import com.bytedance.librarian.Librarian;
import com.ss.bytertc.base.utils.NetworkConnectChangeReceiver;
import com.ss.bytertc.base.utils.NetworkUtils;
import com.ss.bytertc.base.utils.RtcContextUtils;
import com.ss.bytertc.engine.AudioFocusManager;
import com.ss.bytertc.engine.GameRTCEngine;
import com.ss.bytertc.engine.NativeGameFunctions;
import com.ss.bytertc.engine.adapter.VideoSinkTask;
import com.ss.bytertc.engine.data.AudioFormat;
import com.ss.bytertc.engine.game.AudioProfileType;
import com.ss.bytertc.engine.game.GameRTCEngineConfig;
import com.ss.bytertc.engine.game.GameRTCOrientation;
import com.ss.bytertc.engine.game.GameRTCPositionInfo;
import com.ss.bytertc.engine.game.GameRTCReceiveRange;
import com.ss.bytertc.engine.game.GameRTCRoomConfig;
import com.ss.bytertc.engine.handler.GameRTCEventHandler;
import com.ss.bytertc.engine.handler.IGameRTCEventHandler;
import com.ss.bytertc.engine.loader.RTCNativeLibraryListenerImpl;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoader;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderImpl;
import com.ss.bytertc.engine.loader.RTCNativeLibraryLoaderListener;
import com.ss.bytertc.engine.type.AttenuationType;
import com.ss.bytertc.engine.type.AudioScenarioType;
import com.ss.bytertc.engine.type.VoiceChangerType;
import com.ss.bytertc.engine.type.VoiceReverbType;
import com.ss.bytertc.engine.utils.AppMonitor;
import com.ss.bytertc.engine.utils.AudioFrame;
import com.ss.bytertc.engine.utils.LogUtil;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javax.microedition.khronos.egl.EGLContext;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.EglBase;
import org.webrtc.ThreadUtils;

public final class GameRTCEngineImpl
extends GameRTCEngine {
    private static GameRTCEngineImpl mInstance = null;
    private static boolean mLibraryLoaded = false;
    private static final String sSoLibraryName = "volcenginertc";
    private static final String TAG = "GameRTCEngineImpl";
    private static final String mConfigName = "config.json";
    private static String rtcAppId = null;
    private static String rtcAid = null;
    private GameRTCEventHandler mEngineEventHandler;
    private IGameRTCEventHandler mRtcEngineHandler;
    private long mNativeGameRtcEngine = -1L;
    private Context mContext;
    private Map<String, Boolean> mSpeakerphoneMute = new HashMap<String, Boolean>();
    private Map<String, Boolean> mMicrophoneMute = new HashMap<String, Boolean>();
    private static RTCNativeLibraryLoaderListener mRtcNativeLibraryListener = new RTCNativeLibraryListenerImpl();
    private VideoSinkTask mVideoSinkTask;
    private static EglBase mRootEglBase = null;
    private HandlerThread mEglThread;
    private Handler mEglHandler;
    private boolean mIsUseCustomEglEnv = false;
    private BroadcastReceiver mBroadcastReceiver = null;
    private AudioFocusManager mAudioFocusManager = null;
    private boolean isEnableAudioFocus = false;
    private int mPlaybackVolume = 100;
    private LogUtil.LoggerSink mLoggerSink = new LogUtil.LoggerSink(){

        @Override
        public void onLoggerMessage(LogUtil.LogLevel level, String msg, Throwable throwable) {
            IGameRTCEventHandler handler = GameRTCEngineImpl.getGameRTCEventHandler();
            try {
                if (handler != null) {
                    handler.onLoggerMessage(level, msg, throwable);
                }
            }
            catch (Exception e) {
                Log.e((String)GameRTCEngineImpl.TAG, (String)msg, (Throwable)throwable);
                e.printStackTrace();
            }
        }
    };
    private AppMonitor.Callback appStateCallback = state -> {
        GameRTCEngineImpl gameRTCEngineImpl = this;
        synchronized (gameRTCEngineImpl) {
            NativeGameFunctions.nativeSetAppState(this.mNativeGameRtcEngine, state == 1 ? "active" : "background");
        }
    };
    private NetworkConnectChangeReceiver.Callback SetNetworkTypeCallback = (type, extraInfo) -> {
        GameRTCEngineImpl gameRTCEngineImpl = this;
        synchronized (gameRTCEngineImpl) {
            if (this.mNativeGameRtcEngine == -1L) {
                LogUtil.e(TAG, "native engine is invalid, SetNetworkType failed.");
                return;
            }
            NativeGameFunctions.nativeSetNetworkType(this.mNativeGameRtcEngine, type, extraInfo);
        }
    };
    private AudioFocusManager.Callback mAudioFocusCallback = new AudioFocusManager.Callback(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startSpeakerphone() {
            GameRTCEngineImpl gameRTCEngineImpl = GameRTCEngineImpl.this;
            synchronized (gameRTCEngineImpl) {
                if (GameRTCEngineImpl.this.mNativeGameRtcEngine == -1L) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "native engine is invalid, enableMicrophone failed.");
                    return;
                }
                for (String roomId : GameRTCEngineImpl.this.mSpeakerphoneMute.keySet()) {
                    NativeGameFunctions.nativeEnableSpeakerphone(GameRTCEngineImpl.this.mNativeGameRtcEngine, roomId, (Boolean)GameRTCEngineImpl.this.mSpeakerphoneMute.get(roomId));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopSpeakerphone() {
            GameRTCEngineImpl gameRTCEngineImpl = GameRTCEngineImpl.this;
            synchronized (gameRTCEngineImpl) {
                if (GameRTCEngineImpl.this.mNativeGameRtcEngine == -1L) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "native engine is invalid, enableMicrophone failed.");
                    return;
                }
                for (String roomId : GameRTCEngineImpl.this.mSpeakerphoneMute.keySet()) {
                    NativeGameFunctions.nativeEnableSpeakerphone(GameRTCEngineImpl.this.mNativeGameRtcEngine, roomId, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void startMicrophone() {
            GameRTCEngineImpl gameRTCEngineImpl = GameRTCEngineImpl.this;
            synchronized (gameRTCEngineImpl) {
                if (GameRTCEngineImpl.this.mNativeGameRtcEngine == -1L) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "native engine is invalid, enableMicrophone failed.");
                    return;
                }
                for (String roomId : GameRTCEngineImpl.this.mMicrophoneMute.keySet()) {
                    NativeGameFunctions.nativeEnableMicrophone(GameRTCEngineImpl.this.mNativeGameRtcEngine, roomId, (Boolean)GameRTCEngineImpl.this.mMicrophoneMute.get(roomId));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void stopMicrophone() {
            GameRTCEngineImpl gameRTCEngineImpl = GameRTCEngineImpl.this;
            synchronized (gameRTCEngineImpl) {
                if (GameRTCEngineImpl.this.mNativeGameRtcEngine == -1L) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "native engine is invalid, enableMicrophone failed.");
                    return;
                }
                for (String roomId : GameRTCEngineImpl.this.mMicrophoneMute.keySet()) {
                    NativeGameFunctions.nativeEnableMicrophone(GameRTCEngineImpl.this.mNativeGameRtcEngine, roomId, false);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void lowerVolume() {
            GameRTCEngineImpl gameRTCEngineImpl = GameRTCEngineImpl.this;
            synchronized (gameRTCEngineImpl) {
                if (GameRTCEngineImpl.this.mNativeGameRtcEngine == -1L) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "native engine is invalid, lowerVolume failed.");
                    return;
                }
                NativeGameFunctions.nativeSetPlaybackVolume(GameRTCEngineImpl.this.mNativeGameRtcEngine, 10);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void higherVolume() {
            GameRTCEngineImpl gameRTCEngineImpl = GameRTCEngineImpl.this;
            synchronized (gameRTCEngineImpl) {
                if (GameRTCEngineImpl.this.mNativeGameRtcEngine == -1L) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "native engine is invalid, lowerVolume failed.");
                    return;
                }
                NativeGameFunctions.nativeSetPlaybackVolume(GameRTCEngineImpl.this.mNativeGameRtcEngine, GameRTCEngineImpl.this.mPlaybackVolume);
            }
        }
    };

    public GameRTCEngineImpl(Context context, GameRTCEngineConfig config, IGameRTCEventHandler eventHandler, String params) {
        LogUtil.d(TAG, "create GameRTCEngineImpl with appId: " + config.appId);
        if (mLibraryLoaded) {
            mInstance = this;
            EglBase.Context eglEglBaseContext = null;
            long nativeEglContext = 0L;
            this.mEglThread = new HandlerThread("rtc_egl_thread");
            this.mEglThread.start();
            this.mVideoSinkTask = new VideoSinkTask();
            this.mVideoSinkTask.init();
            this.mEglHandler = new Handler(this.mEglThread.getLooper());
            ThreadUtils.invokeAtFrontUninterruptibly(this.mEglHandler, () -> this.initEglContext(null));
            eglEglBaseContext = mRootEglBase.getEglBaseContext();
            if (eglEglBaseContext != null) {
                nativeEglContext = mRootEglBase.getEglBaseContext().getNativeEglContext();
            }
            this.mContext = context.getApplicationContext();
            GameRTCEngineImpl.loadSoFile(this.mContext);
            if (TextUtils.isEmpty((CharSequence)config.appId)) {
                config.appId = this.parseOrGetAppId(context);
            }
            RtcContextUtils.initialize(this.mContext);
            this.mRtcEngineHandler = eventHandler;
            this.mEngineEventHandler = new GameRTCEventHandler(this);
            LogUtil.setLoggerSink(this.mLoggerSink);
            JSONObject doc = new JSONObject();
            try {
                if (!params.isEmpty()) {
                    doc = new JSONObject(params);
                }
                if (this.isAidEmpty(params)) {
                    doc.put("rtc.aid", (Object)this.parseOrGetAid(context));
                    LogUtil.e(TAG, "Aid is empty!! parseAid is: " + rtcAid);
                }
                if (this.isDidEmpty(params)) {
                    String did = this.getDeviceId(this.mContext);
                    doc.put("rtc.device_id", (Object)did);
                    LogUtil.e(TAG, "did is empty!! parseDid is: " + did);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.mNativeGameRtcEngine = NativeGameFunctions.nativeCreateEngine(this.mContext.getApplicationContext(), config.appId, this.mEngineEventHandler, doc.toString(), eglEglBaseContext, nativeEglContext);
            if (this.mNativeGameRtcEngine == -1L) {
                LogUtil.e(TAG, "create native engine error, native engine is invalid.");
            }
            this.mAudioFocusManager = new AudioFocusManager(this.mContext, this.mAudioFocusCallback);
            this.mBroadcastReceiver = new NetworkConnectChangeReceiver(this.SetNetworkTypeCallback);
            NetworkUtils.registerReceiver(context, this.mBroadcastReceiver);
            AppMonitor.get(context).register(context, this.appStateCallback);
        }
    }

    private String parseOrGetAppId(Context context) {
        if (rtcAppId != null) {
            return rtcAppId;
        }
        this.parseAidAndAppId(context);
        return rtcAppId;
    }

    private String parseOrGetAid(Context context) {
        if (rtcAid != null) {
            return rtcAid;
        }
        this.parseAidAndAppId(context);
        return rtcAid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseAidAndAppId(Context context) {
        InputStream in = null;
        try {
            AssetManager assetManager = context.getAssets();
            in = assetManager.open(mConfigName);
            byte[] buffer = new byte[in.available()];
            in.read(buffer);
            String json = new String(buffer, "UTF-8");
            JSONObject object = new JSONObject(json);
            JSONObject sdkJson = object.getJSONObject("app");
            JSONObject rtcJson = sdkJson.getJSONObject("rtc");
            rtcAppId = rtcJson.getString("rtcAppId");
            rtcAid = sdkJson.getString("app_id");
            LogUtil.e(TAG, "get rtcAppId And rtcAid: " + rtcAppId + ", " + rtcAid);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private boolean isAidEmpty(String params) {
        String aid = null;
        try {
            JSONObject object = new JSONObject(params);
            aid = object.getString("rtc.aid");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return aid == null || aid.isEmpty();
    }

    private boolean isDidEmpty(String params) {
        String did = null;
        try {
            JSONObject object = new JSONObject(params);
            did = object.getString("rtc.device_id");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return did == null || did.isEmpty();
    }

    private String getDeviceId(Context context) {
        String did = "";
        try {
            Class<?> rocketClass = this.isI18nFlavor() ? Class.forName("com.bytedance.ttgame.rocketapi.Rocket") : Class.forName("com.bytedance.ttgame.rocketapi.RocketCn");
            Method getInstanceMethod = rocketClass.getMethod("getInstance", new Class[0]);
            Method getDeviceIdMethod = rocketClass.getMethod("getDeviceID", Context.class);
            Object instance = getInstanceMethod.invoke(null, new Object[0]);
            did = (String)getDeviceIdMethod.invoke(instance, context);
        }
        catch (Exception e) {
            LogUtil.e(TAG, "getDeviceId catch exception , e : " + e.getMessage());
        }
        return did;
    }

    private boolean isI18nFlavor() {
        boolean isI18n = false;
        try {
            Class<?> flavorUtilKtClass = Class.forName("com.bytedance.ttgame.framework.module.util.FlavorUtilKt");
            Method isI18nFlavorMethod = flavorUtilKtClass.getMethod("isI18nFlavor", new Class[0]);
            isI18n = (Boolean)isI18nFlavorMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            LogUtil.e(TAG, "get FlavorUtilKtClass catch exception , e : " + e.getMessage());
        }
        return isI18n;
    }

    private JSONObject AddParameters(JSONObject parameters, Context context) {
        String path;
        if (parameters == null) {
            parameters = new JSONObject();
        }
        if ((path = context.getFilesDir().getPath()) == null || path.isEmpty()) {
            path = "/data/data/" + context.getPackageName() + "/files";
        }
        try {
            parameters.put("rtc.log_location", (Object)(path + "/rtc_log"));
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return parameters;
    }

    private void initEglContext(Object eglContext) {
        if (eglContext == null) {
            mRootEglBase = EglBase.create();
            this.mIsUseCustomEglEnv = false;
            return;
        }
        mRootEglBase = eglContext instanceof EGLContext ? EglBase.createEgl10((EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof android.opengl.EGLContext ? EglBase.createEgl14((android.opengl.EGLContext)eglContext, EglBase.CONFIG_PLAIN) : (eglContext instanceof EglBase ? EglBase.create(((EglBase)eglContext).getEglBaseContext(), EglBase.CONFIG_PLAIN) : EglBase.create()));
        this.mIsUseCustomEglEnv = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IGameRTCEventHandler getGameRTCEventHandler() {
        Class<GameRTCEngineImpl> clazz = GameRTCEngineImpl.class;
        synchronized (GameRTCEngineImpl.class) {
            if (mInstance == null) {
                Log.e((String)TAG, (String)"mInstance == null");
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            if (GameRTCEngineImpl.mInstance.mRtcEngineHandler == null) {
                Log.e((String)TAG, (String)"mInstance.mRtcEngineHandler == null");
                // ** MonitorExit[var0] (shouldn't be in output)
                return null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return GameRTCEngineImpl.mInstance.mRtcEngineHandler;
        }
    }

    public synchronized void doDestroy() {
        LogUtil.d(TAG, "destroy GameRTCEngineImpl.");
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, no need to destroy now.");
            return;
        }
        NetworkUtils.unregisterReceiver(this.mContext, this.mBroadcastReceiver);
        this.mBroadcastReceiver = null;
        this.mAudioFocusManager.release();
        this.mAudioFocusManager = null;
        AppMonitor.get(this.mContext).unRegister(this.appStateCallback).release(this.mContext);
        NativeGameFunctions.nativeDestroyEngine(this.mNativeGameRtcEngine);
        this.mNativeGameRtcEngine = -1L;
        this.mSpeakerphoneMute.clear();
        this.mMicrophoneMute.clear();
        mInstance = null;
        ThreadUtils.invokeAtFrontUninterruptibly(this.mEglHandler, () -> {
            if (mRootEglBase != null) {
                mRootEglBase.release();
                mRootEglBase = null;
            }
        });
        if (this.mEglThread != null) {
            this.mEglThread.quit();
        }
        if (this.mVideoSinkTask != null) {
            this.mVideoSinkTask.exit();
        }
    }

    public static String getSDKVersion() {
        if (!mLibraryLoaded) {
            return "";
        }
        return NativeGameFunctions.nativeGetSDKVersion();
    }

    @Override
    public synchronized int joinRoom(String roomId, String userId, String token, GameRTCRoomConfig config) {
        LogUtil.d(TAG, "joinRoom with token: " + token + " , roomId: " + roomId + " and userId: " + userId);
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, joinRoom failed.");
            return -3;
        }
        if (userId == null || userId.length() == 0) {
            LogUtil.e(TAG, "userId is invalid, joinRoom failed.");
            return -2;
        }
        if (roomId == null || roomId.length() == 0) {
            LogUtil.e(TAG, "roomId is invalid, joinRoom failed.");
            return -1;
        }
        int joinres = NativeGameFunctions.nativeJoinRoom(this.mNativeGameRtcEngine, roomId, userId, token, config.enableRangeAudio, config.enableSpatialAudio, config.enableRemoteOrient, config.audioVolumeIndicationInterval, config.roomType.value());
        if (!this.mSpeakerphoneMute.containsKey(roomId)) {
            this.mSpeakerphoneMute.put(roomId, false);
        }
        if (!this.mMicrophoneMute.containsKey(roomId)) {
            this.mMicrophoneMute.put(roomId, false);
        }
        if (joinres < 0) {
            return joinres;
        }
        return 0;
    }

    @Override
    public synchronized int leaveRoom(String roomId) {
        LogUtil.d(TAG, "leaveRoom");
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, leaveRoom failed.");
            return -1;
        }
        NativeGameFunctions.nativeLeaveRoom(this.mNativeGameRtcEngine, roomId);
        if (this.mSpeakerphoneMute.containsKey(roomId)) {
            this.mSpeakerphoneMute.remove(roomId);
        }
        if (this.mMicrophoneMute.containsKey(roomId)) {
            this.mMicrophoneMute.remove(roomId);
        }
        return 0;
    }

    @Override
    public synchronized int updateToken(String roomId, String token) {
        LogUtil.d(TAG, "updateToken");
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, leaveRoom failed.");
            return -1;
        }
        return NativeGameFunctions.nativeUpdateToken(this.mNativeGameRtcEngine, roomId, token);
    }

    @Override
    public synchronized int updateReceiveRange(String roomId, GameRTCReceiveRange range) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, updateReceiveRange failed.");
            return -1;
        }
        return NativeGameFunctions.nativeUpdateReceiveRange(this.mNativeGameRtcEngine, roomId, range.min, range.max);
    }

    @Override
    public int setAttenuationModel(String roomId, AttenuationType type, float coefficient) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setAttenuationModel failed.");
            return -1;
        }
        return NativeGameFunctions.nativeSetAttenuationModel(this.mNativeGameRtcEngine, roomId, type.value(), coefficient);
    }

    @Override
    public synchronized int updatePosition(String roomId, GameRTCPositionInfo info) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, updatePosition failed.");
            return -1;
        }
        return NativeGameFunctions.nativeUpdatePosition(this.mNativeGameRtcEngine, roomId, info.x, info.y, info.z);
    }

    @Override
    public synchronized int updateOrientation(String roomId, GameRTCOrientation forward, GameRTCOrientation right, GameRTCOrientation up) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, updateOrientation failed.");
            return -1;
        }
        return NativeGameFunctions.nativeUpdateOrientation(this.mNativeGameRtcEngine, roomId, forward.x, forward.y, forward.z, right.x, right.y, right.z, up.x, up.y, up.z);
    }

    @Override
    public synchronized int enableMicrophone(String roomId, boolean enable) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, enableMicrophone failed.");
            return -1;
        }
        if (this.mMicrophoneMute.containsKey(roomId)) {
            this.mMicrophoneMute.put(roomId, enable);
        }
        return NativeGameFunctions.nativeEnableMicrophone(this.mNativeGameRtcEngine, roomId, enable);
    }

    @Override
    public synchronized int enableAudioSend(String roomId, boolean enable) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, enableAudioSend failed.");
            return -1;
        }
        return NativeGameFunctions.nativeEnableAudioSend(this.mNativeGameRtcEngine, roomId, enable);
    }

    @Override
    public synchronized int enableSpeakerphone(String roomId, boolean enable) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, enableSpeakerphone failed.");
            return -1;
        }
        if (roomId == null) {
            LogUtil.e(TAG, "roomid is invalid, enableSpeakerphone failed.");
            return -1;
        }
        if (this.mSpeakerphoneMute.containsKey(roomId)) {
            this.mSpeakerphoneMute.put(roomId, enable);
        }
        return NativeGameFunctions.nativeEnableSpeakerphone(this.mNativeGameRtcEngine, roomId, enable);
    }

    @Override
    public synchronized int enableAudioReceive(String roomId, String userId, boolean enable) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, enableAudioReceive failed.");
            return -1;
        }
        return NativeGameFunctions.nativeEnableAudioReceive(this.mNativeGameRtcEngine, roomId, userId, enable);
    }

    @Override
    public synchronized int setRecordingVolume(int volume) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setRecordingVolume failed.");
            return -1;
        }
        return NativeGameFunctions.nativeSetRecordingVolume(this.mNativeGameRtcEngine, volume);
    }

    @Override
    public synchronized int setPlaybackVolume(int volume) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setPlaybackVolume failed.");
            return -1;
        }
        this.mPlaybackVolume = volume;
        return NativeGameFunctions.nativeSetPlaybackVolume(this.mNativeGameRtcEngine, volume);
    }

    @Override
    public synchronized int setRemoteAudioPlaybackVolume(String roomId, String userId, int volume) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, setRemoteAudioPlaybackVolume failed.");
            return -1;
        }
        return NativeGameFunctions.nativeSetRemoteAudioPlaybackVolume(this.mNativeGameRtcEngine, roomId, userId, volume);
    }

    @Override
    public synchronized void EnableExternalAudioDevice(AudioFormat recordingFormat, AudioFormat paybackFormat) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, EnableExternalAudioDevice failed.");
            return;
        }
        if (recordingFormat.sampleRate == null || recordingFormat.channel == null || paybackFormat.sampleRate == null || paybackFormat.channel == null) {
            LogUtil.e(TAG, "parameter is invalid, EnableExternalAudioDevice failed.");
            return;
        }
        NativeGameFunctions.nativeEnableExternalAudioDevice(this.mNativeGameRtcEngine, recordingFormat.sampleRate.value(), recordingFormat.channel.value(), paybackFormat.sampleRate.value(), paybackFormat.channel.value());
    }

    @Override
    public synchronized void DisableExternalAudioDevice() {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, DisableExternalAudioDevice failed.");
            return;
        }
        NativeGameFunctions.nativeDisableExternalAudioDevice(this.mNativeGameRtcEngine);
    }

    @Override
    public synchronized int pushExternalAudioFrame(AudioFrame audioFrame) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, pushExternalAudioFrame failed.");
            return -1;
        }
        boolean ret = NativeGameFunctions.nativePushExternalAudioFrame(this.mNativeGameRtcEngine, audioFrame.buffer, audioFrame.samples);
        return ret ? 0 : -2;
    }

    @Override
    public synchronized int pullExternalAudioFrame(AudioFrame audioFrame) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, pullExternalAudioFrame failed.");
            return -1;
        }
        boolean ret = NativeGameFunctions.nativePullExternalAudioFrame(this.mNativeGameRtcEngine, audioFrame.buffer, audioFrame.samples);
        return ret ? 0 : -2;
    }

    @Override
    public synchronized void setAudioScenario(AudioScenarioType audioScenario) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, SetAudioScenario failed.");
            return;
        }
        NativeGameFunctions.nativeSetAudioScenario(this.mNativeGameRtcEngine, audioScenario.value());
    }

    @Override
    public synchronized void setAudioProfile(AudioProfileType audioProfile) {
        if (!this.checkEngineValid("setAudioProfile")) {
            return;
        }
        NativeGameFunctions.nativeSetAudioProfile(this.mNativeGameRtcEngine, audioProfile.value());
    }

    @Override
    public synchronized void setVoiceChangerType(VoiceChangerType voiceChanger) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, SetVoiceChangerType failed.");
            return;
        }
        NativeGameFunctions.nativeSetVoiceChangerType(this.mNativeGameRtcEngine, voiceChanger.value());
    }

    @Override
    public synchronized void setVoiceReverbType(VoiceReverbType voiceReverb) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, SetVoiceReverbType failed.");
            return;
        }
        NativeGameFunctions.nativeSetVoiceReverbType(this.mNativeGameRtcEngine, voiceReverb.value());
    }

    @Override
    public synchronized void enableRequestAudioFocus(boolean enable) {
        if (enable) {
            this.mAudioFocusManager.requestAudioFocus();
            this.isEnableAudioFocus = enable;
        } else if (this.isEnableAudioFocus) {
            this.mAudioFocusManager.releaseAudioFocus();
            this.isEnableAudioFocus = false;
        }
    }

    private static void loadSoFile(@Nullable Context context) {
        RTCNativeLibraryLoader libraryLoader = mRtcNativeLibraryLoader;
        if (libraryLoader == null) {
            libraryLoader = new RTCNativeLibraryLoaderImpl();
        }
        if (context != null) {
            libraryLoader = new GameRTCNativeLibraryLoader(context, libraryLoader);
        }
        if (mLibraryLoaded) {
            mRtcNativeLibraryListener.onLoadAlready(sSoLibraryName);
        } else {
            mLibraryLoaded = true;
            mLibraryLoaded &= libraryLoader.load("byteaudio");
            if (mLibraryLoaded &= libraryLoader.load(sSoLibraryName)) {
                mRtcNativeLibraryListener.onLoadSuccess(sSoLibraryName);
            } else {
                mRtcNativeLibraryListener.onLoadError(sSoLibraryName);
            }
        }
    }

    private boolean checkEngineValid(String apiCallName) {
        if (this.mNativeGameRtcEngine == -1L) {
            LogUtil.e(TAG, "native engine is invalid, " + apiCallName + " failed.");
            return false;
        }
        return true;
    }

    static {
        GameRTCEngineImpl.loadSoFile(null);
    }

    private static class GameRTCNativeLibraryLoader
    implements RTCNativeLibraryLoader {
        private final RTCNativeLibraryLoader mGameRTCNativeLibraryLoader;
        private final Context context;

        GameRTCNativeLibraryLoader(Context context, RTCNativeLibraryLoader gameRTCNativeLibraryLoader) {
            this.mGameRTCNativeLibraryLoader = gameRTCNativeLibraryLoader;
            this.context = context;
        }

        @Override
        public boolean load(String libraryName) {
            if (this.mGameRTCNativeLibraryLoader != null && this.mGameRTCNativeLibraryLoader.load(libraryName)) {
                return true;
            }
            try {
                System.loadLibrary(libraryName);
                return true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                try {
                    Librarian.loadLibraryForModule((String)libraryName, (Context)this.context);
                }
                catch (Throwable exception) {
                    LogUtil.e(GameRTCEngineImpl.TAG, "load so error:" + exception.getLocalizedMessage());
                    return false;
                }
                Log.e((String)GameRTCEngineImpl.TAG, (String)("Failed to load native library: " + libraryName), (Throwable)unsatisfiedLinkError);
                return false;
            }
        }
    }
}

