/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.adapter;

import com.bytedance.realx.base.CalledByNative;
import com.ss.bytertc.engine.adapter.VideoSinkTask;
import com.ss.bytertc.engine.video.IVideoSink;
import com.ss.bytertc.engine.video.VideoFrame;

public class VideoSinkAdapter
implements IVideoSink {
    private IVideoSink mSink = null;
    private boolean mInitialized = false;
    private boolean mStarted = false;
    private VideoSinkTask mVideoSinkTask;
    private com.ss.bytertc.engine.mediaio.IVideoSink mBridgedOldSink;
    private boolean mDirectPush = false;

    public VideoSinkAdapter(IVideoSink sink) {
        this.mSink = sink;
    }

    public VideoSinkAdapter(IVideoSink sink, boolean directPush) {
        this.mSink = sink;
        this.mDirectPush = directPush;
    }

    public VideoSinkAdapter(com.ss.bytertc.engine.mediaio.IVideoSink bridgedOldSink, VideoSinkTask videoSinkTask) {
        this.mBridgedOldSink = bridgedOldSink;
        this.mVideoSinkTask = videoSinkTask;
    }

    @Override
    public void onFrame(VideoFrame frame) {
        if (this.mSink != null) {
            this.mSink.onFrame(frame);
        } else if (this.mBridgedOldSink != null) {
            this.mBridgedOldSink.consumeVideoFrame(frame);
        }
    }

    @CalledByNative
    public void release() {
        if (this.mBridgedOldSink != null && this.mVideoSinkTask != null) {
            this.mVideoSinkTask.post(new Runnable(){

                @Override
                public void run() {
                    if (VideoSinkAdapter.this.mBridgedOldSink != null) {
                        VideoSinkAdapter.this.mBridgedOldSink.onStop();
                        VideoSinkAdapter.this.mBridgedOldSink.onDispose();
                    }
                }
            });
        }
    }

    @CalledByNative
    void onVideoFrame(VideoFrame frame) {
        if (frame == null) {
            return;
        }
        this.onFrame(frame);
    }

    @Override
    @CalledByNative
    public int getRenderElapse() {
        if (this.mSink != null) {
            return this.mSink.getRenderElapse();
        }
        return 0;
    }
}

