/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.data;

import org.webrtc.CalledByNative;

public class ForwardStreamStateInfo {
    public String roomId;
    public ForwardStreamState state;
    public ForwardStreamError error;

    public ForwardStreamStateInfo(String roomId, ForwardStreamState state, ForwardStreamError error) {
        this.roomId = roomId;
        this.state = state;
        this.error = error;
    }

    @CalledByNative
    private static ForwardStreamStateInfo create(String roomId, int stateId, int errorId) {
        return new ForwardStreamStateInfo(roomId, ForwardStreamState.fromId(stateId), ForwardStreamError.fromId(errorId));
    }

    public static enum ForwardStreamError {
        FORWARD_STREAM_ERROR_OK(0),
        FORWARD_STREAM_ERROR_INVALID_ARGUMENT(1201),
        FORWARD_STREAM_ERROR_INVALID_TOKEN(1202),
        FORWARD_STREAM_ERROR_RESPONSE(1203),
        FORWARD_STREAM_ERROR_REMOTE_KICKED(1204),
        FORWARD_STREAM_ERROR_NOT_SUPPORT(1205);

        private int value;

        private ForwardStreamError(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static ForwardStreamError fromId(int id) {
            for (ForwardStreamError type : ForwardStreamError.values()) {
                if (type.value() != id) continue;
                return type;
            }
            return null;
        }
    }

    public static enum ForwardStreamState {
        FORWARD_STREAM_STATE_IDLE(0),
        FORWARD_STREAM_STATE_SUCCESS(1),
        FORWARD_STREAM_STATE_FAILURE(2);

        private int value;

        private ForwardStreamState(int value) {
            this.value = value;
        }

        public int value() {
            return this.value;
        }

        public static ForwardStreamState fromId(int id) {
            for (ForwardStreamState type : ForwardStreamState.values()) {
                if (type.value() != id) continue;
                return type;
            }
            return null;
        }
    }
}

