/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.IAudioFrameObserver;
import com.ss.bytertc.engine.data.AudioChannel;
import com.ss.bytertc.engine.data.AudioSampleRate;
import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.utils.AudioFrameImpl;
import com.ss.bytertc.engine.utils.IAudioFrame;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.webrtc.CalledByNative;

public class RTCAudioFrameObserver {
    private static final String TAG = "RtcAudioFrameObserver";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public RTCAudioFrameObserver(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCAudioFrameObserver(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    void onRecordAudioFrame(IAudioFrame audioFrame) {
        RTCVideoImpl strongVideo;
        IAudioFrameObserver audioFrameObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFrameObserver = strongEngine.getAudioFrameObserver()) != null) {
            audioFrameObserver.onRecordAudioFrame(audioFrame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFrameObserver = strongVideo.getAudioFrameObserver()) != null) {
            audioFrameObserver.onRecordAudioFrame(audioFrame);
        }
    }

    @CalledByNative
    void onPlaybackAudioFrame(IAudioFrame audioFrame) {
        RTCVideoImpl strongVideo;
        IAudioFrameObserver audioFrameObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFrameObserver = strongEngine.getAudioFrameObserver()) != null) {
            audioFrameObserver.onPlaybackAudioFrame(audioFrame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (audioFrameObserver = strongVideo.getAudioFrameObserver()) != null) {
            audioFrameObserver.onPlaybackAudioFrame(audioFrame);
        }
    }

    @CalledByNative
    void onRemoteUserAudioFrame(String room_id, String user_id, int stream_index, IAudioFrame audioFrame) {
        IAudioFrameObserver frameObserver;
        RTCVideoImpl strongVideo;
        RemoteStreamKey streamKey;
        IAudioFrameObserver audioFrameObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFrameObserver = strongEngine.getAudioFrameObserver()) != null) {
            streamKey = new RemoteStreamKey(room_id, user_id, StreamIndex.fromId(stream_index));
            audioFrameObserver.onRemoteUserAudioFrame(streamKey, audioFrame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (frameObserver = strongVideo.getAudioFrameObserver()) != null) {
            streamKey = new RemoteStreamKey(room_id, user_id, StreamIndex.fromId(stream_index));
            frameObserver.onRemoteUserAudioFrame(streamKey, audioFrame);
        }
    }

    @CalledByNative
    void onMixedAudioFrame(IAudioFrame audioFrame) {
        IAudioFrameObserver frameObserver;
        RTCVideoImpl strongVideo;
        IAudioFrameObserver audioFrameObserver;
        RTCEngineImpl strongEngine;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null && (audioFrameObserver = strongEngine.getAudioFrameObserver()) != null) {
            audioFrameObserver.onMixedAudioFrame(audioFrame);
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null && (frameObserver = strongVideo.getAudioFrameObserver()) != null) {
            frameObserver.onMixedAudioFrame(audioFrame);
        }
    }

    @CalledByNative
    private static IAudioFrame createAudioFrameImpl(ByteBuffer buffer, int samples_per_channel, int sampleRate, int channel) {
        buffer.order(ByteOrder.nativeOrder());
        return new AudioFrameImpl(buffer, samples_per_channel, AudioSampleRate.fromId(sampleRate), AudioChannel.fromId(channel));
    }
}

