/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import android.text.TextUtils;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.handler.IRTCEngineInternalEventHandler;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;

public class RTCEngineInternalEventHandler {
    private static final String TAG = "REngineInternalEventHandler";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;
    private WeakReference<IRTCEngineInternalEventHandler> mRtcEngineInternalEventHandler;
    private String mCurrConfigAddr;
    private String mCurrSignalingAddr;

    public RTCEngineInternalEventHandler(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCEngineInternalEventHandler(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    public void setInternalEventHandler(IRTCEngineInternalEventHandler handler) {
        this.mRtcEngineInternalEventHandler = new WeakReference<IRTCEngineInternalEventHandler>(handler);
        IRTCEngineInternalEventHandler internal_handler = (IRTCEngineInternalEventHandler)this.mRtcEngineInternalEventHandler.get();
        if (internal_handler != null) {
            if (!TextUtils.isEmpty((CharSequence)this.mCurrConfigAddr)) {
                internal_handler.onConfigAddrChanged(this.mCurrConfigAddr);
            }
            if (!TextUtils.isEmpty((CharSequence)this.mCurrSignalingAddr)) {
                internal_handler.onSignalingAddrChanged(this.mCurrSignalingAddr);
            }
        }
    }

    @CalledByNative
    public void onPeerConnectionICEMux(boolean muxed) {
        try {
            IRTCEngineInternalEventHandler internal_handler;
            IRTCEngineInternalEventHandler iRTCEngineInternalEventHandler = internal_handler = this.mRtcEngineInternalEventHandler == null ? null : (IRTCEngineInternalEventHandler)this.mRtcEngineInternalEventHandler.get();
            if (internal_handler != null) {
                internal_handler.onPeerConnectionICEMux(muxed);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onPeerConnectionICEMux callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSystemInfoLog(double appCpuUsage, double totalCpuUsage, double appMemeryUsage) {
        try {
            IRTCEngineInternalEventHandler internal_handler;
            IRTCEngineInternalEventHandler iRTCEngineInternalEventHandler = internal_handler = this.mRtcEngineInternalEventHandler == null ? null : (IRTCEngineInternalEventHandler)this.mRtcEngineInternalEventHandler.get();
            if (internal_handler != null) {
                internal_handler.onSystemInfoLog(appCpuUsage, totalCpuUsage, appMemeryUsage);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onSystemInfoLog callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSignalingAddrChanged(String add) {
        try {
            IRTCEngineInternalEventHandler internal_handler;
            this.mCurrSignalingAddr = add;
            IRTCEngineInternalEventHandler iRTCEngineInternalEventHandler = internal_handler = this.mRtcEngineInternalEventHandler == null ? null : (IRTCEngineInternalEventHandler)this.mRtcEngineInternalEventHandler.get();
            if (internal_handler != null) {
                internal_handler.onSignalingAddrChanged(add);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onSignalingAddrChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onConfigAddrChanged(String addr) {
        try {
            IRTCEngineInternalEventHandler internal_handler;
            this.mCurrConfigAddr = addr;
            IRTCEngineInternalEventHandler iRTCEngineInternalEventHandler = internal_handler = this.mRtcEngineInternalEventHandler == null ? null : (IRTCEngineInternalEventHandler)this.mRtcEngineInternalEventHandler.get();
            if (internal_handler != null) {
                internal_handler.onConfigAddrChanged(addr);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onConfigAddrChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onChannelTypeChanged(boolean isPreICE) {
        try {
            IRTCEngineInternalEventHandler internal_handler;
            IRTCEngineInternalEventHandler iRTCEngineInternalEventHandler = internal_handler = this.mRtcEngineInternalEventHandler == null ? null : (IRTCEngineInternalEventHandler)this.mRtcEngineInternalEventHandler.get();
            if (internal_handler != null) {
                internal_handler.onChannelTypeChanged(isPreICE);
            }
        }
        catch (Exception ex) {
            LogUtil.d(TAG, "onChannelTypeChanged callback catch exception.\n" + ex.getMessage());
        }
    }
}

