/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.InternalExpressDetectInfo;
import com.ss.bytertc.engine.InternalRectangle;
import com.ss.bytertc.engine.engineimpl.RTCEngineImpl;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.video.ExpressionDetectInfo;
import com.ss.bytertc.engine.video.ExpressionDetectResult;
import com.ss.bytertc.engine.video.FaceDetectionResult;
import com.ss.bytertc.engine.video.IFaceDetectionObserver;
import com.ss.bytertc.engine.video.Rectangle;
import java.lang.ref.WeakReference;
import org.webrtc.CalledByNative;

public class RTCFaceDetectionObserver {
    private static final String TAG = "RTCFaceDetectionObserver";
    private WeakReference<RTCEngineImpl> mRtcEngineImpl;
    private WeakReference<RTCVideoImpl> mRtcVideoImpl;

    public RTCFaceDetectionObserver(RTCEngineImpl rtcEngineImpl) {
        this.mRtcEngineImpl = new WeakReference<RTCEngineImpl>(rtcEngineImpl);
    }

    public RTCFaceDetectionObserver(RTCVideoImpl rtcVideoImpl) {
        this.mRtcVideoImpl = new WeakReference<RTCVideoImpl>(rtcVideoImpl);
    }

    @CalledByNative
    void OnFaceDetectResult(int ret, int image_width, int image_height, int face_count, InternalRectangle[] faces) {
        RTCVideoImpl strongVideo;
        RTCEngineImpl strongEngine;
        IFaceDetectionObserver faceDetectionObserver = null;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null) {
            faceDetectionObserver = strongEngine.getFaceDetectionObserver();
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null) {
            faceDetectionObserver = strongVideo.getFaceDetectionObserver();
        }
        if (faceDetectionObserver == null) {
            return;
        }
        FaceDetectionResult result = new FaceDetectionResult();
        result.detectResult = ret;
        if (result.detectResult == 0) {
            result.imageWidth = image_width;
            result.imageHeight = image_height;
            if (faces != null && faces.length > 0) {
                result.faces = new Rectangle[faces.length];
                for (int i = 0; i < face_count; ++i) {
                    result.faces[i] = new Rectangle(faces[i].x, faces[i].y, faces[i].width, faces[i].height);
                }
            } else {
                result.faces = null;
            }
        } else {
            result.imageWidth = image_width;
            result.imageHeight = image_height;
            result.faces = null;
        }
        faceDetectionObserver.onFaceDetectResult(result);
    }

    @CalledByNative
    void OnExpressionDetectResult(int ret, int faceCount, InternalExpressDetectInfo[] faces) {
        RTCVideoImpl strongVideo;
        RTCEngineImpl strongEngine;
        IFaceDetectionObserver faceDetectionObserver = null;
        if (this.mRtcEngineImpl != null && (strongEngine = (RTCEngineImpl)this.mRtcEngineImpl.get()) != null) {
            faceDetectionObserver = strongEngine.getFaceDetectionObserver();
        }
        if (this.mRtcVideoImpl != null && (strongVideo = (RTCVideoImpl)this.mRtcVideoImpl.get()) != null) {
            faceDetectionObserver = strongVideo.getFaceDetectionObserver();
        }
        if (faceDetectionObserver == null) {
            return;
        }
        ExpressionDetectResult result = new ExpressionDetectResult();
        result.detectResult = ret;
        if (result.detectResult == 0) {
            if (faces != null && faceCount > 0) {
                result.detectInfo = new ExpressionDetectInfo[faceCount];
                result.faceCount = faceCount;
                for (int i = 0; i < faceCount; ++i) {
                    InternalExpressDetectInfo info = faces[i];
                    result.detectInfo[i] = new ExpressionDetectInfo(info.age, info.boyProb, info.attractive, info.happyScore, info.sadScore, info.angryScore, info.surpriseScore, info.arousal, info.valence);
                }
            } else {
                result.detectInfo = null;
            }
        } else {
            result.detectInfo = null;
        }
        faceDetectionObserver.onExpressionDetectResult(result);
    }
}

