/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.handler;

import com.ss.bytertc.engine.InternalRTCUser;
import com.ss.bytertc.engine.InternalRemoteStreamSwitch;
import com.ss.bytertc.engine.InternalSourceWantedData;
import com.ss.bytertc.engine.SysStats;
import com.ss.bytertc.engine.data.AudioMixingError;
import com.ss.bytertc.engine.data.AudioMixingState;
import com.ss.bytertc.engine.data.AudioPlaybackDevice;
import com.ss.bytertc.engine.data.AudioRoute;
import com.ss.bytertc.engine.data.LocalAudioPropertiesInfo;
import com.ss.bytertc.engine.data.LocalAudioStreamError;
import com.ss.bytertc.engine.data.LocalAudioStreamState;
import com.ss.bytertc.engine.data.MuteState;
import com.ss.bytertc.engine.data.RecordingInfo;
import com.ss.bytertc.engine.data.RecordingProgress;
import com.ss.bytertc.engine.data.RemoteAudioPropertiesInfo;
import com.ss.bytertc.engine.data.RemoteAudioState;
import com.ss.bytertc.engine.data.RemoteAudioStateChangeReason;
import com.ss.bytertc.engine.data.RemoteStreamKey;
import com.ss.bytertc.engine.data.StreamIndex;
import com.ss.bytertc.engine.data.StreamSycnInfoConfig;
import com.ss.bytertc.engine.data.VideoFrameInfo;
import com.ss.bytertc.engine.engineimpl.RTCVideoImpl;
import com.ss.bytertc.engine.handler.IRTCVideoEventHandler;
import com.ss.bytertc.engine.type.AudioDeviceType;
import com.ss.bytertc.engine.type.EchoTestResult;
import com.ss.bytertc.engine.type.FirstFramePlayState;
import com.ss.bytertc.engine.type.FirstFrameSendState;
import com.ss.bytertc.engine.type.LocalVideoStreamError;
import com.ss.bytertc.engine.type.LocalVideoStreamState;
import com.ss.bytertc.engine.type.NetworkDetectionLinkType;
import com.ss.bytertc.engine.type.NetworkDetectionStopReason;
import com.ss.bytertc.engine.type.PerformanceAlarmMode;
import com.ss.bytertc.engine.type.PerformanceAlarmReason;
import com.ss.bytertc.engine.type.RecordingErrorCode;
import com.ss.bytertc.engine.type.RecordingState;
import com.ss.bytertc.engine.type.RemoteStreamSwitch;
import com.ss.bytertc.engine.type.RemoteVideoState;
import com.ss.bytertc.engine.type.RemoteVideoStateChangeReason;
import com.ss.bytertc.engine.type.RtcUser;
import com.ss.bytertc.engine.type.SEIStreamUpdateEvent;
import com.ss.bytertc.engine.type.SourceWantedData;
import com.ss.bytertc.engine.type.VideoDeviceType;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import org.json.JSONException;
import org.json.JSONObject;
import org.webrtc.CalledByNative;

public class RTCVideoEventHandler {
    private String mRoom;
    private String mUser;
    private String mSession;
    private State mState = State.IDLE;
    private static final String TAG = "RtcVideoEventHandler";
    private static final String WEBRTC_MONITOR_TAG = "live_webrtc_monitor_log";
    private static final String WEBRTC_MEDIA_STAT_KEY = "rtc_media_statistics";
    private static final String WEBRTC_TRANSPORT_STAT_KEY = "rtc_transport_statistics";
    private static final String WEBRTC_STATISTICS_KEY = "rtc_statistics";
    private long mJoinChannelTime = 0L;
    private WeakReference<RTCVideoImpl> mRTCVideoImpl;

    public RTCVideoEventHandler(RTCVideoImpl RTCVideoImpl2) {
        this.mRTCVideoImpl = new WeakReference<RTCVideoImpl>(RTCVideoImpl2);
    }

    public void setJoinChannelTime(long time) {
        this.mJoinChannelTime = time;
    }

    @CalledByNative
    public void onError(int errorNum) {
        LogUtil.d(TAG, "onError...errorNum: " + errorNum);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onError(errorNum);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onWarning(int warnNum) {
        LogUtil.d(TAG, "onWarning, warnNum: " + warnNum);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onWarning(warnNum);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSysStats(SysStats stats) {
        LogUtil.e(TAG, "onSysStats... " + stats.toString());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSysStats(stats);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSysStats callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMuteAudio(String roomId, String uid, MuteState muteState) {
        LogUtil.d(TAG, "onUserMuteAudio... uid: " + uid + ", muteState: " + muteState.value() + ", roomId: " + roomId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMuteAudio(roomId, uid, muteState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMuteAudio callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMuteVideo(String roomId, String uid, MuteState muteState) {
        boolean muted = muteState == MuteState.MUTE_STATE_ON;
        LogUtil.d(TAG, "onUserMuteVideo... uid: " + uid + ", muted: " + muted + ", roomId: " + roomId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMuteVideo(roomId, uid, muteState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMuteVideo callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onCreateRoomStateChanged(String roomId, int error_code) {
        LogUtil.d(TAG, "onCreateRoomStateChanged...");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onCreateRoomStateChanged(roomId, error_code);
            }
        }
        catch (Exception exception) {
            LogUtil.e(TAG, "onCreateRoomStateChanged callback catch exception.\n" + exception.getMessage());
        }
    }

    @CalledByNative
    public void onUserStartVideoCapture(String roomId, String uid) {
        LogUtil.d(TAG, "onUserStartVideoCapture... uid: " + uid + ", roomId: " + roomId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStartVideoCapture(roomId, uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStartVideoCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStopVideoCapture(String roomId, String uid) {
        LogUtil.d(TAG, "onUserStopVideoCapture... uid: " + uid + ", roomId: " + roomId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStopVideoCapture(roomId, uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStopVideoCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStartAudioCapture(String roomId, String uid) {
        LogUtil.d(TAG, "onUserStartAudioCapture... uid: " + uid + ", roomId: " + roomId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStartAudioCapture(roomId, uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStartAudioCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserStopAudioCapture(String roomId, String uid) {
        LogUtil.d(TAG, "onUserStopAudioCapture... uid: " + uid);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserStopAudioCapture(roomId, uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserStopAudioCapture callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalAudioStateChanged(LocalAudioStreamState state, LocalAudioStreamError error) {
        LogUtil.d(TAG, "onLocalAudioStateChanged...");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalAudioStateChanged(state, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalAudioStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteAudioStateChanged(RemoteStreamKey key, RemoteAudioState state, RemoteAudioStateChangeReason reason) {
        LogUtil.d(TAG, "onRemoteAudioStateChanged...");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteAudioStateChanged(key, state, reason);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteAudioStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalVideoStateChanged(StreamIndex index, LocalVideoStreamState state, LocalVideoStreamError error) {
        LogUtil.d(TAG, "onLocalVideoStateChanged...");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalVideoStateChanged(index, state, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalVideoStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteVideoStateChanged(RemoteStreamKey streamKey, RemoteVideoState videoState, RemoteVideoStateChangeReason videoStateReason) {
        LogUtil.d(TAG, "onRemoteVideoStateChanged...");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteVideoStateChanged(streamKey, videoState, videoStateReason);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteVideoStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioPlaybackDeviceChanged(AudioPlaybackDevice device) {
        LogUtil.d(TAG, "onAudioPlaybackDeviceChanged...device: " + device.value());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioPlaybackDeviceChanged(device);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioPlaybackDeviceChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioRouteChanged(AudioRoute device) {
        LogUtil.d(TAG, "onAudioRouteChanged...device: " + device.value());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioRouteChanged(device);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioRouteChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstLocalAudioFrame(StreamIndex streamIndex) {
        LogUtil.d(TAG, "onFirstLocalAudioFrame...streamIndex: " + streamIndex.value());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstLocalAudioFrame(streamIndex);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstLocalAudioFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstRemoteAudioFrame(RemoteStreamKey remoteStreamKey) {
        LogUtil.d(TAG, "onFirstRemoteAudioFrame...uid: " + remoteStreamKey.getUserId() + ", roomid: " + remoteStreamKey.getRoomId() + ", streamIndex: " + remoteStreamKey.getStreamIndex().value());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstRemoteAudioFrame(remoteStreamKey);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstRemoteAudioFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstLocalVideoFrameCaptured(StreamIndex streamIndex, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstLocalVideoFrame...width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstLocalVideoFrameCaptured(streamIndex, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstLocalVideoFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstRemoteVideoFrameRendered(RemoteStreamKey streamKey, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstRemoteVideoFrameRendered...uid: " + streamKey.getUserId() + ", StreamIndex:" + (Object)((Object)streamKey.getStreamIndex()) + ", width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstRemoteVideoFrameRendered(streamKey, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstRemoteVideoFrameRendered callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstRemoteVideoFrameDecoded(RemoteStreamKey streamKey, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstRemoteVideoFrameDecoded...uid: " + streamKey.getUserId() + ", StreamIndex:" + (Object)((Object)streamKey.getStreamIndex()) + ", width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstRemoteVideoFrameDecoded(streamKey, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstRemoteVideoFrameDecoded callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalVideoSizeChanged(StreamIndex streamIndex, VideoFrameInfo frameInfo) {
        LogUtil.d(TAG, "onLocalVideoSizeChanged... streamIndex: " + (Object)((Object)streamIndex) + ", frameInfo: " + frameInfo);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalVideoSizeChanged(streamIndex, frameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalVideoSizeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteVideoSizeChanged(RemoteStreamKey streamKey, VideoFrameInfo frameInfo) {
        LogUtil.d(TAG, "onRemoteVideoSizeChanged... RemoteStreamKey: " + streamKey + ", frameInfo: " + frameInfo);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteVideoSizeChanged(streamKey, frameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteVideoSizeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLogReport(String logType, String logContent) {
        try {
            if (WEBRTC_MONITOR_TAG.equals(logType)) {
                IRTCVideoEventHandler engineEventHandlerRef;
                JSONObject logJson;
                try {
                    logJson = new JSONObject(logContent);
                }
                catch (JSONException exception) {
                    LogUtil.d(TAG, "onLogReport...parse json catch exception: " + exception.getMessage());
                    return;
                }
                RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
                if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                    engineEventHandlerRef.onLogReport(logType, logJson);
                }
                return;
            }
            LogUtil.i(logType, logContent);
            return;
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLogReport callback catch exception.\n" + ex.getMessage());
            return;
        }
    }

    @CalledByNative
    public static ByteBuffer allocateDirectByteBuffer(int capacity) {
        return ByteBuffer.allocateDirect(capacity);
    }

    @CalledByNative
    public void onSEIMessageReceived(RemoteStreamKey key, ByteBuffer msg) {
        LogUtil.d(TAG, "onSEIMessageReceived" + key.getRoomId() + key.getUserId());
        try {
            IRTCVideoEventHandler engineEventHandler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onSEIMessageReceived(key, msg);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSEIMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSEIStreamUpdate(RemoteStreamKey key, int event) {
        LogUtil.d(TAG, "onSEIStreamUpdate" + key.getRoomId() + key.getUserId());
        try {
            IRTCVideoEventHandler engineEventHandler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onSEIStreamUpdate(key, SEIStreamUpdateEvent.values()[event]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSEIStreamUpdate callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLoginResult(String uid, int error_code, int elapsed) {
        LogUtil.d(TAG, "OnLoginResult: " + uid + error_code + elapsed);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLoginResult(uid, error_code, elapsed);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLoginResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLogout() {
        LogUtil.d(TAG, "onLogout");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLogout();
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLogout callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onServerParamsSetResult(int error) {
        LogUtil.d(TAG, "onServerParamsSetResult: " + error);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onServerParamsSetResult(error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onServerParamsSetResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onGetPeerOnlineStatus(String peerUserId, int status) {
        LogUtil.d(TAG, "onGetPeerOnlineStatus: " + peerUserId + status);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onGetPeerOnlineStatus(peerUserId, status);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onGetPeerOnlineStatus callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageReceivedOutsideRoom(String uid, String message) {
        LogUtil.d(TAG, "onUserMessageReceivedOutsideRoom: " + uid + message);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMessageReceivedOutsideRoom(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMessageReceivedOutsideRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserBinaryMessageReceivedOutsideRoom(String uid, ByteBuffer message) {
        LogUtil.d(TAG, "onUserBinaryMessageReceivedOutsideRoom: " + uid + message.capacity());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserBinaryMessageReceivedOutsideRoom(uid, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserBinaryMessageReceivedOutsideRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onUserMessageSendResultOutsideRoom(long msgid, int error) {
        LogUtil.d(TAG, "onUserMessageSendResultOutsideRoom: " + msgid + error);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onUserMessageSendResultOutsideRoom(msgid, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onUserMessageSendResultOutsideRoom callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onServerMessageSendResult(long msgid, int error, ByteBuffer message) {
        LogUtil.d(TAG, "onServerMessageSendResult: " + msgid + error);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onServerMessageSendResult(msgid, error, message);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onServerMessageSendResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkProbeResult(int type, int quality, int rtt, double lost_rate, int bitrate, int jitter) {
        LogUtil.d(TAG, "onNetworkProbeResult: " + type + "," + quality + "," + rtt + "," + lost_rate + "," + bitrate + "," + jitter);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onNetworkDetectionResult(NetworkDetectionLinkType.values()[type], quality, rtt, lost_rate, bitrate, jitter);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkDetectionResult callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkProbeStopped(int err_code) {
        LogUtil.d(TAG, "onNetworkProbeStopped: " + err_code);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onNetworkDetectionStopped(NetworkDetectionStopReason.values()[err_code]);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkDetectionStopped callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onConnectionStateChanged(int state) {
        LogUtil.i(TAG, "onConnectionStateChanged, state: " + state);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onConnectionStateChanged(state, -1);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onConnectionStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onNetworkTypeChanged(int type) {
        LogUtil.i(TAG, "onNetworkTypeChanged, type: " + type);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onNetworkTypeChanged(type);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkTypeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSimulcastSubscribeFallback(InternalRemoteStreamSwitch event) {
        LogUtil.d(TAG, "onSimulcastSubscribeFallback, uid: " + event.uid + ", before_video_index: " + event.before_video_index + ", after_video_index: " + event.after_video_index + ", before_enable: " + event.before_enable + ", after_enable: " + event.after_enable + ", reason: " + event.reason);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSimulcastSubscribeFallback(new RemoteStreamSwitch(event));
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onNetworkTypeChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPerformanceAlarms(int mode, String roomId, int reason, InternalSourceWantedData data) {
        LogUtil.d(TAG, "onPerformanceAlarms, level: " + reason + ", data: " + data);
        try {
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null) {
                PerformanceAlarmReason level;
                switch (reason) {
                    case 0: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_BANDWIDTH_FALLBACKED;
                        break;
                    }
                    case 1: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_BANDWIDTH_RESUMED;
                        break;
                    }
                    case 2: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_PERFORMANCE_FALLBACKED;
                        break;
                    }
                    case 3: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_PERFORMANCE_RESUMED;
                        break;
                    }
                    default: {
                        level = PerformanceAlarmReason.PERFORMANCE_ALARM_REASON_PERFORMANCE_RESUMED;
                    }
                }
                IRTCVideoEventHandler engineEventHandlerRef = strongEngine.getRtcEngineHandler();
                if (engineEventHandlerRef != null) {
                    engineEventHandlerRef.onPerformanceAlarms(mode == 0 ? PerformanceAlarmMode.PERFORMANCE_ALARM_MODE_NORMAL : PerformanceAlarmMode.PERFORMANCE_ALARM_MODE_SIMULCAST, roomId, level, new SourceWantedData(data));
                }
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPerformanceAlarms callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onMediaDeviceStateChanged(String device_id, int device_type, int device_state, int device_error) {
        LogUtil.d(TAG, "onMediaDeviceStateChanged, MediaDeviceType: " + device_type + ", device_state: " + device_state);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onMediaDeviceStateChanged(device_id, device_type, device_state, device_error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMediaDeviceStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioDeviceStateChanged(String device_id, AudioDeviceType device_type, int device_state, int device_error) {
        LogUtil.d(TAG, "onAudioDeviceStateChanged, AudioDeviceType: " + (Object)((Object)device_type) + ", device_state: " + device_state);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onAudioDeviceStateChanged(device_id, device_type, device_state, device_error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioDeviceStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onVideoDeviceStateChanged(String device_id, VideoDeviceType device_type, int device_state, int device_error) {
        LogUtil.d(TAG, "onVideoDeviceStateChanged, VideoDeviceType: " + (Object)((Object)device_type) + ", device_state: " + device_state);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onVideoDeviceStateChanged(device_id, device_type, device_state, device_error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoDeviceStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onMediaDeviceWarning(String device_id, int device_type, int device_warning) {
        LogUtil.d(TAG, "onMediaDeviceWarning, MediaDeviceType: " + device_type + ", device_warning " + device_warning);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onMediaDeviceWarning(device_id, device_type, device_warning);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onMediaDeviceWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioDeviceWarning(String device_id, AudioDeviceType device_type, int device_warning) {
        LogUtil.d(TAG, "onAudioDeviceWarning, AudioDeviceType: " + (Object)((Object)device_type) + ", device_warning " + device_warning);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onAudioDeviceWarning(device_id, device_type, device_warning);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioDeviceWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onVideoDeviceWarning(String device_id, VideoDeviceType device_type, int device_warning) {
        LogUtil.d(TAG, "onVideoDeviceWarning, VideoDeviceType: " + (Object)((Object)device_type) + ", device_warning " + device_warning);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onVideoDeviceWarning(device_id, device_type, device_warning);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoDeviceWarning callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioFrameSendStateChanged(String roomId, InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onAudioFrameSendStateChanged, user: " + user + ", state: " + state);
        FirstFrameSendState sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
        switch (state) {
            case 0: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
                break;
            }
            case 1: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENT;
                break;
            }
            case 2: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STAT_END;
                break;
            }
        }
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onAudioFrameSendStateChanged(roomId, new RtcUser(user), sendState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioFrameSendStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onVideoFrameSendStateChanged(String roomId, InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onVideoFrameSendStateChanged, user: " + user + ", state: " + state);
        FirstFrameSendState sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
        switch (state) {
            case 0: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
                break;
            }
            case 1: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENT;
                break;
            }
            case 2: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STAT_END;
                break;
            }
        }
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onVideoFrameSendStateChanged(roomId, new RtcUser(user), sendState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoFrameSendStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onScreenVideoFrameSendStateChanged(String roomId, InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onScreenVideoFrameSendStateChanged, user: " + user + ", state: " + state);
        FirstFrameSendState sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
        switch (state) {
            case 0: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENDING;
                break;
            }
            case 1: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STATE_SENT;
                break;
            }
            case 2: {
                sendState = FirstFrameSendState.FIRST_FRAME_SEND_STAT_END;
                break;
            }
        }
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onScreenVideoFrameSendStateChanged(roomId, new RtcUser(user), sendState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onScreenVideoFrameSendStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onAudioFramePlayStateChanged(String roomId, InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onAudioFramePlayStateChanged, user: " + user + ", state: " + state);
        FirstFramePlayState playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
        switch (state) {
            case 0: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
                break;
            }
            case 1: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYED;
                break;
            }
            case 2: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_END;
                break;
            }
        }
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onAudioFramePlayStateChanged(roomId, new RtcUser(user), playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioFramePlayStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onVideoFramePlayStateChanged(String roomId, InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onVideoFramePlayStateChanged, user: " + user + ", state: " + state);
        FirstFramePlayState playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
        switch (state) {
            case 0: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
                break;
            }
            case 1: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYED;
                break;
            }
            case 2: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_END;
                break;
            }
        }
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onVideoFramePlayStateChanged(roomId, new RtcUser(user), playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onVideoFramePlayStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onScreenVideoFramePlayStateChanged(String roomId, InternalRTCUser user, int state) {
        LogUtil.d(TAG, "onScreenVideoFramePlayStateChanged, user: " + user + ", state: " + state);
        FirstFramePlayState playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
        switch (state) {
            case 0: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYING;
                break;
            }
            case 1: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_PLAYED;
                break;
            }
            case 2: {
                playState = FirstFramePlayState.FIRST_FRAME_PLAY_STATE_END;
                break;
            }
        }
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (handler = strongEngine.getRtcEngineHandler()) != null) {
                handler.onScreenVideoFramePlayStateChanged(roomId, new RtcUser(user), playState);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onScreenVideoFramePlayStateChanged callback catch exception.\n");
        }
    }

    @CalledByNative
    public void onHttpProxyState(int state) {
        LogUtil.i(TAG, "onHttpProxyState, state: " + state);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onHttpProxyState(state);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onHttpProxyState callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onHttpsProxyState(int state) {
        LogUtil.i(TAG, "onHttpsProxyState, state: " + state);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onHttpsProxyState(state);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onHttpsProxyState callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onSocks5ProxyState(int state, String cmd, String proxy_address, String local_address, String remote_address) {
        LogUtil.i(TAG, "onSocks5ProxyState, state: " + state + ", cmd: " + cmd + ", proxy_address: " + proxy_address + ", local_address: " + local_address + ", remote_address: " + remote_address);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onSocks5ProxyState(state, cmd, proxy_address, local_address, remote_address);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onSocks5ProxyState callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRecordingStateUpdate(StreamIndex type, int state, int errorCode, RecordingInfo info) {
        LogUtil.d(TAG, "onRecordingStateUpdate, StreamIndex: " + (Object)((Object)type) + ", RecordingState: " + state + ", RecordingErrorCode: " + errorCode + ", info.filePath: " + info.filePath);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onRecordingStateUpdate(type, RecordingState.fromId(state), RecordingErrorCode.fromId(errorCode), info);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRecordingStateUpdate callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRecordingProgressUpdate(StreamIndex type, RecordingProgress progress, RecordingInfo info) {
        LogUtil.d(TAG, "onRecordingProgressUpdate, StreamIndex: " + (Object)((Object)type) + ", progress.dur: " + progress.duration + ", progress.fileSize: " + progress.fileSize + ", info.filePath: " + info.filePath);
        try {
            IRTCVideoEventHandler handler;
            RTCVideoImpl rtcEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (rtcEngine != null && (handler = rtcEngine.getRtcEngineHandler()) != null) {
                handler.onRecordingProgressUpdate(type, progress, info);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRecordingProgressUpdate callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioMixingStateChanged(int mixId, AudioMixingState state, AudioMixingError error) {
        LogUtil.d(TAG, "onAudioMixingStateChanged... mixId: " + mixId + ", state: " + state.value() + ", error: " + error.value());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioMixingStateChanged(mixId, state, error);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioMixingStateChanged callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioMixingPlayingProgress(int mixId, long progress) {
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioMixingPlayingProgress(mixId, progress);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioMixingPlayingProgress callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onLocalAudioPropertiesReport(LocalAudioPropertiesInfo[] audioPropertiesInfos) {
        LogUtil.d(TAG, "onLocalAudioPropertiesReport");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onLocalAudioPropertiesReport(audioPropertiesInfos);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onLocalAudioPropertiesReport callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onAudioPlaybackDeviceTestVolume(int volume) {
        LogUtil.d(TAG, "onAudioPlaybackDeviceTestVolume");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onAudioPlaybackDeviceTestVolume(volume);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onAudioPlaybackDeviceTestVolume callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onRemoteAudioPropertiesReport(RemoteAudioPropertiesInfo[] audio_properties_infos, int totalRemoteVolume) {
        LogUtil.d(TAG, "onRemoteAudioPropertiesReport");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onRemoteAudioPropertiesReport(audio_properties_infos, totalRemoteVolume);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onRemoteAudioPropertiesReport callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onActiveSpeaker(String roomId, String uid) {
        LogUtil.d(TAG, "onActiveSpeaker");
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onActiveSpeaker(roomId, uid);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onActiveSpeaker callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onStreamSyncInfoReceived(RemoteStreamKey streamKey, ByteBuffer data, int streamType) {
        LogUtil.d(TAG, "onStreamSyncInfoReceived");
        try {
            IRTCVideoEventHandler engineEventHandler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onStreamSyncInfoReceived(streamKey, StreamSycnInfoConfig.SyncInfoStreamType.SYNC_INFO_STREAM_TYPE_AUDIO, data);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onStreamSyncInfoReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPushPublicStreamResult(String roomId, String publicStreamId, int errorCode) {
        int code = errorCode;
        LogUtil.d(TAG, "onPushPublicStreamError error(" + code + ") streamId:" + publicStreamId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onPushPublicStreamResult(roomId, publicStreamId, code);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPushPublicStreamError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPlayPublicStreamResult(String publicStreamId, int errorCode) {
        int code = errorCode;
        LogUtil.d(TAG, "onPlayPublicStreamError error(" + code + ") streamId:" + publicStreamId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onPlayPublicStreamResult(publicStreamId, code);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPlayPublicStreamError callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onPublicStreamSEIMessageReceived(String publicStreamId, ByteBuffer msg) {
        LogUtil.d(TAG, "onPublicStreamSEIMessageReceived, streamid" + publicStreamId);
        try {
            IRTCVideoEventHandler engineEventHandler;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandler = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandler.onPublicStreamSEIMessageReceived(publicStreamId, msg);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onPublicStreamSEIMessageReceived callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstPublicStreamVideoFrameDecoded(String publicStreamId, VideoFrameInfo videoFrameInfo) {
        LogUtil.d(TAG, "onFirstPublicStreamVideoFrameDecoded...streamid: " + publicStreamId + ", width: " + videoFrameInfo.getWidth() + ", height: " + videoFrameInfo.getHeight());
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstPublicStreamVideoFrameDecoded(publicStreamId, videoFrameInfo);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstPublicStreamVideoFrameDecoded callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onFirstPublicStreamAudioFrame(String publicStreamId) {
        LogUtil.d(TAG, "onFirstPublicStreamAudioFrame...streamid: " + publicStreamId);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onFirstPublicStreamAudioFrame(publicStreamId);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onFirstPublicStreamAudioFrame callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onCloudProxyConnected(int interval) {
        LogUtil.i(TAG, "onCloudProxyConnected, interval: " + interval);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                engineEventHandlerRef.onCloudProxyConnected(interval);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onCloudProxyConnected callback catch exception.\n" + ex.getMessage());
        }
    }

    @CalledByNative
    public void onEchoTestResult(int errorCode) {
        LogUtil.d(TAG, "onEchoTestResult...error code: " + errorCode);
        try {
            IRTCVideoEventHandler engineEventHandlerRef;
            RTCVideoImpl strongEngine = (RTCVideoImpl)this.mRTCVideoImpl.get();
            if (strongEngine != null && (engineEventHandlerRef = strongEngine.getRtcEngineHandler()) != null) {
                EchoTestResult result = EchoTestResult.ECHO_TEST_SUCCESS;
                switch (errorCode) {
                    case 1: {
                        result = EchoTestResult.ECHO_TEST_TIMEOUT;
                        break;
                    }
                    case 2: {
                        result = EchoTestResult.ECHO_TEST_INTERVAL_SHORT;
                        break;
                    }
                    case 3: {
                        result = EchoTestResult.ECHO_TEST_AUDIO_DEVICE_ERROR;
                        break;
                    }
                    case 4: {
                        result = EchoTestResult.ECHO_TEST_VIDEO_DEVICE_ERROR;
                        break;
                    }
                    case 5: {
                        result = EchoTestResult.ECHO_TEST_AUDIO_RECEIVE_ERROR;
                        break;
                    }
                    case 6: {
                        result = EchoTestResult.ECHO_TEST_VIDEO_RECEIVE_ERROR;
                        break;
                    }
                    case 7: {
                        result = EchoTestResult.ECHO_TEST_INTERNAL_ERROR;
                        break;
                    }
                }
                engineEventHandlerRef.onEchoTestResult(result);
            }
        }
        catch (Exception ex) {
            LogUtil.e(TAG, "onEchoTestResult callback catch exception.\n" + ex.getMessage());
        }
    }

    private static enum State {
        IDLE,
        IN_ROOM;

    }
}

