/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.mediaio;

import android.os.Handler;
import android.os.Looper;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import com.ss.bytertc.engine.ui.VideoFrameRender;
import com.ss.bytertc.engine.utils.LogUtil;
import java.lang.ref.SoftReference;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.EglBase;
import org.webrtc.RendererCommon;
import org.webrtc.SurfaceEglRenderer;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class SurfaceEglRender
extends SurfaceEglRenderer {
    private static final String TAG = "SurfaceEglRender";
    private SoftReference<SurfaceView> surfaceViewSoftReference;
    private final AtomicBoolean mHasInitAtomic = new AtomicBoolean(false);
    private final AtomicBoolean mHasBindAtomic = new AtomicBoolean(false);
    private final Object mSurfaceLifecycleCallbackLock = new Object();
    private VideoFrameRender.SurfaceLifecycleCallback mSurfaceLifecycleCallback;
    private final Object mSurfaceCallbackLock = new Object();
    private SurfaceHolder.Callback mCallback;

    public SurfaceEglRender(String name) {
        super(name);
        this.surfaceViewSoftReference = new SoftReference<Object>(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurfaceHolderCallback(SurfaceHolder.Callback callback) {
        Object object = this.mSurfaceCallbackLock;
        synchronized (object) {
            this.mCallback = callback;
        }
    }

    @Override
    public void init(EglBase.Context sharedContext, int[] configAttributes, RendererCommon.GlDrawer drawer) {
        ThreadUtils.checkIsOnMainThread();
        if (!this.mHasInitAtomic.compareAndSet(false, true)) {
            throw new IllegalStateException("SurfaceEglRender has already init!!!!!!");
        }
        LogUtil.d(TAG, "init");
        super.init(sharedContext, configAttributes, drawer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurfaceLifecycleLisenter(VideoFrameRender.SurfaceLifecycleCallback surfaceLifecycleCallback) {
        Object object = this.mSurfaceLifecycleCallbackLock;
        synchronized (object) {
            this.mSurfaceLifecycleCallback = surfaceLifecycleCallback;
        }
    }

    public void bind(SurfaceView surfaceView) {
        if (!this.mHasInitAtomic.get()) {
            throw new IllegalStateException("TextureEglRenderer has not init!!!!!!");
        }
        if (!this.mHasBindAtomic.compareAndSet(false, true)) {
            throw new IllegalStateException("Called bind functions multiple times!!!!!!");
        }
        LogUtil.d(TAG, "bind");
        this.runOnUIThread(() -> {
            SurfaceHolder holder = surfaceView.getHolder();
            Object object = this.mSurfaceCallbackLock;
            synchronized (object) {
                if (this.mCallback != null) {
                    holder.addCallback(this.mCallback);
                }
            }
            this.surfaceViewSoftReference = new SoftReference<SurfaceView>(surfaceView);
            if (holder.getSurface() != null && holder.getSurface().isValid()) {
                this.setLayoutAspectRatio((float)surfaceView.getMeasuredWidth() / (float)surfaceView.getMeasuredHeight());
                this.surfaceCreated(holder);
            }
            holder.addCallback((SurfaceHolder.Callback)this);
        });
    }

    @Override
    public void onFrame(VideoFrame frame) {
        if (!this.mHasInitAtomic.get() || !this.mHasBindAtomic.get()) {
            return;
        }
        super.onFrame(frame);
    }

    @Override
    public void release() {
        SurfaceView surfaceView;
        if (!this.mHasInitAtomic.compareAndSet(true, false)) {
            throw new IllegalStateException("TextureEglRenderer has not init or already released!!!!!");
        }
        LogUtil.d(TAG, "release");
        super.release();
        this.mHasBindAtomic.compareAndSet(true, false);
        if (this.surfaceViewSoftReference != null && (surfaceView = this.surfaceViewSoftReference.get()) != null) {
            surfaceView.getHolder().removeCallback((SurfaceHolder.Callback)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void surfaceCreated(SurfaceHolder holder) {
        super.surfaceCreated(holder);
        LogUtil.d(TAG, "surfaceCreated");
        Object object = this.mSurfaceLifecycleCallbackLock;
        synchronized (object) {
            if (this.mSurfaceLifecycleCallback != null) {
                this.mSurfaceLifecycleCallback.onCreated();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void surfaceDestroyed(SurfaceHolder holder) {
        super.surfaceDestroyed(holder);
        LogUtil.d(TAG, "surfaceDestroyed");
        Object object = this.mSurfaceLifecycleCallbackLock;
        synchronized (object) {
            if (this.mSurfaceLifecycleCallback != null) {
                this.mSurfaceLifecycleCallback.onDestroy();
            }
        }
    }

    @Override
    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
        super.surfaceChanged(holder, format, width, height);
        LogUtil.d(TAG, "surfaceChanged");
    }

    private void runOnUIThread(Runnable r) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            r.run();
        } else {
            new Handler(Looper.getMainLooper()).post(r);
        }
    }
}

