/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.ui;

import android.graphics.Matrix;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.Nullable;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.TextureView;
import android.view.View;
import com.ss.bytertc.engine.adapter.VideoFrameConverter;
import com.ss.bytertc.engine.data.VideoFrameType;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.mediaio.CountDownLatchI420Buffer;
import com.ss.bytertc.engine.mediaio.SurfaceEglRender;
import com.ss.bytertc.engine.mediaio.TextureEglRenderer;
import com.ss.bytertc.engine.utils.ByteBufferUtils;
import com.ss.bytertc.engine.utils.LogUtil;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.converter.WebRTCConverter;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import org.webrtc.EglBase;
import org.webrtc.EglRenderer;
import org.webrtc.GlRectDrawer;
import org.webrtc.JavaI420Buffer;
import org.webrtc.RendererCommon;
import org.webrtc.TextureBufferImpl;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;
import org.webrtc.YuvConverter;

public class VideoFrameRender
implements View.OnLayoutChangeListener,
RendererCommon.RendererEvents,
EglRenderer.FirstVideoFrameRenderListener {
    private static final String TAG = "VideoFrameRender";
    private final String mRenderName;
    private Looper mTextureProcessLooper;
    private final VideoFrameConverter frameConverter;
    private int rotatedFrameWidth;
    private int rotatedFrameHeight;
    private boolean enableFixedSize;
    private int surfaceWidth;
    private int surfaceHeight;
    private long mReceiveFirstTimeStamp = 0L;
    private boolean mHasReceivedFirstFrame = false;
    private final AtomicBoolean mHasInitAtomic = new AtomicBoolean(false);
    private final AtomicBoolean mHasRenderViewAtomic = new AtomicBoolean(false);
    private final AtomicBoolean mEglSurfaceCreatedAtomic = new AtomicBoolean(false);
    private final Object mRenderLock = new Object();
    private final Object mTextureProcessLock = new Object();
    private final Object mFirstFrameListenerLock = new Object();
    private volatile SurfaceView mSurfaceView;
    private volatile Surface mSurface;
    private volatile TextureView mTextureView;
    private volatile EglRenderer mEglRenderer;
    private final SurfaceLifecycleCallback mSurfaceLifecycleCallbackCallback;
    private final ArrayList<FirstVideoFrameRenderListener> mFirstVideoFrameListeners = new ArrayList();

    public VideoFrameRender(String name) {
        this.mRenderName = name;
        this.frameConverter = new VideoFrameConverter(true);
        this.mSurfaceLifecycleCallbackCallback = new SurfaceLifecycleCallback(){

            @Override
            public void onCreated() {
                if (!VideoFrameRender.this.mEglSurfaceCreatedAtomic.compareAndSet(false, true)) {
                    LogUtil.e(VideoFrameRender.TAG, "Already has an another surface created.");
                }
            }

            @Override
            public void onDestroy() {
                if (!VideoFrameRender.this.mHasInitAtomic.get()) {
                    VideoFrameRender.this.mEglSurfaceCreatedAtomic.set(false);
                } else if (!VideoFrameRender.this.mEglSurfaceCreatedAtomic.compareAndSet(true, false)) {
                    LogUtil.e(VideoFrameRender.TAG, "Already has an another surface destroyed.");
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderView(SurfaceView surfaceView, SurfaceHolder.Callback callback) {
        if (this.mEglSurfaceCreatedAtomic.get() || surfaceView == null || !this.mHasRenderViewAtomic.compareAndSet(false, true)) {
            return;
        }
        this.mSurfaceView = surfaceView;
        Object object = this.mRenderLock;
        synchronized (object) {
            SurfaceEglRender surfaceEglRender = new SurfaceEglRender(this.mRenderName);
            surfaceEglRender.setSurfaceHolderCallback(callback);
            surfaceEglRender.setSurfaceLifecycleLisenter(this.mSurfaceLifecycleCallbackCallback);
            this.mEglRenderer = surfaceEglRender;
            this.mEglRenderer.addFristFrameListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderView(Surface surface) {
        if (this.mEglSurfaceCreatedAtomic.get() || surface == null || !this.mHasRenderViewAtomic.compareAndSet(false, true)) {
            return;
        }
        Object object = this.mRenderLock;
        synchronized (object) {
            this.mSurface = surface;
            EglRenderer eglRenderer = new EglRenderer(this.mRenderName);
            eglRenderer.createEglSurface(surface);
        }
        this.mEglSurfaceCreatedAtomic.compareAndSet(false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRenderView(TextureView textureView, TextureView.SurfaceTextureListener listener) {
        if (this.mEglSurfaceCreatedAtomic.get() || textureView == null || !this.mHasRenderViewAtomic.compareAndSet(false, true)) {
            return;
        }
        Object object = this.mRenderLock;
        synchronized (object) {
            this.mTextureView = textureView;
            TextureEglRenderer textureEglRenderer = new TextureEglRenderer(this.mRenderName);
            textureEglRenderer.setSurfaceTextureListener(listener);
            this.mEglRenderer = textureEglRenderer;
            this.mEglRenderer.addFristFrameListener(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initSurfaceView() {
        if (this.mSurfaceView == null || !this.mHasInitAtomic.get()) {
            return;
        }
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer instanceof SurfaceEglRender) {
                SurfaceEglRender render = (SurfaceEglRender)this.mEglRenderer;
                render.bind(this.mSurfaceView);
                this.mSurfaceView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTextureView() {
        if (this.mTextureView == null || this.mEglRenderer == null || !this.mHasInitAtomic.get()) {
            return;
        }
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer instanceof TextureEglRenderer) {
                TextureEglRenderer render = (TextureEglRenderer)this.mEglRenderer;
                render.bind(this.mTextureView, this.mSurfaceLifecycleCallbackCallback);
                if (this.mTextureView.isShown()) {
                    render.setLayoutAspectRatio((float)this.mTextureView.getMeasuredWidth() / (float)this.mTextureView.getMeasuredHeight());
                }
                this.mTextureView.addOnLayoutChangeListener((View.OnLayoutChangeListener)this);
            }
        }
    }

    public void onStart() {
        if (!this.mHasRenderViewAtomic.get() || !this.mHasInitAtomic.get()) {
            return;
        }
        if (this.mTextureView != null) {
            this.initTextureView();
        } else if (this.mSurfaceView != null) {
            this.initSurfaceView();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDispose() {
        if (this.mHasInitAtomic.compareAndSet(true, false)) {
            Object object = this.mRenderLock;
            synchronized (object) {
                if (this.mEglRenderer != null) {
                    this.mEglRenderer.release();
                    this.mEglRenderer.createEglSurface((Surface)null);
                }
                if (this.mSurfaceView != null) {
                    this.mSurfaceView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                } else if (this.mTextureView != null) {
                    this.mTextureView.setSurfaceTextureListener(null);
                    this.mTextureView.removeOnLayoutChangeListener((View.OnLayoutChangeListener)this);
                }
                this.mEglSurfaceCreatedAtomic.set(false);
            }
            object = this.mFirstFrameListenerLock;
            synchronized (object) {
                this.mFirstVideoFrameListeners.clear();
            }
        }
        throw new IllegalStateException("Try to dispose an not initialized VideoFrameRender");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init(EglBase.Context sharedContext) {
        if (this.mHasInitAtomic.compareAndSet(false, true)) {
            Object object = this.mRenderLock;
            synchronized (object) {
                if (this.mSurfaceView == null && this.mSurface == null && this.mTextureView == null && this.mEglRenderer == null) {
                    return;
                }
                this.rotatedFrameWidth = 0;
                this.rotatedFrameHeight = 0;
                if (this.mEglRenderer instanceof SurfaceEglRender) {
                    ThreadUtils.invokeAtFrontUninterruptibly(new Handler(Looper.getMainLooper()), () -> this.mEglRenderer.init(sharedContext, EglBase.CONFIG_PLAIN, new GlRectDrawer()));
                } else {
                    this.mEglRenderer.init(sharedContext, EglBase.CONFIG_PLAIN, new GlRectDrawer());
                }
            }
        } else {
            throw new IllegalStateException("Already initialized");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onVideoFrame(org.webrtc.VideoFrame frame) {
        Object object = this.mRenderLock;
        synchronized (object) {
            if (!this.mEglSurfaceCreatedAtomic.get() || this.mEglRenderer == null) {
                return;
            }
            if (!this.mHasReceivedFirstFrame) {
                this.mReceiveFirstTimeStamp = System.currentTimeMillis();
                this.mHasReceivedFirstFrame = true;
            }
            this.mEglRenderer.onFrame(frame);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScalingType(RendererCommon.ScalingType scalingType) {
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer != null) {
                this.mEglRenderer.setRenderModel(scalingType);
            }
        }
    }

    public void release() {
        this.onDispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMirror(boolean mirror) {
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer != null) {
                this.mEglRenderer.setMirror(mirror);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        ThreadUtils.checkIsOnMainThread();
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer != null) {
                this.mEglRenderer.setLayoutAspectRatio((float)(right - left) / (float)(bottom - top));
            }
            if (this.mSurfaceView != null) {
                this.updateSurfaceSize();
            }
        }
    }

    @Override
    public void onFirstFrameRendered() {
    }

    @Override
    public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
        int rotatedWidth = rotation == 0 || rotation == 180 ? videoWidth : videoHeight;
        int rotatedHeight = rotation == 0 || rotation == 180 ? videoHeight : videoWidth;
        this.postOrRun(() -> {
            this.rotatedFrameWidth = rotatedWidth;
            this.rotatedFrameHeight = rotatedHeight;
        });
    }

    private void renderTextureFrame(int texId, VideoFrame.TextureBuffer.Type type, int width, int height, int rotation, long ts, float[] matrix, Looper looper) {
        Matrix m = RendererCommon.convertMatrixToAndroidGraphicsMatrix(matrix);
        TextureBufferImpl buffer = new TextureBufferImpl(width, height, type, texId, m, new Handler(looper), new YuvConverter(), () -> {});
        org.webrtc.VideoFrame frame = new org.webrtc.VideoFrame(buffer, rotation, ts);
        this.onVideoFrame(frame);
        frame.release();
    }

    public void consumeByteBufferFrame(ByteBuffer buffer, @Nullable ByteBuffer extendedData, int format, int width, int height, int rotation, long timestamp) {
        if (format != VideoPixelFormat.kVideoPixelFormatI420.value()) {
            return;
        }
        this.renderI420Frame(buffer, width, height, rotation, timestamp);
    }

    public void consumeByteArrayFrame(byte[] data, @Nullable ByteBuffer extendedData, int format, int width, int height, int rotation, long timestamp) {
        if (format != VideoPixelFormat.kVideoPixelFormatI420.value()) {
            return;
        }
        this.renderI420Frame(data, width, height, rotation, timestamp);
    }

    public void consumeYUVByteArrayFrame(byte[] y, byte[] u, byte[] v, int ystride, int ustride, int vstride, int width, int height, int rotation, long timestamp, @Nullable ByteBuffer extendedData) {
        ByteBuffer yuvBuffer = this.frameConverter.convertRawYUV2ByteArray(y, u, v, ystride, ustride, vstride, width, height);
        this.renderI420Frame(yuvBuffer, width, height, rotation, timestamp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consumeTextureFrame(int textureId, @Nullable ByteBuffer extendedData, int format, int width, int height, int rotation, long timestamp, float[] matrix) {
        if (format != VideoPixelFormat.kVideoPixelFormatI420.value()) {
            return;
        }
        Object object = this.mTextureProcessLock;
        synchronized (object) {
            if (this.mTextureProcessLooper == null) {
                this.mTextureProcessLooper = Looper.getMainLooper();
            }
            this.renderTextureFrame(textureId, VideoFrame.TextureBuffer.Type.RGB, width, height, rotation, timestamp, matrix, this.mTextureProcessLooper);
        }
    }

    public void consumeVideoFrame(VideoFrame frame) {
        org.webrtc.VideoFrame webrtcFrame = null;
        if (frame.getFrameType() == VideoFrameType.kVideoFrameTypeGLTexture) {
            webrtcFrame = WebRTCConverter.convertByteTexFrame2WebrtcTexFrame(frame, this.mTextureProcessLooper);
        } else if (frame.getPixelFormat() == VideoPixelFormat.kVideoPixelFormatI420) {
            webrtcFrame = WebRTCConverter.convertByteI420Frame2WebrtcI420Frame(frame);
        }
        if (webrtcFrame != null) {
            this.onVideoFrame(webrtcFrame);
            webrtcFrame.release();
        }
    }

    private void renderI420Frame(ByteBuffer data, int width, int height, int rotation, long ts) {
        VideoFrame.I420Buffer i420Buffer;
        VideoFrameConverter frameRenderConverterRef;
        if (data != null && (frameRenderConverterRef = this.frameConverter) != null && (i420Buffer = this.mEglRenderer instanceof TextureEglRenderer ? frameRenderConverterRef.convertToJavaI420Buffer(data, width, height, true) : frameRenderConverterRef.convertToJavaI420Buffer(data, width, height, false)) != null) {
            org.webrtc.VideoFrame frame = new org.webrtc.VideoFrame(i420Buffer, rotation, ts);
            this.onVideoFrame(frame);
            frame.release();
        }
    }

    private void renderI420Frame(byte[] data, int width, int height, int rotation, long ts) {
        VideoFrame.I420Buffer i420Buffer;
        VideoFrameConverter frameRenderConverterRef;
        if (data != null && data.length > 0 && (frameRenderConverterRef = this.frameConverter) != null && (i420Buffer = this.mEglRenderer instanceof TextureEglRenderer ? frameRenderConverterRef.convertToJavaI420Buffer(data, width, height, true) : frameRenderConverterRef.convertToJavaI420Buffer(data, width, height, false)) != null) {
            org.webrtc.VideoFrame frame = new org.webrtc.VideoFrame(i420Buffer, rotation, ts);
            this.onVideoFrame(frame);
            frame.release();
        }
    }

    private VideoFrame.Buffer createYUV(byte[] data, int width, int height) {
        if (data != null && data.length != 0) {
            int chromaHeight = (height + 1) / 2;
            int strideUV = (width + 1) / 2;
            int sizeY = width * height;
            int sizeU = strideUV * chromaHeight;
            int sizeV = strideUV * chromaHeight;
            ByteBuffer bufferY = ByteBufferUtils.nativeAllocateBuffer(sizeY);
            ByteBuffer bufferU = ByteBufferUtils.nativeAllocateBuffer(sizeU);
            ByteBuffer bufferV = ByteBufferUtils.nativeAllocateBuffer(sizeV);
            if (bufferY == null || bufferU == null || bufferV == null) {
                if (bufferY != null) {
                    ByteBufferUtils.nativeReleaseBuffer(bufferY);
                }
                if (bufferU != null) {
                    ByteBufferUtils.nativeReleaseBuffer(bufferU);
                }
                if (bufferV != null) {
                    ByteBufferUtils.nativeReleaseBuffer(bufferV);
                }
                return null;
            }
            bufferY.put(data, 0, sizeY);
            bufferU.put(data, sizeY, sizeU);
            bufferV.put(data, sizeY + sizeU, sizeV);
            bufferY.position(0);
            bufferU.position(0);
            bufferV.position(0);
            if (this.mEglRenderer instanceof TextureEglRenderer) {
                return CountDownLatchI420Buffer.wrap(width, height, bufferY, width, bufferU, strideUV, bufferV, strideUV, () -> {
                    ByteBufferUtils.nativeReleaseBuffer(bufferY);
                    ByteBufferUtils.nativeReleaseBuffer(bufferU);
                    ByteBufferUtils.nativeReleaseBuffer(bufferV);
                });
            }
            return JavaI420Buffer.wrap(width, height, bufferY, width, bufferU, strideUV, bufferV, strideUV, () -> {
                ByteBufferUtils.nativeReleaseBuffer(bufferY);
                ByteBufferUtils.nativeReleaseBuffer(bufferU);
                ByteBufferUtils.nativeReleaseBuffer(bufferV);
            });
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessTextureLopper(Looper looper) {
        Object object = this.mTextureProcessLock;
        synchronized (object) {
            this.mTextureProcessLooper = looper;
        }
    }

    public void setEnableHardwareScaler(boolean enabled) {
        ThreadUtils.checkIsOnMainThread();
        this.enableFixedSize = enabled;
        if (this.mSurfaceView != null) {
            this.updateSurfaceSize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFpsReduction(float fps) {
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer != null) {
                this.mEglRenderer.setFpsReduction(fps);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disableFpsReduction() {
        Object object = this.mRenderLock;
        synchronized (object) {
            if (this.mEglRenderer != null) {
                this.mEglRenderer.disableFpsReduction();
            }
        }
    }

    private void updateSurfaceSize() {
        ThreadUtils.checkIsOnMainThread();
        if (this.enableFixedSize && this.rotatedFrameWidth != 0 && this.rotatedFrameHeight != 0 && this.mSurfaceView.getWidth() != 0 && this.mSurfaceView.getHeight() != 0) {
            int drawnFrameHeight;
            int drawnFrameWidth;
            float frameAspectRatio = (float)this.rotatedFrameWidth / (float)this.rotatedFrameHeight;
            float layoutAspectRatio = (float)this.mSurfaceView.getWidth() / (float)this.mSurfaceView.getHeight();
            if (frameAspectRatio > layoutAspectRatio) {
                drawnFrameWidth = (int)((float)this.rotatedFrameHeight * layoutAspectRatio);
                drawnFrameHeight = this.rotatedFrameHeight;
            } else {
                drawnFrameWidth = this.rotatedFrameWidth;
                drawnFrameHeight = (int)((float)this.rotatedFrameWidth / layoutAspectRatio);
            }
            int width = Math.min(this.mSurfaceView.getWidth(), drawnFrameWidth);
            int height = Math.min(this.mSurfaceView.getHeight(), drawnFrameHeight);
            LogUtil.d(TAG, "updateSurfaceSize. Layout size: " + this.mSurfaceView.getWidth() + "x" + this.mSurfaceView.getHeight() + ", frame size: " + this.rotatedFrameWidth + "x" + this.rotatedFrameHeight + ", requested surface size: " + width + "x" + height + ", old surface size: " + this.surfaceWidth + "x" + this.surfaceHeight);
            if (width != this.surfaceWidth || height != this.surfaceHeight) {
                this.surfaceWidth = width;
                this.surfaceHeight = height;
                this.mSurfaceView.getHolder().setFixedSize(width, height);
            }
        } else {
            this.surfaceHeight = 0;
            this.surfaceWidth = 0;
            this.mSurfaceView.getHolder().setSizeFromLayout();
        }
    }

    private void postOrRun(Runnable r) {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            r.run();
        }
    }

    private void runOnUIThread(Runnable r) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            r.run();
        } else {
            new Handler(Looper.getMainLooper()).post(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFristVideoFrameRenderListener(FirstVideoFrameRenderListener listener) {
        Object object = this.mFirstFrameListenerLock;
        synchronized (object) {
            this.mFirstVideoFrameListeners.add(listener);
        }
    }

    @Override
    public void onFirstVideoFrameRender() {
        this.notifyFristRenderCallback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyFristRenderCallback() {
        Object object = this.mFirstFrameListenerLock;
        synchronized (object) {
            if (this.mFirstVideoFrameListeners.isEmpty()) {
                return;
            }
            int elapse = (int)(System.currentTimeMillis() - this.mReceiveFirstTimeStamp);
            for (FirstVideoFrameRenderListener tmpListener : this.mFirstVideoFrameListeners) {
                tmpListener.onFirstVideoFrameRender(elapse);
            }
        }
    }

    public static interface SurfaceLifecycleCallback {
        public void onCreated();

        public void onDestroy();
    }

    public static interface FirstVideoFrameRenderListener {
        public void onFirstVideoFrameRender(int var1);
    }
}

