/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.engine.video.builder;

import android.opengl.EGLContext;
import com.ss.bytertc.engine.data.ColorSpace;
import com.ss.bytertc.engine.data.VideoPixelFormat;
import com.ss.bytertc.engine.data.VideoRotation;
import com.ss.bytertc.engine.video.VideoFrame;
import com.ss.bytertc.engine.video.impl.DirectBufferVideoFrame;
import java.nio.ByteBuffer;

public class GLTextureVideoFrameBuilder {
    private final DirectBufferVideoFrame frame;

    public GLTextureVideoFrameBuilder(VideoPixelFormat pixelFormat) {
        this.frame = new DirectBufferVideoFrame(pixelFormat);
    }

    public GLTextureVideoFrameBuilder setTimeStampUs(long timeStampUs) {
        this.frame.setTimeStampUs(timeStampUs);
        return this;
    }

    public GLTextureVideoFrameBuilder setWidth(int width) {
        this.frame.setWidth(width);
        return this;
    }

    public GLTextureVideoFrameBuilder setHeight(int height) {
        this.frame.setHeight(height);
        return this;
    }

    public GLTextureVideoFrameBuilder setRotation(VideoRotation rotation) {
        this.frame.setRotation(rotation);
        return this;
    }

    public GLTextureVideoFrameBuilder setColorSpace(ColorSpace colorSpace) {
        this.frame.setColorSpace(colorSpace);
        return this;
    }

    public GLTextureVideoFrameBuilder setExternalDataInfo(ByteBuffer externalDataInfo) {
        this.frame.setExternalDataInfo(externalDataInfo);
        return this;
    }

    public GLTextureVideoFrameBuilder setSupplementaryInfo(ByteBuffer supplementaryInfo) {
        this.frame.setSupplementaryInfo(supplementaryInfo);
        return this;
    }

    public GLTextureVideoFrameBuilder setTextureID(int textureID) {
        this.frame.setTextureID(textureID);
        return this;
    }

    public GLTextureVideoFrameBuilder setTextureMatrix(float[] textureMatrix) {
        this.frame.setTextureMatrix(textureMatrix);
        return this;
    }

    public GLTextureVideoFrameBuilder setEGLContext(EGLContext eglContext) {
        this.frame.setEGLContext(eglContext);
        return this;
    }

    public GLTextureVideoFrameBuilder setReleaseCallback(Runnable releaseCallback) {
        this.frame.setReleaseCallback(releaseCallback);
        return this;
    }

    public VideoFrame build() {
        return this.frame;
    }
}

