/*
 * Decompiled with CFR 0.152.
 */
package org.webrtc;

import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import android.support.annotation.Nullable;
import android.util.Log;
import com.bytedance.realx.RXDeviceInfo;
import java.util.ArrayList;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.EglBase14;
import org.webrtc.HardwareVideoEncoder;
import org.webrtc.MediaCodecUtils;
import org.webrtc.MediaCodecWrapperFactoryImpl;
import org.webrtc.RXVideoCodecDesc;
import org.webrtc.RXVideoCodecProfile;
import org.webrtc.RXVideoCodecStandard;
import org.webrtc.VideoEncoder;

public class HardwareVideoEncoderFactory {
    private static final String TAG = "HwVideoEncoderFactory";
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_L_MS = 15000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_M_MS = 20000;
    private static final int QCOM_VP8_KEY_FRAME_INTERVAL_ANDROID_N_MS = 15000;
    @Nullable
    private EglBase14.Context sharedContext = null;

    @CalledByNative
    public HardwareVideoEncoderFactory() {
    }

    @CalledByNative
    public void setHardwareContext(EglBase.Context sharedContext) {
        if (sharedContext instanceof EglBase14.Context) {
            this.sharedContext = (EglBase14.Context)sharedContext;
        }
    }

    @Nullable
    @CalledByNative
    public VideoEncoder createEncoder(RXVideoCodecDesc codecDesc) {
        if (Build.VERSION.SDK_INT < 19) {
            return null;
        }
        RXVideoCodecStandard standard = codecDesc.getStandard();
        MediaCodecInfo info = HardwareVideoEncoderFactory.findCodecForType(standard);
        if (info == null) {
            return null;
        }
        String codecName = info.getName();
        String mime = standard.mimeType();
        Integer surfaceColorFormat = MediaCodecUtils.selectColorFormat(MediaCodecUtils.TEXTURE_COLOR_FORMATS, info.getCapabilitiesForType(mime));
        if (surfaceColorFormat == null) {
            Log.e((String)TAG, (String)"surfaceColorFormat is null object.");
            return null;
        }
        int[] preferredColorFormats = codecName.contains("OMX.hisi.") ? MediaCodecUtils.ENCODER_COLOR_FORMATS_FOR_HISI : MediaCodecUtils.ENCODER_COLOR_FORMATS;
        Integer yuvColorFormat = MediaCodecUtils.selectColorFormat(preferredColorFormats, info.getCapabilitiesForType(mime));
        if (yuvColorFormat == null) {
            Log.e((String)TAG, (String)"yuvColorFormat is null object.");
            return null;
        }
        if (null == this.sharedContext) {
            Log.w((String)TAG, (String)"No shared EglBase.Context.  Encoders will not use texture mode.");
        }
        return new HardwareVideoEncoder(new MediaCodecWrapperFactoryImpl(), codecName, codecDesc, surfaceColorFormat, yuvColorFormat, HardwareVideoEncoderFactory.getKeyFrameIntervalSec(standard), HardwareVideoEncoderFactory.getForcedKeyFrameIntervalMs(standard, codecName), this.sharedContext);
    }

    @CalledByNative
    public static RXVideoCodecDesc[] getSupportedCodecs() {
        if (Build.VERSION.SDK_INT < 19) {
            return new RXVideoCodecDesc[0];
        }
        ArrayList<RXVideoCodecDesc> supportedCodecInfos = new ArrayList<RXVideoCodecDesc>();
        for (RXVideoCodecStandard standard : new RXVideoCodecStandard[]{RXVideoCodecStandard.ByteVC1, RXVideoCodecStandard.H264, RXVideoCodecStandard.VP8}) {
            MediaCodecInfo codec = HardwareVideoEncoderFactory.findCodecForType(standard);
            if (codec == null) continue;
            if (standard == RXVideoCodecStandard.ByteVC1 && HardwareVideoEncoderFactory.isSupportedCodec(codec, standard)) {
                supportedCodecInfos.add(new RXVideoCodecDesc(standard, RXVideoCodecProfile.ByteVC1ProfileMain));
            }
            if (standard == RXVideoCodecStandard.H264) {
                if (HardwareVideoEncoderFactory.isH264HighProfileSupported(codec)) {
                    supportedCodecInfos.add(new RXVideoCodecDesc(standard, RXVideoCodecProfile.ProfileHigh));
                }
                supportedCodecInfos.add(new RXVideoCodecDesc(standard, RXVideoCodecProfile.ProfileBaseline));
            }
            if (standard != RXVideoCodecStandard.VP8) continue;
            supportedCodecInfos.add(new RXVideoCodecDesc(standard, RXVideoCodecProfile.VP8ProfileMain));
        }
        return supportedCodecInfos.toArray(new RXVideoCodecDesc[supportedCodecInfos.size()]);
    }

    @CalledByNative
    public static boolean isTrustedCodec(RXVideoCodecDesc codecDesc) {
        return false;
    }

    @Nullable
    private static MediaCodecInfo findCodecForType(RXVideoCodecStandard type) {
        int count = 0;
        try {
            count = MediaCodecList.getCodecCount();
        }
        catch (Exception ex) {
            Log.e((String)TAG, (String)"Cannot getCodecCount", (Throwable)ex);
            return null;
        }
        for (int i = 0; i < count; ++i) {
            MediaCodecInfo info = null;
            try {
                info = MediaCodecList.getCodecInfoAt((int)i);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)TAG, (String)"Cannot retrieve encoder codec info", (Throwable)e);
            }
            if (info == null || !info.isEncoder() || !HardwareVideoEncoderFactory.isSupportedCodec(info, type)) continue;
            return info;
        }
        return null;
    }

    private static boolean isSupportedCodec(MediaCodecInfo info, RXVideoCodecStandard type) {
        if (!MediaCodecUtils.codecSupportsType(info, type)) {
            return false;
        }
        try {
            MediaCodecInfo.CodecCapabilities cap = info.getCapabilitiesForType(type.mimeType());
            if (MediaCodecUtils.selectColorFormat(MediaCodecUtils.ENCODER_COLOR_FORMATS, cap) == null) {
                return false;
            }
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        return HardwareVideoEncoderFactory.isHardwareSupportedInCurrentSdk(info, type);
    }

    private static boolean isHardwareSupportedInCurrentSdk(MediaCodecInfo info, RXVideoCodecStandard type) {
        switch (type) {
            case H264: {
                return HardwareVideoEncoderFactory.isHardwareSupportedInCurrentSdkH264(info);
            }
            case ByteVC1: {
                return HardwareVideoEncoderFactory.isHardwareSupportedInCurrentSdkByteVC1(info);
            }
            case VP8: {
                return HardwareVideoEncoderFactory.isHardwareSupportedInCurrentSdkVP8(info);
            }
        }
        return false;
    }

    private static boolean isHardwareSupportedInCurrentSdkH264(MediaCodecInfo info) {
        String name = info.getName();
        if (name.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (name.startsWith("OMX.Exynos.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private static boolean isHardwareSupportedInCurrentSdkByteVC1(MediaCodecInfo info) {
        String name = info.getName();
        if (name.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (name.startsWith("OMX.Exynos.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private static boolean isHardwareSupportedInCurrentSdkVP8(MediaCodecInfo info) {
        String name = info.getName();
        if (name.startsWith("OMX.qcom.")) {
            return Build.VERSION.SDK_INT >= 19;
        }
        if (name.startsWith("OMX.Exynos.")) {
            return Build.VERSION.SDK_INT >= 23;
        }
        if (name.startsWith("OMX.Intel.")) {
            return Build.VERSION.SDK_INT >= 21;
        }
        return Build.VERSION.SDK_INT >= 21;
    }

    private static int getKeyFrameIntervalSec(RXVideoCodecStandard type) {
        switch (type) {
            case VP8: 
            case VP9: {
                return 100;
            }
            case H264: {
                return 240;
            }
            case ByteVC1: {
                return 20;
            }
        }
        throw new IllegalArgumentException("Unsupported VideoCodecType " + (Object)((Object)type));
    }

    private static int getForcedKeyFrameIntervalMs(RXVideoCodecStandard type, String codecName) {
        if (type == RXVideoCodecStandard.VP8 && codecName.startsWith("OMX.qcom.")) {
            if (Build.VERSION.SDK_INT == 21 || Build.VERSION.SDK_INT == 22) {
                return 15000;
            }
            if (Build.VERSION.SDK_INT == 23) {
                return 20000;
            }
            if (Build.VERSION.SDK_INT > 23) {
                return 15000;
            }
        }
        return 0;
    }

    private static boolean isH264HighProfileSupported(MediaCodecInfo info) {
        if (RXDeviceInfo.GetCpuModel().contains("Amlogic")) {
            return false;
        }
        return Build.VERSION.SDK_INT > 23;
    }
}

