/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioAuxStream;
import com.bytedance.bae.ByteAudioSinkInterface;
import com.bytedance.bae.ByteAudioStreamBuffer;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.base.CalledByNative;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteAudioAuxSinkProxy {
    private ByteBuffer pullDirectBuffer;
    private ByteAudioStreamBuffer pullStreamBuffer = null;
    private long nativeSinkPtr = 0L;
    private ByteAudioSinkInterface.ByteAudioAuxSink sink = null;
    private ByteAudioAuxStream stream = null;

    public ByteAudioAuxSinkProxy(ByteAudioSinkInterface.ByteAudioAuxSink sink, ByteAudioAuxStream stream) {
        this.sink = sink;
        this.stream = stream;
        this.pullDirectBuffer = ByteBuffer.allocateDirect(15360);
        this.pullDirectBuffer.order(ByteOrder.nativeOrder());
        ByteAudioStreamFormat format = new ByteAudioStreamFormat(0, 0, 0, 0);
        this.pullStreamBuffer = new ByteAudioStreamBuffer(this.pullDirectBuffer, 0, format, 0);
    }

    public void releaseProxySink() {
        this.sink = null;
        this.stream = null;
        this.pullStreamBuffer = null;
    }

    public void setNativeSink(long nativeSinkPtr) {
        this.nativeSinkPtr = nativeSinkPtr;
    }

    @CalledByNative
    public int onPullAudioBufferToStream(long nativeStreamPtr) {
        int res = -1;
        if (this.sink != null) {
            this.pullDirectBuffer.clear();
            res = this.sink.onPullAudioBufferToAuxStream(this.stream, this.pullStreamBuffer);
            this.pullDirectBuffer.flip();
        }
        return res;
    }

    @CalledByNative
    public void onMixingBegin(long nativeStreamPtr) {
        if (this.sink != null) {
            this.sink.onMixingBegin(this.stream);
        }
    }

    @CalledByNative
    public void onMixingEnd(long nativeStreamPtr) {
        if (this.sink != null) {
            this.sink.onMixingEnd(this.stream);
        }
    }

    @CalledByNative
    public ByteBuffer getDirectBuffer() {
        return this.pullDirectBuffer;
    }

    @CalledByNative
    public ByteAudioStreamBuffer getStreamBuffer() {
        return this.pullStreamBuffer;
    }
}

