/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioAuxStream;
import com.bytedance.bae.ByteAudioEventHandler;
import com.bytedance.bae.ByteAudioEventHandlerProxy;
import com.bytedance.bae.ByteAudioFilterProxy;
import com.bytedance.bae.ByteAudioInputStream;
import com.bytedance.bae.ByteAudioModeStrategyTable;
import com.bytedance.bae.ByteAudioNativeFunctions;
import com.bytedance.bae.ByteAudioOutputStream;
import com.bytedance.bae.ByteAudioStreamBuffer;
import com.bytedance.bae.ByteAudioStreamOption;
import com.bytedance.bae.IByteAudioEngine;
import com.bytedance.bae.base.Utils;
import java.util.ArrayList;
import java.util.List;

public class ByteAudioEngine
extends IByteAudioEngine {
    private long nativeEnginePtr = 0L;
    private static Boolean sIsLibraryLoaded = false;
    private List<ByteAudioEventHandlerProxy> eventHandlerList = new ArrayList<ByteAudioEventHandlerProxy>();

    public static void setLibraryLoaded(boolean isLibraryLoaded) {
        sIsLibraryLoaded = isLibraryLoaded;
    }

    public ByteAudioEngine() {
        if (!sIsLibraryLoaded.booleanValue()) {
            String soName = "byteaudio";
            try {
                System.loadLibrary(soName);
                sIsLibraryLoaded = true;
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
        this.nativeEnginePtr = ByteAudioNativeFunctions.nativeGetInstance();
        if (this.nativeEnginePtr == 0L) {
            // empty if block
        }
    }

    public void release() {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeReleaseInstance();
        }
    }

    @Override
    public int setServerConfigure(String configure) {
        int res = -1;
        if (this.nativeEnginePtr != 0L) {
            res = ByteAudioNativeFunctions.nativeSetServerConfigure(this.nativeEnginePtr, configure);
        }
        return res;
    }

    @Override
    public void addEventHandler(ByteAudioEventHandler handler) {
        long nativeHandlePtr;
        for (ByteAudioEventHandlerProxy eventHandler : this.eventHandlerList) {
            if (!handler.equals(eventHandler)) continue;
            return;
        }
        ByteAudioEventHandlerProxy handProxy = new ByteAudioEventHandlerProxy(handler);
        if (this.nativeEnginePtr != 0L && (nativeHandlePtr = ByteAudioNativeFunctions.nativeAddEventHandler(this.nativeEnginePtr, handProxy)) != 0L) {
            handProxy.setNativeHandler(nativeHandlePtr);
            this.eventHandlerList.add(handProxy);
        }
    }

    @Override
    public void removeEventHandler(ByteAudioEventHandler handler) {
        if (this.nativeEnginePtr != 0L) {
            for (int i = 0; i < this.eventHandlerList.size(); ++i) {
                ByteAudioEventHandlerProxy handProxy = this.eventHandlerList.get(i);
                if (handProxy.handler != handler) continue;
                ByteAudioNativeFunctions.nativeRemoveEventHandler(this.nativeEnginePtr, handProxy.nativeHandlerPtr);
                this.eventHandlerList.remove(handProxy);
                handProxy.handler = null;
                handProxy.nativeHandlerPtr = 0L;
                handProxy = null;
                break;
            }
        }
    }

    @Override
    public ByteAudioInputStream createInputStream(String name) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioInputStream stream = new ByteAudioInputStream(this.nativeEnginePtr, name);
            return stream;
        }
        return null;
    }

    @Override
    public int releaseInputStream(ByteAudioInputStream inputStream) {
        inputStream.releaseStream();
        return -1;
    }

    @Override
    public ByteAudioOutputStream createOutputStream(String name) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioOutputStream stream = new ByteAudioOutputStream(this.nativeEnginePtr, name);
            return stream;
        }
        return null;
    }

    @Override
    public int releaseOutputStream(ByteAudioOutputStream outputStream) {
        outputStream.releaseStream();
        return -1;
    }

    @Override
    public ByteAudioAuxStream createAuxStream(String name) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioAuxStream stream = new ByteAudioAuxStream(this.nativeEnginePtr, name);
            return stream;
        }
        return null;
    }

    @Override
    public int releaseAuxStream(ByteAudioAuxStream auxStream) {
        auxStream.releaseStream();
        return -1;
    }

    @Override
    public int setDefaultAudioRoute(int routing) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeSetDefaultAudioRoute(this.nativeEnginePtr, routing);
        }
        return -1;
    }

    @Override
    public int addEnableAudioRouteReference() {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeAddEnableAudioRouteReference(this.nativeEnginePtr);
        }
        return -1;
    }

    @Override
    public int removeEnableAudioRouteReference() {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeRemoveEnableAudioRouteReference(this.nativeEnginePtr);
        }
        return -1;
    }

    @Override
    public int enableEarMonitor(boolean enabled) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeEnableEarMonitor(this.nativeEnginePtr, enabled);
        }
        return 0;
    }

    @Override
    public void setInputFilter(ByteAudioFilterProxy sink, int samplerate, int channel) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeSetInputFilter(this.nativeEnginePtr, sink, samplerate, channel);
        }
    }

    @Override
    public void setFrontInputFilter(ByteAudioFilterProxy sink, int samplerate, int channel) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeSetFrontInputFilter(this.nativeEnginePtr, sink, samplerate, channel);
        }
    }

    @Override
    public void setOutputFilter(ByteAudioFilterProxy sink, int samplerate, int channel) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeSetOutputFilter(this.nativeEnginePtr, sink, samplerate, channel);
        }
    }

    @Override
    public void setEarMonitorFilter(ByteAudioFilterProxy sink, int samplerate, int channel) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeSetEarMonitorFilter(this.nativeEnginePtr, sink, samplerate, channel);
        }
    }

    @Override
    public int stopPushExternalReferenceBuffer(int priority) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativeStopPushExternalReferenceBuffer(this.nativeEnginePtr, priority);
        }
        return -1;
    }

    @Override
    public int pushExternalReferenceBuffer(int trackId, ByteAudioStreamBuffer buffer, int priority) {
        if (this.nativeEnginePtr != 0L) {
            ByteAudioNativeFunctions.nativePushExternalReferenceBuffer(this.nativeEnginePtr, trackId, buffer, priority);
        }
        return -1;
    }

    @Override
    public int adjustHeadsetMonitorVolume(int volume) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeAdjustHeadsetMonitorVolume(this.nativeEnginePtr, volume);
        }
        return -1;
    }

    @Override
    public int setAudioModeStrategy(ByteAudioModeStrategyTable table) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeSetAudioModeStrategy(this.nativeEnginePtr, Utils.convertAudioModeStrategyTable(table));
        }
        return -1;
    }

    @Override
    public int adjustRecordVolume(int volume) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeAdjustRecordVolume(this.nativeEnginePtr, volume);
        }
        return -1;
    }

    @Override
    public int adjustPlaybackVolume(int volume) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeAdjustPlaybackVolume(this.nativeEnginePtr, volume);
        }
        return -1;
    }

    @Override
    public int setValue(int key, ByteAudioStreamOption value) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeSetValue(this.nativeEnginePtr, key, value);
        }
        return -1;
    }

    @Override
    public ByteAudioStreamOption getValue(int key) {
        if (this.nativeEnginePtr != 0L) {
            return ByteAudioNativeFunctions.nativeGetValue(this.nativeEnginePtr, key);
        }
        return null;
    }
}

