/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae;

import com.bytedance.bae.ByteAudioFilter;
import com.bytedance.bae.ByteAudioStreamBuffer;
import com.bytedance.bae.ByteAudioStreamFormat;
import com.bytedance.bae.base.CalledByNative;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteAudioFilterProxy {
    private ByteBuffer directBuffer;
    private ByteAudioStreamBuffer streamBuffer = null;
    private ByteAudioFilter sink = null;

    public ByteAudioFilterProxy(ByteAudioFilter sink) {
        this.sink = sink;
        this.directBuffer = ByteBuffer.allocateDirect(15360);
        this.directBuffer.order(ByteOrder.nativeOrder());
        ByteAudioStreamFormat format = new ByteAudioStreamFormat(0, 0, 0, 0);
        this.streamBuffer = new ByteAudioStreamBuffer(this.directBuffer, 0, format, 0);
    }

    @CalledByNative
    public int onProcess() {
        int res = -1;
        if (this.sink != null) {
            this.directBuffer.position(this.streamBuffer.getLength());
            this.directBuffer.flip();
            res = this.sink.onProcess(this.streamBuffer);
        }
        return res;
    }

    @CalledByNative
    public ByteBuffer getDirectBuffer() {
        return this.directBuffer;
    }

    @CalledByNative
    public ByteAudioStreamBuffer getStreamBuffer() {
        return this.streamBuffer;
    }
}

