/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.base;

import java.io.PrintWriter;
import java.io.StringWriter;

public class BaeLogging {
    private static volatile boolean loggingEnabled = true;
    private static Severity loggableSeverity;

    public static void enableLogThreads() {
        BaeLogging.nativeEnableLogThreads();
    }

    public static void enableLogTimeStamps() {
        BaeLogging.nativeEnableLogTimeStamps();
    }

    public static synchronized void enableLogToDebugOutput(Severity severity) {
        BaeLogging.nativeEnableLogToDebugOutput(severity.ordinal());
        loggingEnabled = true;
    }

    public static void log(Severity severity, String tag, String message) {
        if (tag == null || message == null) {
            throw new IllegalArgumentException("Logging tag or message may not be null.");
        }
        if (loggingEnabled) {
            BaeLogging.nativeLog(severity.ordinal(), tag, message);
            return;
        }
    }

    public static void d(String tag, String message) {
        BaeLogging.log(Severity.LS_DEBUG, tag, message);
    }

    public static void i(String tag, String message) {
        BaeLogging.log(Severity.LS_INFO, tag, message);
    }

    public static void e(String tag, String message) {
        BaeLogging.log(Severity.LS_ERROR, tag, message);
    }

    public static void w(String tag, String message) {
        BaeLogging.log(Severity.LS_WARNING, tag, message);
    }

    public static void e(String tag, String message, Throwable e) {
        BaeLogging.log(Severity.LS_ERROR, tag, message);
        BaeLogging.log(Severity.LS_ERROR, tag, e.toString());
        BaeLogging.log(Severity.LS_ERROR, tag, BaeLogging.getStackTraceString(e));
    }

    public static void w(String tag, String message, Throwable e) {
        BaeLogging.log(Severity.LS_WARNING, tag, message);
        BaeLogging.log(Severity.LS_WARNING, tag, e.toString());
        BaeLogging.log(Severity.LS_WARNING, tag, BaeLogging.getStackTraceString(e));
    }

    public static void t(String tag, String message) {
        BaeLogging.log(Severity.LS_TRACE, tag, message);
    }

    private static String getStackTraceString(Throwable e) {
        if (e == null) {
            return "";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private static native void nativeEnableLogToDebugOutput(int var0);

    private static native void nativeEnableLogThreads();

    private static native void nativeEnableLogTimeStamps();

    private static native void nativeLog(int var0, String var1, String var2);

    @Deprecated
    public static enum TraceLevel {
        TRACE_NONE(0),
        TRACE_STATEINFO(1),
        TRACE_WARNING(2),
        TRACE_ERROR(4),
        TRACE_CRITICAL(8),
        TRACE_APICALL(16),
        TRACE_DEFAULT(255),
        TRACE_MODULECALL(32),
        TRACE_MEMORY(256),
        TRACE_TIMER(512),
        TRACE_STREAM(1024),
        TRACE_DEBUG(2048),
        TRACE_INFO(4096),
        TRACE_TERSEINFO(8192),
        TRACE_ALL(65535);

        public final int level;

        private TraceLevel(int level) {
            this.level = level;
        }
    }

    public static enum Severity {
        LS_DEBUG,
        LS_TRACE,
        LS_INFO,
        LS_WARNING,
        LS_ERROR,
        LS_NONE;

    }
}

