/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.hwearback;

import android.media.AudioTrack;
import android.util.Log;

public class SlientPlayer {
    private static final String TAG = "SlientPlayer";
    private AudioTrack mTrack = null;
    private PlaybackThread mPlaybackThread;
    private int mSampleRate = 44100;
    private int mChannelConfig = 12;
    private int mAudioFormat = 2;
    private boolean mIsPlaying = false;
    private int mTrackBufSize = AudioTrack.getMinBufferSize((int)this.mSampleRate, (int)this.mChannelConfig, (int)this.mAudioFormat);

    public SlientPlayer() {
        Log.v((String)TAG, (String)("SlientPlayer: playBufSize = " + this.mTrackBufSize));
    }

    public boolean isPlaying() {
        return this.mIsPlaying;
    }

    public void play() {
        if (this.mIsPlaying) {
            return;
        }
        Log.v((String)TAG, (String)"play");
        if (this.mPlaybackThread == null) {
            this.mIsPlaying = true;
            this.mPlaybackThread = new PlaybackThread();
            this.mPlaybackThread.start();
        }
    }

    public void stop() {
        Log.v((String)TAG, (String)"stop");
        if (this.mPlaybackThread != null) {
            this.mIsPlaying = false;
            this.mPlaybackThread.closeThread();
            this.mPlaybackThread = null;
        }
    }

    class PlaybackThread
    extends Thread {
        private boolean isStop = false;

        PlaybackThread() {
        }

        public synchronized void closeThread() {
            try {
                this.notify();
                this.isStop = true;
                this.interrupt();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        @Override
        public void run() {
            AudioTrack track = new AudioTrack(3, SlientPlayer.this.mSampleRate, SlientPlayer.this.mChannelConfig, SlientPlayer.this.mAudioFormat, SlientPlayer.this.mTrackBufSize, 1);
            if (track != null) {
                track.play();
            }
            byte[] pcmdata = new byte[SlientPlayer.this.mTrackBufSize];
            for (int i = 0; i < pcmdata.length; ++i) {
                pcmdata[i] = 0;
            }
            while (!this.isStop && !this.isInterrupted() && track != null) {
                try {
                    if (track == null) continue;
                    track.write(pcmdata, 0, pcmdata.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    break;
                }
            }
            if (track != null) {
                track.stop();
                track.flush();
                track.release();
            }
            track = null;
        }
    }
}

