/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.hwearback;

import com.bytedance.bae.base.ContextUtils;
import com.bytedance.bae.hwearback.IHardWareEarback;
import com.bytedance.bae.hwearback.SlientPlayer;
import com.bytedance.bae.router.device.KaraokeMediaHelper;
import com.bytedance.bae.webrtc.WebRtcAudioEarBack;

public class XiaomEarback
implements IHardWareEarback {
    private KaraokeMediaHelper xiaomiKtvHelper;
    private SlientPlayer slientPlayer;
    private WebRtcAudioEarBack webRtcAudioEarBack;

    public XiaomEarback(WebRtcAudioEarBack earBack) {
        this.webRtcAudioEarBack = earBack;
    }

    @Override
    public int init() {
        this.xiaomiKtvHelper = new KaraokeMediaHelper(ContextUtils.getApplicationContext());
        this.slientPlayer = new SlientPlayer();
        if (this.xiaomiKtvHelper.isDeviceSupportKaraoke()) {
            this.xiaomiKtvHelper.openKTVDevice();
        }
        if (this.webRtcAudioEarBack != null) {
            this.webRtcAudioEarBack.onHardwareEarbackSupported(this.isSupport());
        }
        return 0;
    }

    @Override
    public int release() {
        if (this.xiaomiKtvHelper != null) {
            this.close();
            this.xiaomiKtvHelper.closeKTVDevice();
        }
        return 0;
    }

    @Override
    public boolean isSupport() {
        if (this.xiaomiKtvHelper != null) {
            return this.xiaomiKtvHelper.isDeviceSupportKaraoke() && this.xiaomiKtvHelper.isAppSupportKaraoke(ContextUtils.getApplicationContext().getPackageName());
        }
        return false;
    }

    @Override
    public int open() {
        if (this.xiaomiKtvHelper != null && this.slientPlayer != null) {
            this.slientPlayer.play();
            this.xiaomiKtvHelper.setPlayFeedbackParam(1);
            return 0;
        }
        return -1;
    }

    @Override
    public int close() {
        if (this.xiaomiKtvHelper != null && this.slientPlayer != null) {
            this.slientPlayer.stop();
            this.xiaomiKtvHelper.setPlayFeedbackParam(0);
            return 0;
        }
        return -1;
    }

    @Override
    public int setEffect(int value) {
        if (this.xiaomiKtvHelper != null) {
            this.xiaomiKtvHelper.setFeedbackEffect(value);
            return 0;
        }
        return -1;
    }

    @Override
    public int setEqualizer(int value) {
        return -1;
    }

    @Override
    public int setVolume(int volume) {
        if (this.xiaomiKtvHelper != null) {
            int kVol = (int)(15.0 * (double)volume / 100.0);
            this.xiaomiKtvHelper.setMicVolParam(kVol);
            return 0;
        }
        return -1;
    }
}

