/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.router;

import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.router.AudioRouteDeviceManager;
import com.bytedance.bae.router.IAudioRouteCallback;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class AudioRouteController
implements IAudioRouteCallback {
    private static final String TAG = "AudioRouteController";
    private AudioRouteDeviceManager mAudioRouteDeviceManager;
    @AudioRouteDeviceManager.RoutingDeviceType
    private int currentRouting = -1;
    private boolean isMediaMode = true;
    private long nativeAudioRouteControllerPtr;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private Lock rLock = this.lock.readLock();
    private Lock wLock = this.lock.writeLock();
    public static int EVENT_ONLY_LOG = 0;
    public static int EVENT_DISABLE_BLUETOOTH_HEADSET_WITH_WIRED_HEADSET_PLUGGED = 1;
    public static int EVENT_DISABLE_BLUETOOTH_HEADSET_WITH_USB_HEADSET_PLUGGED = 2;
    public static int EVENT_AUTO_CHANGE_ROUTE_MEDIA_MODE = 3;

    private AudioRouteController(long nativePtr) {
        this.nativeAudioRouteControllerPtr = nativePtr;
        this.mAudioRouteDeviceManager = new AudioRouteDeviceManager(this);
    }

    private int init() {
        this.rLock.lock();
        try {
            if (this.nativeAudioRouteControllerPtr == 0L) {
                int n = -1;
                return n;
            }
            int res = this.mAudioRouteDeviceManager.init();
            if (res != 0) {
                this.release();
                BaeLogging.e(TAG, "AudioRouteController: init failed. code: " + res);
                int n = -1;
                return n;
            }
            int n = this.mAudioRouteDeviceManager.getDeviceState();
            return n;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private int release() {
        this.wLock.lock();
        BaeLogging.i(TAG, "AudioRouteController: release begin");
        try {
            int ret = 0;
            this.nativeAudioRouteControllerPtr = 0L;
            if (this.mAudioRouteDeviceManager != null) {
                ret = this.mAudioRouteDeviceManager.release();
                this.mAudioRouteDeviceManager = null;
            }
            this.currentRouting = -1;
            this.isMediaMode = true;
            int n = ret;
            return n;
        }
        finally {
            BaeLogging.i(TAG, "AudioRouteController: release end");
            this.wLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int setAudioRoute(@AudioRouteDeviceManager.RoutingDeviceType int routing, boolean isMediaMode) {
        this.rLock.lock();
        BaeLogging.i(TAG, "AudioRouteController: setAudioRoute, begin, routing: " + routing + ", isMediaMode: " + isMediaMode);
        try {
            if (this.nativeAudioRouteControllerPtr == 0L) {
                int n = -5;
                return n;
            }
            this.isMediaMode = isMediaMode;
            int res = this.mAudioRouteDeviceManager.setAudioRoute(routing, isMediaMode);
            this.currentRouting = res == 0 ? routing : this.currentRouting;
            int n = res;
            return n;
        }
        finally {
            BaeLogging.i(TAG, "AudioRouteController: setAudioRoute, end, routing: " + routing + ", isMediaMode: " + isMediaMode);
            this.rLock.unlock();
        }
    }

    private String getRenderDeviceName() {
        this.rLock.lock();
        try {
            if (this.nativeAudioRouteControllerPtr == 0L) {
                String string = "nativePtr is 0";
                return string;
            }
            String string = this.mAudioRouteDeviceManager.getRenderDeviceName();
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private String getCaptureDeviceName() {
        this.rLock.lock();
        try {
            if (this.nativeAudioRouteControllerPtr == 0L) {
                String string = "nativePtr is 0";
                return string;
            }
            String string = this.mAudioRouteDeviceManager.getCaptureDeviceName();
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    private String getSessionInfo() {
        this.rLock.lock();
        try {
            if (this.nativeAudioRouteControllerPtr == 0L) {
                String string = "nativePtr is 0";
                return string;
            }
            String string = this.mAudioRouteDeviceManager.getSessionInfo();
            return string;
        }
        finally {
            this.rLock.unlock();
        }
    }

    @Override
    public void onDeviceEvent(int deviceType, boolean connected) {
        this.rLock.lock();
        try {
            if (this.nativeAudioRouteControllerPtr == 0L) {
                return;
            }
            BaeLogging.e(TAG, "AudioRouteController: onDeviceEvent(Java) deviceType:" + deviceType + ", connected:" + connected);
            this.onDeviceEvent(this.nativeAudioRouteControllerPtr, deviceType, connected);
        }
        finally {
            BaeLogging.i(TAG, "AudioRouteController: onDeviceEvent, end");
            this.rLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(int eventCode, String info) {
        this.rLock.lock();
        try {
            boolean flag;
            if (this.nativeAudioRouteControllerPtr == 0L) {
                return;
            }
            BaeLogging.e(TAG, "AudioRouteController: ERROR-" + eventCode + ":" + info);
            boolean bl = flag = eventCode == EVENT_DISABLE_BLUETOOTH_HEADSET_WITH_WIRED_HEADSET_PLUGGED || eventCode == EVENT_DISABLE_BLUETOOTH_HEADSET_WITH_USB_HEADSET_PLUGGED;
            if (flag) {
                this.onError(this.nativeAudioRouteControllerPtr, eventCode);
            }
        }
        finally {
            this.rLock.unlock();
        }
    }

    private native void onDeviceEvent(long var1, int var3, boolean var4);

    private native void onError(long var1, int var3);
}

