/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.router.device;

import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.ContextUtils;
import com.bytedance.bae.webrtc.WebRtcAudioEarBack;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKaraokeFeatureKit;
import com.huawei.multimedia.audiokit.interfaces.HwAudioKit;
import com.huawei.multimedia.audiokit.interfaces.IAudioKitCallback;

public class HWEarBackDeviceSupport
implements IAudioKitCallback {
    private static final String TAG = "HWEarBackDeviceSupport";
    private HwAudioKit mHwAudioKit;
    private HwAudioKaraokeFeatureKit mHwAudioKaraokeFeatureKit;
    private String mResultType = "";
    private boolean mIsAudiokitBindSuccess = false;
    private boolean mIsAudiokitKaraokeBindSuccess = false;
    private boolean mSupportLowLatencyEarBack = true;
    private WebRtcAudioEarBack earBack;

    public void onResult(int resultType) {
        this.printLog(String.format("onResult result=%d", resultType));
        switch (resultType) {
            case 2: {
                this.mIsAudiokitBindSuccess = false;
                this.mIsAudiokitKaraokeBindSuccess = false;
                this.onDeviceSupported(false);
                break;
            }
            case 1806: {
                this.onDeviceSupported(false);
                break;
            }
            case 4: 
            case 6: {
                this.mIsAudiokitBindSuccess = false;
                break;
            }
            case 1001: 
            case 1003: {
                this.mIsAudiokitKaraokeBindSuccess = false;
                break;
            }
            case 0: {
                this.initKaraokeFeature();
                this.mIsAudiokitBindSuccess = true;
                break;
            }
            case 1000: {
                this.mIsAudiokitKaraokeBindSuccess = true;
                this.setVolume(90);
                this.onDeviceSupported(this.HWGetKaraokeSupport());
                break;
            }
        }
    }

    public HWEarBackDeviceSupport(WebRtcAudioEarBack webRtcAudioEarBack) {
        this.earBack = webRtcAudioEarBack;
    }

    private void initAudioKit() {
        this.mHwAudioKit = new HwAudioKit(ContextUtils.getApplicationContext(), (IAudioKitCallback)this);
        this.mHwAudioKit.initialize();
    }

    private void initKaraokeFeature() {
        if (this.mHwAudioKit != null) {
            this.mHwAudioKaraokeFeatureKit = (HwAudioKaraokeFeatureKit)this.mHwAudioKit.createFeature(HwAudioKit.FeatureType.HWAUDIO_FEATURE_KARAOKE);
        }
    }

    public void HWEarBack_init() {
        this.printLog("HWEarBack_init");
        this.initAudioKit();
    }

    public void HWDestroy() {
        if (this.mIsAudiokitBindSuccess && this.mHwAudioKit != null) {
            this.printLog("HWDestroy");
            if (this.mHwAudioKaraokeFeatureKit != null) {
                this.mHwAudioKaraokeFeatureKit.destroy();
                this.mIsAudiokitKaraokeBindSuccess = false;
            }
            this.mHwAudioKit.destroy();
            this.mIsAudiokitBindSuccess = false;
        }
    }

    public int HWEnableKaraoke(boolean enable) {
        int enableSuccess = -1;
        if (this.mHwAudioKaraokeFeatureKit != null && this.mIsAudiokitKaraokeBindSuccess) {
            this.printLog("HWEnableKaraoke enable=" + enable);
            enableSuccess = this.mHwAudioKaraokeFeatureKit.enableKaraokeFeature(enable);
        }
        return enableSuccess;
    }

    public boolean HWGetKaraokeSupport() {
        boolean isSupport = false;
        if (this.mHwAudioKaraokeFeatureKit != null && this.mIsAudiokitKaraokeBindSuccess) {
            isSupport = this.mHwAudioKaraokeFeatureKit.isKaraokeFeatureSupport();
        }
        return isSupport;
    }

    public int HWSetEffectMode(int value) {
        int success = -1;
        if (this.mHwAudioKaraokeFeatureKit != null && this.mIsAudiokitKaraokeBindSuccess) {
            this.printLog("HWSetEffectMode value=" + value);
            success = this.mHwAudioKaraokeFeatureKit.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_AUDIO_EFFECT_MODE_BASE, value);
        }
        return success;
    }

    public int HWSetEqualizerMode(int value) {
        int success = -1;
        if (this.mHwAudioKaraokeFeatureKit != null && this.mIsAudiokitKaraokeBindSuccess) {
            this.printLog("HWSetEqualizerMode value=" + value);
            success = this.mHwAudioKaraokeFeatureKit.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_EQUALIZER_MODE, value);
        }
        return success;
    }

    public int setVolume(int value) {
        int success = -1;
        if (this.mHwAudioKaraokeFeatureKit != null && this.mIsAudiokitKaraokeBindSuccess) {
            this.printLog("setVolume volome=" + value);
            success = this.mHwAudioKaraokeFeatureKit.setParameter(HwAudioKaraokeFeatureKit.ParameName.CMD_SET_VOCAL_VOLUME_BASE, value);
        }
        return success;
    }

    public void onDeviceSupported(boolean isSupported) {
        if (this.earBack != null) {
            this.earBack.onHardwareEarbackSupported(isSupported);
        }
    }

    private void printLog(String message) {
        BaeLogging.i(TAG, "HWEarBackDeviceSupport:" + message);
    }
}

