/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.router.device;

import android.content.Context;
import android.media.AudioManager;
import android.os.Build;
import android.util.Log;
import java.util.StringTokenizer;

public class VivoKTVHelper {
    private static final String TAG = "VivoKTVHelper";
    private static final String KEY_KTV_MODE = "vivo_ktv_mode";
    private static final String KEY_VOL_MIC = "vivo_ktv_volume_mic";
    private static final String KEY_MIC_SRC = "vivo_ktv_rec_source";
    private static final String KEY_MIC_TYPE = "vivo_ktv_mic_type";
    private static final String KEY_PRESET = "vivo_ktv_preset_effect";
    private static final String KEY_PLAY_SRC = "vivo_ktv_play_source";
    private static final String KEY_EXT_SPKR = "vivo_ktv_ext_speaker";
    private static final String TAG_RB_ROOMSIZE = "vivo_ktv_rb_roomsize";
    private static final String TAG_RB_DAMP = "vivo_ktv_rb_damp";
    private static final String TAG_RB_WET = "vivo_ktv_rb_wet";
    private static final String TAG_RB_DRY = "vivo_ktv_rb_dry";
    private static final String TAG_RB_WIDTH = "vivo_ktv_rb_width";
    private static final String TAG_RB_GAIN = "vivo_ktv_rb_gain";
    private static final String TAG_MEQ_BAND_1 = "vivo_ktv_miceq_band1";
    private static final String TAG_MEQ_BAND_2 = "vivo_ktv_miceq_band2";
    private static final String TAG_MEQ_BAND_3 = "vivo_ktv_miceq_band3";
    private static final String TAG_MEQ_BAND_4 = "vivo_ktv_miceq_band4";
    private static final String TAG_MEQ_BAND_5 = "vivo_ktv_miceq_band5";
    private static final String TAG_ECHO_ENABLE = "vivo_ktv_echo_enable";
    private static final String TAG_ECHO_GAIN = "vivo_ktv_echo_feedback";
    private static final String TAG_ECHO_DELAY = "vivo_ktv_echo_delay";
    private static final String TAG_ECHO_WET = "vivo_ktv_echo_wet";
    private static final String TAG_ECHO_DRY = "vivo_ktv_echo_dry";
    private static final String TAG_REVERB = "vivo_ktv_reverb_preset";
    private final Object mParamLock = new Object();
    private AudioManager mAudioManager;
    private Context mContext;
    private static VivoKTVHelper mVivoKTVHelper;
    public static final int MODE_CUSTOM_RECSTUDIO = 0;
    public static final int MODE_CUSTOM_KTV = 1;
    public static final int MODE_CUSTOM_WARM = 2;
    public static final int MODE_CUSTOM_ATTRACTIVE = 3;
    public static final int MODE_CUSTOM_AIRY = 4;
    public static final int MODE_CUSTOM_DISTANT = 5;
    public static final int MODE_CUSTOM_3DDRAEMY = 6;
    public static final int MODE_CUSTOM_GRAMOPHONE = 7;
    public static final int MODE_CUSTOM_NOEFFECT = 8;
    private static final int[][] ReverbCustomParams;
    private static final int effect_size;
    private static final int[][] EQCustomGain;
    private static final int[][] EchoCustomParams;

    public VivoKTVHelper(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
    }

    public static VivoKTVHelper getInstance(Context context) {
        if (mVivoKTVHelper == null) {
            mVivoKTVHelper = new VivoKTVHelper(context);
        }
        return mVivoKTVHelper;
    }

    public boolean isDeviceSupportKaraoke() {
        String build = Build.MANUFACTURER;
        if (build.trim().contains("vivo")) {
            String value;
            int state;
            String result = this.mAudioManager.getParameters(KEY_MIC_TYPE);
            StringTokenizer st = new StringTokenizer(result, "=");
            int tokens = st.countTokens();
            if (tokens != 2) {
                return false;
            }
            String tag = st.nextToken();
            if (tag.equals(KEY_MIC_TYPE) && ((state = Integer.parseInt(value = st.nextToken())) == 1 || state == 0)) {
                return true;
            }
        }
        return false;
    }

    public void openKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=1");
    }

    public void closeKTVDevice() {
        this.mAudioManager.setParameters("vivo_ktv_mode=0");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMicVolParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append(KEY_VOL_MIC).append("=").append(param);
                this.mAudioManager.setParameters(sBuilder.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVoiceOutParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_rec_source=" + param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlayFeedbackParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                this.mAudioManager.setParameters("vivo_ktv_play_source=" + param);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExtSpeakerParam(int param) {
        Object object = this.mParamLock;
        synchronized (object) {
            if (null != this.mAudioManager) {
                StringBuilder sBuilder = new StringBuilder();
                sBuilder.append(KEY_EXT_SPKR).append("=").append(param);
                this.mAudioManager.setParameters(sBuilder.toString());
            }
        }
    }

    public int getExtSpeakerParam() {
        return this.getKTVParam(KEY_EXT_SPKR);
    }

    public int getPlayFeedbackParam() {
        return this.getKTVParam(KEY_PLAY_SRC);
    }

    public int getPreModeParam() {
        return this.getKTVParam(KEY_PRESET);
    }

    public int getMicTypeParam() {
        return this.getKTVParam(KEY_MIC_TYPE);
    }

    public int getVoiceOutParam() {
        return this.getKTVParam(KEY_MIC_SRC);
    }

    public int getMicVolParam() {
        return this.getKTVParam(KEY_VOL_MIC);
    }

    public int getEffectSize() {
        return effect_size;
    }

    private int getKTVParam(String tag) {
        String build = Build.MANUFACTURER;
        if (build.trim().contains("vivo")) {
            String result = this.mAudioManager.getParameters(tag);
            Log.v((String)TAG, (String)("getKTVParam: " + result));
            StringTokenizer st = new StringTokenizer(result, "=");
            int tokens = st.countTokens();
            if (tokens != 2) {
                Log.e((String)TAG, (String)("getKTVParam: malformated string " + result));
            } else {
                String tagret = st.nextToken();
                if (tag.equals(tagret)) {
                    String value = st.nextToken();
                    return Integer.parseInt(value.trim());
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCustomMode(int mode) {
        Log.v((String)TAG, (String)("setCustomMode: " + mode));
        Object object = this.mParamLock;
        synchronized (object) {
            this.setExtSpeakerParam(0);
            this.setGramophoneParams(mode);
            this.setReverbParams(mode);
            this.setEQParams(mode);
            this.setEchoParams(mode);
        }
    }

    private void setReverbParams(int mode) {
        this.mAudioManager.setParameters("vivo_ktv_rb_roomsize=" + ReverbCustomParams[mode][0]);
        this.mAudioManager.setParameters("vivo_ktv_rb_damp=" + ReverbCustomParams[mode][1]);
        this.mAudioManager.setParameters("vivo_ktv_rb_wet=" + ReverbCustomParams[mode][2]);
        this.mAudioManager.setParameters("vivo_ktv_rb_dry=" + ReverbCustomParams[mode][3]);
        this.mAudioManager.setParameters("vivo_ktv_rb_width=" + ReverbCustomParams[mode][4]);
        this.mAudioManager.setParameters("vivo_ktv_rb_gain=" + ReverbCustomParams[mode][5]);
        this.mAudioManager.setParameters("vivo_ktv_echo_enable=0");
    }

    private void setEQParams(int mode) {
        this.mAudioManager.setParameters("vivo_ktv_miceq_band1=" + (EQCustomGain[mode][0] + 8));
        this.mAudioManager.setParameters("vivo_ktv_miceq_band2=" + (EQCustomGain[mode][1] + 8));
        this.mAudioManager.setParameters("vivo_ktv_miceq_band3=" + (EQCustomGain[mode][2] + 8));
        this.mAudioManager.setParameters("vivo_ktv_miceq_band4=" + (EQCustomGain[mode][3] + 8));
        this.mAudioManager.setParameters("vivo_ktv_miceq_band5=" + (EQCustomGain[mode][4] + 8));
    }

    private void setEchoParams(int mode) {
        if (mode == 4) {
            this.mAudioManager.setParameters("vivo_ktv_echo_enable=1");
            this.mAudioManager.setParameters("vivo_ktv_echo_feedback=" + EchoCustomParams[0][0]);
            this.mAudioManager.setParameters("vivo_ktv_echo_delay=" + EchoCustomParams[0][1]);
            this.mAudioManager.setParameters("vivo_ktv_echo_wet=" + EchoCustomParams[0][2]);
            this.mAudioManager.setParameters("vivo_ktv_echo_dry=" + EchoCustomParams[0][3]);
        }
    }

    private void setGramophoneParams(int mode) {
        if (mode == 7) {
            this.mAudioManager.setParameters("vivo_ktv_reverb_preset=4");
        } else {
            this.mAudioManager.setParameters("vivo_ktv_reverb_preset=0");
        }
    }

    static {
        ReverbCustomParams = new int[][]{{200, 1000, 500, 4500, 1000, 1500}, {5000, 4500, 1200, 4500, 6500, 1200}, {4500, 8000, 1000, 4000, 6500, 1500}, {2500, 3000, 1500, 4000, 5000, 1500}, {3500, 5500, 1500, 5000, 5500, 1500}, {4000, 3000, 1000, 2500, 5500, 1200}, {500, 5000, 800, 4500, 3000, 1200}, {20, 500, 60, 4500, 5000, 1500}, {0, 0, 0, 4000, 0, 1200}};
        effect_size = ReverbCustomParams.length;
        EQCustomGain = new int[][]{{0, 0, 0, 2, 2}, {0, 0, 0, 0, 0}, {3, 4, 2, 0, -3}, {3, 2, 0, 0, 2}, {3, 2, 0, -1, -3}, {2, 2, 2, 0, 0}, {5, 2, -2, 1, 3}, {-2, 0, 1, 2, 1}, {0, 0, 0, 0, 0}};
        EchoCustomParams = new int[][]{{3200, 150, 1500, 2000}};
    }
}

