/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.bae.webrtc;

import android.media.AudioRecord;
import android.os.Build;
import android.os.Process;
import android.support.annotation.Nullable;
import com.bytedance.bae.base.BaeLogging;
import com.bytedance.bae.base.ThreadUtils;
import com.bytedance.bae.webrtc.WebRtcAudioEffects;
import com.bytedance.bae.webrtc.WebRtcAudioUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class WebRtcAudioRecord {
    private static final boolean DEBUG = false;
    private static final String TAG = "WebRtcAudioRecord";
    private static final int BITS_PER_SAMPLE = 16;
    private static final int CALLBACK_BUFFER_SIZE_MS = 10;
    private static final int BUFFERS_PER_SECOND = 100;
    private static final int BUFFER_SIZE_FACTOR = 2;
    private static final long AUDIO_RECORD_THREAD_JOIN_TIMEOUT_MS = 2000L;
    private static final int DEFAULT_AUDIO_SOURCE;
    private static final int INVALID_AUDIO_SOURCE = -1;
    private static final int INVALID_AUDIO_SESSION_ID = -1;
    private static int defaultMediaModeAudioSource;
    private final long nativeAudioRecord;
    private WebRtcAudioEffects effects;
    private ByteBuffer byteBuffer;
    private AudioRecord audioRecord;
    private AudioRecordThread audioThread;
    private static volatile boolean microphoneMute;
    private byte[] emptyBytes;
    private String apiResult = "";
    @Nullable
    private static WebRtcAudioRecordErrorCallback errorCallback;
    @Nullable
    private static WebRtcAudioRecordSamplesReadyCallback audioSamplesReadyCallback;

    public static void setErrorCallback(WebRtcAudioRecordErrorCallback errorCallback) {
        BaeLogging.i(TAG, "Set error callback");
        WebRtcAudioRecord.errorCallback = errorCallback;
    }

    public static void setOnAudioSamplesReady(WebRtcAudioRecordSamplesReadyCallback callback) {
        audioSamplesReadyCallback = callback;
    }

    WebRtcAudioRecord(long nativeAudioRecord) {
        BaeLogging.i(TAG, "ctor" + WebRtcAudioUtils.getThreadInfo());
        this.nativeAudioRecord = nativeAudioRecord;
        if (WebRtcAudioEffects.IsAudioEffectSupported()) {
            this.effects = WebRtcAudioEffects.create();
        }
    }

    private boolean enableBuiltInAEC(boolean enable) {
        BaeLogging.i(TAG, "enableBuiltInAEC(" + enable + ')');
        if (this.effects == null) {
            BaeLogging.e(TAG, "Built-in AEC is not supported on this platform");
            return false;
        }
        return this.effects.setAEC(enable);
    }

    private boolean enableBuiltInNS(boolean enable) {
        BaeLogging.i(TAG, "enableBuiltInNS(" + enable + ')');
        if (this.effects == null) {
            BaeLogging.e(TAG, "Built-in NS is not supported on this platform");
            return false;
        }
        return this.effects.setNS(enable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initRecording(int sampleRate, int channels, boolean forbidVoip, int mediaModeAudioSource) {
        this.apiResult = "InitRecording(sampleRate=" + sampleRate + ", channels=" + channels + ", forbidVoip=" + forbidVoip + ", preferredMediaModeSource=" + mediaModeAudioSource + "):";
        BaeLogging.w(TAG, this.apiResult);
        if (this.audioRecord != null) {
            this.reportWebRtcAudioRecordInitError("InitRecording called twice without StopRecording.");
            return -1;
        }
        int bytesPerFrame = channels * 2;
        int framesPerBuffer = sampleRate / 100;
        this.byteBuffer = ByteBuffer.allocateDirect(bytesPerFrame * framesPerBuffer);
        BaeLogging.i(TAG, "byteBuffer.capacity: " + this.byteBuffer.capacity());
        this.emptyBytes = new byte[this.byteBuffer.capacity()];
        this.nativeCacheDirectBufferAddress(this.byteBuffer, this.nativeAudioRecord);
        int channelConfig = this.channelCountToConfiguration(channels);
        int minBufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)2);
        if (minBufferSize == -1 || minBufferSize == -2) {
            this.reportWebRtcAudioRecordInitError("AudioRecord.getMinBufferSize failed: " + minBufferSize);
            this.apiResult = this.apiResult + "AudioRecord.getMinBufferSize failed: " + minBufferSize;
            return -1;
        }
        BaeLogging.i(TAG, "AudioRecord.getMinBufferSize: " + minBufferSize);
        int bufferSizeInBytes = Math.max(2 * minBufferSize, this.byteBuffer.capacity());
        BaeLogging.i(TAG, "bufferSizeInBytes: " + bufferSizeInBytes);
        try {
            WebRtcAudioRecord webRtcAudioRecord = this;
            synchronized (webRtcAudioRecord) {
                int mediaAudioSource = defaultMediaModeAudioSource;
                if (mediaModeAudioSource == 1) {
                    mediaAudioSource = 6;
                }
                this.apiResult = this.apiResult + ",AudioSource:" + (forbidVoip ? mediaAudioSource : 7) + ",MinBufferSize:" + minBufferSize + ",byteBuffer.capcity:" + this.byteBuffer.capacity() + ", bufferSizeInBytes:" + bufferSizeInBytes;
                this.audioRecord = new AudioRecord(forbidVoip ? mediaAudioSource : 7, sampleRate, channelConfig, 2, bufferSizeInBytes);
            }
        }
        catch (IllegalArgumentException e) {
            this.reportWebRtcAudioRecordInitError("AudioRecord ctor error: " + e.getMessage());
            this.releaseAudioResources();
            this.apiResult = this.apiResult + "AudioRecord ctor error: " + e.getMessage();
            return -1;
        }
        if (this.audioRecord == null || this.audioRecord.getState() != 1) {
            this.reportWebRtcAudioRecordInitError("Failed to create a new AudioRecord instance");
            this.releaseAudioResources();
            this.apiResult = this.apiResult + "Failed to create a new AudioRecord instance state:" + (this.audioRecord == null ? "null" : Integer.valueOf(this.audioRecord.getState()));
            return -1;
        }
        if (this.effects != null) {
            this.effects.enable(this.audioRecord.getAudioSessionId());
        }
        this.logMainParameters();
        this.logMainParametersExtended();
        return framesPerBuffer;
    }

    private boolean startRecording() {
        this.apiResult = "StartRecording:";
        BaeLogging.i(TAG, this.apiResult);
        if (this.audioRecord == null) {
            BaeLogging.e(TAG, "null audio record object");
            return false;
        }
        if (this.audioThread != null) {
            BaeLogging.e(TAG, "the previous audio thread leak");
            return false;
        }
        try {
            this.audioRecord.startRecording();
        }
        catch (IllegalStateException e) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_EXCEPTION, "AudioRecord.startRecording failed: " + e.getMessage());
            this.apiResult = this.apiResult + "AudioRecord.startRecording failed: " + e.getMessage();
            this.releaseAudioResources();
            return false;
        }
        if (this.audioRecord.getRecordingState() != 3) {
            this.reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode.AUDIO_RECORD_START_STATE_MISMATCH, "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState());
            this.apiResult = this.apiResult + "AudioRecord.startRecording failed - incorrect state :" + this.audioRecord.getRecordingState();
            if (this.effects != null) {
                this.effects.release();
            }
            this.releaseAudioResources();
            return false;
        }
        this.audioThread = new AudioRecordThread("BaeRecordJavaThread");
        this.audioThread.start();
        return true;
    }

    private boolean stopRecording() {
        this.apiResult = "StopRecording:";
        BaeLogging.i(TAG, this.apiResult);
        if (this.audioThread != null) {
            this.audioThread.stopThread();
            if (!ThreadUtils.joinUninterruptibly(this.audioThread, 2000L)) {
                BaeLogging.e(TAG, "Join of AudioRecordJavaThread timed out");
                WebRtcAudioUtils.logAudioState(TAG);
                this.apiResult = this.apiResult + "Join of AudioRecordJavaThread timed out";
            }
            this.audioThread = null;
        }
        if (this.effects != null) {
            this.effects.release();
        }
        this.releaseAudioResources();
        BaeLogging.i(TAG, "stopRecording release done.");
        return true;
    }

    private String getApiResult() {
        return this.apiResult;
    }

    private int getAudioSource() {
        if (null == this.audioRecord) {
            return -1;
        }
        return this.audioRecord.getAudioSource();
    }

    private int getAudioSessionId() {
        if (null == this.audioRecord) {
            return -1;
        }
        return this.audioRecord.getAudioSessionId();
    }

    private void logMainParameters() {
        BaeLogging.w(TAG, "AudioRecord: session ID: " + this.audioRecord.getAudioSessionId() + ", channels: " + this.audioRecord.getChannelCount() + ", sample rate: " + this.audioRecord.getSampleRate() + ", source:" + this.audioRecord.getAudioSource());
    }

    private void logMainParametersExtended() {
        if (Build.VERSION.SDK_INT >= 23) {
            BaeLogging.w(TAG, "AudioRecord: buffer size in frames: " + this.audioRecord.getBufferSizeInFrames());
        }
    }

    private static void assertTrue(boolean condition) {
        if (!condition) {
            throw new AssertionError((Object)"Expected condition to be true");
        }
    }

    private int channelCountToConfiguration(int channels) {
        return channels == 1 ? 16 : 12;
    }

    private native void nativeCacheDirectBufferAddress(ByteBuffer var1, long var2);

    private native void nativeDataIsRecorded(int var1, long var2);

    private static int getDefaultAudioSource() {
        return 0;
    }

    public static void setMicrophoneMute(boolean mute) {
        BaeLogging.w(TAG, "setMicrophoneMute(" + mute + ")");
        microphoneMute = mute;
    }

    private void releaseAudioResources() {
        BaeLogging.i(TAG, "releaseAudioResources");
        if (this.audioRecord != null) {
            this.audioRecord.release();
            this.audioRecord = null;
        }
    }

    private void reportWebRtcAudioRecordInitError(String errorMessage) {
        BaeLogging.e(TAG, "Init recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordInitError(errorMessage);
        }
    }

    private void reportWebRtcAudioRecordStartError(AudioRecordStartErrorCode errorCode, String errorMessage) {
        BaeLogging.e(TAG, "Start recording error: " + (Object)((Object)errorCode) + ". " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordStartError(errorCode, errorMessage);
        }
    }

    private void reportWebRtcAudioRecordError(String errorMessage) {
        BaeLogging.e(TAG, "Run-time recording error: " + errorMessage);
        WebRtcAudioUtils.logAudioState(TAG);
        if (errorCallback != null) {
            errorCallback.onWebRtcAudioRecordError(errorMessage);
        }
    }

    static {
        defaultMediaModeAudioSource = DEFAULT_AUDIO_SOURCE = WebRtcAudioRecord.getDefaultAudioSource();
    }

    private class AudioRecordThread
    extends Thread {
        private volatile boolean keepAlive;

        public AudioRecordThread(String name) {
            super(name);
            this.keepAlive = true;
        }

        @Override
        public void run() {
            Process.setThreadPriority((int)-19);
            BaeLogging.i(WebRtcAudioRecord.TAG, "AudioRecordThread" + WebRtcAudioUtils.getThreadInfo());
            if (WebRtcAudioRecord.this.audioRecord == null || WebRtcAudioRecord.this.audioRecord.getRecordingState() != 3) {
                String errorMessage = "AudioRecord.run failed: incorrect state :" + (WebRtcAudioRecord.this.audioRecord == null ? "null" : Integer.valueOf(WebRtcAudioRecord.this.audioRecord.getRecordingState()));
                BaeLogging.e(WebRtcAudioRecord.TAG, errorMessage);
                this.keepAlive = false;
                WebRtcAudioRecord.this.reportWebRtcAudioRecordError(errorMessage);
            }
            long lastTime = System.nanoTime();
            while (this.keepAlive) {
                int bytesRead = WebRtcAudioRecord.this.audioRecord.read(WebRtcAudioRecord.this.byteBuffer, WebRtcAudioRecord.this.byteBuffer.capacity());
                if (bytesRead == WebRtcAudioRecord.this.byteBuffer.capacity()) {
                    if (microphoneMute) {
                        WebRtcAudioRecord.this.byteBuffer.clear();
                        WebRtcAudioRecord.this.byteBuffer.put(WebRtcAudioRecord.this.emptyBytes);
                    }
                    if (this.keepAlive) {
                        WebRtcAudioRecord.this.nativeDataIsRecorded(bytesRead, WebRtcAudioRecord.this.nativeAudioRecord);
                    }
                    if (audioSamplesReadyCallback == null) continue;
                    byte[] data = Arrays.copyOf(WebRtcAudioRecord.this.byteBuffer.array(), WebRtcAudioRecord.this.byteBuffer.capacity());
                    audioSamplesReadyCallback.onWebRtcAudioRecordSamplesReady(new AudioSamples(WebRtcAudioRecord.this.audioRecord, data));
                    continue;
                }
                if (bytesRead != -3 && bytesRead != -6) continue;
                this.keepAlive = false;
                String errorMessage = "AudioRecord.read failed: " + bytesRead;
                BaeLogging.e(WebRtcAudioRecord.TAG, errorMessage);
                WebRtcAudioRecord.this.reportWebRtcAudioRecordError(errorMessage);
            }
            try {
                if (WebRtcAudioRecord.this.audioRecord != null) {
                    WebRtcAudioRecord.this.audioRecord.stop();
                }
            }
            catch (Exception e) {
                BaeLogging.e(WebRtcAudioRecord.TAG, "AudioRecord.stop failed: " + e.getMessage());
            }
        }

        public void stopThread() {
            BaeLogging.i(WebRtcAudioRecord.TAG, "stopThread");
            this.keepAlive = false;
        }
    }

    public static interface WebRtcAudioRecordSamplesReadyCallback {
        public void onWebRtcAudioRecordSamplesReady(AudioSamples var1);
    }

    public static class AudioSamples {
        private final int audioFormat;
        private final int channelCount;
        private final int sampleRate;
        private final byte[] data;

        private AudioSamples(AudioRecord audioRecord, byte[] data) {
            this.audioFormat = audioRecord.getAudioFormat();
            this.channelCount = audioRecord.getChannelCount();
            this.sampleRate = audioRecord.getSampleRate();
            this.data = data;
        }

        public int getAudioFormat() {
            return this.audioFormat;
        }

        public int getChannelCount() {
            return this.channelCount;
        }

        public int getSampleRate() {
            return this.sampleRate;
        }

        public byte[] getData() {
            return this.data;
        }
    }

    public static interface WebRtcAudioRecordErrorCallback {
        public void onWebRtcAudioRecordInitError(String var1);

        public void onWebRtcAudioRecordStartError(AudioRecordStartErrorCode var1, String var2);

        public void onWebRtcAudioRecordError(String var1);
    }

    public static enum AudioRecordStartErrorCode {
        AUDIO_RECORD_START_EXCEPTION,
        AUDIO_RECORD_START_STATE_MISMATCH;

    }
}

