/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx.video.memory.bridge;

import android.opengl.EGLContext;
import android.os.Build;
import com.bytedance.realx.base.CalledByNative;
import com.bytedance.realx.video.RXPixelFormat;
import com.bytedance.realx.video.RXVideoMemoryType;
import com.bytedance.realx.video.RXVideoRotation;
import com.bytedance.realx.video.RXVideoScaleFilter;
import com.bytedance.realx.video.memory.RXVideoTextureMemory;
import org.webrtc.FilterType;
import org.webrtc.VideoFrame;

public class WebrtcTextureVideoMemory
extends RXVideoTextureMemory {
    private VideoFrame.TextureBuffer textureBuffer;
    EGLContext eglContext;
    RXVideoRotation rotation;

    @CalledByNative
    public WebrtcTextureVideoMemory(VideoFrame.TextureBuffer textureBuffer, EGLContext eglContext, RXVideoRotation rotation) {
        this.textureBuffer = textureBuffer;
        this.eglContext = eglContext;
        this.rotation = rotation;
        if (this.textureBuffer != null) {
            textureBuffer.retain();
        }
        this.setReleaseCallback(() -> {
            if (this.textureBuffer != null) {
                this.textureBuffer.release();
            }
        });
    }

    @Override
    public int getWidth() {
        if (this.textureBuffer == null) {
            return 0;
        }
        return this.textureBuffer.getWidth();
    }

    @Override
    public int getHeight() {
        if (this.textureBuffer == null) {
            return 0;
        }
        return this.textureBuffer.getHeight();
    }

    @Override
    public RXVideoRotation getRotation() {
        if (this.textureBuffer == null) {
            return RXVideoRotation.VIDEO_ROTATION_0;
        }
        return this.rotation;
    }

    @Override
    public RXVideoMemoryType getMemoryType() {
        return RXVideoMemoryType.kOPENGL_TEXTURE;
    }

    @Override
    public int getTextureId() {
        if (this.textureBuffer == null) {
            return 0;
        }
        return this.textureBuffer.getTextureId();
    }

    @Override
    public float[] getTextureMatrix() {
        if (this.textureBuffer == null) {
            return null;
        }
        return this.textureBuffer.nativeGetTransFormMatrix();
    }

    @Override
    public RXPixelFormat getTextureTarget() {
        if (this.textureBuffer == null) {
            return null;
        }
        return RXPixelFormat.fromId(this.textureBuffer.getTypeGlTarget());
    }

    @Override
    public long getNativeEGLContext() {
        if (this.eglContext == null) {
            return 0L;
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return this.eglContext.getNativeHandle();
        }
        return this.eglContext.getHandle();
    }

    @Override
    public EGLContext getEGLContext() {
        return this.eglContext;
    }

    @Override
    public RXVideoScaleFilter getScaleFilter() {
        FilterType filterType = this.textureBuffer.getScaleFilter();
        if (filterType == null) {
            return RXVideoScaleFilter.kOpenGLOrigin;
        }
        RXVideoScaleFilter scaleFilter = RXVideoScaleFilter.fromId(filterType.toInt());
        return scaleFilter;
    }

    @Override
    public int getUnScaledWidth() {
        if (this.textureBuffer == null) {
            return 0;
        }
        return this.textureBuffer.getUnscaledWidth();
    }

    @Override
    public int getUnScaledHeight() {
        if (this.textureBuffer == null) {
            return 0;
        }
        return this.textureBuffer.getUnscaledHeight();
    }
}

