/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.realx.video.memory.helper;

import android.opengl.EGL14;
import android.opengl.EGLContext;
import android.os.Handler;
import android.os.HandlerThread;
import com.bytedance.realx.video.memory.RXVideoTextureMemory;
import com.bytedance.realx.video.utils.YuvConverter;
import org.webrtc.CalledByNative;
import org.webrtc.EglBase;
import org.webrtc.Logging;
import org.webrtc.ThreadUtils;
import org.webrtc.VideoFrame;

public class AndroidOpenGLTextureMemoryHelper {
    private static final String TAG = "AndroidOpenGLTextureMemoryHelper";
    private final Handler handler;
    private final EglBase eglBase;
    private boolean isQuitting;
    private final YuvConverter yuvConverter = new YuvConverter();

    @CalledByNative
    public static AndroidOpenGLTextureMemoryHelper create(String threadName, EGLContext sharedEglContext14) {
        HandlerThread thread = new HandlerThread(threadName);
        thread.start();
        Handler handler = new Handler(thread.getLooper());
        return ThreadUtils.invokeAtFrontUninterruptibly(handler, () -> {
            try {
                return new AndroidOpenGLTextureMemoryHelper(sharedEglContext14, handler);
            }
            catch (RuntimeException e) {
                Logging.e(TAG, threadName + " create failure", e);
                return null;
            }
        });
    }

    private AndroidOpenGLTextureMemoryHelper(EGLContext sharedContext14, Handler handler) {
        if (handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("AndroidOpenGLTextureMemoryHelper must be created on the handler thread");
        }
        this.handler = handler;
        EGLContext eglContext = sharedContext14 != null ? sharedContext14 : EGL14.EGL_NO_CONTEXT;
        this.eglBase = EglBase.createEgl14(eglContext, EglBase.CONFIG_PIXEL_BUFFER);
        try {
            this.eglBase.createDummyPbufferSurface();
            this.eglBase.makeCurrent();
        }
        catch (RuntimeException e) {
            this.eglBase.release();
            handler.getLooper().quit();
            throw e;
        }
    }

    @CalledByNative
    public synchronized VideoFrame.I420Buffer textureToYuv(RXVideoTextureMemory textureMemory) {
        if (this.isQuitting) {
            throw new IllegalStateException("Wrong call state, current tetxure memory helper has quited.");
        }
        return ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> this.yuvConverter.convert(textureMemory));
    }

    @CalledByNative
    public synchronized void dispose() {
        Logging.i(TAG, "dispose()");
        ThreadUtils.invokeAtFrontUninterruptibly(this.handler, () -> {
            this.isQuitting = true;
            this.release();
        });
    }

    private void release() {
        if (this.handler.getLooper().getThread() != Thread.currentThread()) {
            throw new IllegalStateException("Wrong thread.");
        }
        this.yuvConverter.release();
        this.eglBase.release();
        this.handler.getLooper().quit();
    }
}

