/*
 * Decompiled with CFR 0.152.
 */
package com.ss.bytertc.base.utils;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.support.v4.content.ContextCompat;
import android.telephony.TelephonyManager;
import android.util.Log;
import android.util.Pair;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.List;
import java.util.regex.Pattern;

public class NetworkUtils {
    private static final boolean DEBUG_MOBILE = false;
    private static String debugInfo = "";
    private static NetworkTypeInterceptor sNetworkTypeInterceptor;
    private static final String TAG = "NetworkUtils";
    private static final String PARAMETER_SEPARATOR = "&";
    private static final String NAME_VALUE_SEPARATOR = "=";
    private static final String DEFAULT_CONTENT_CHARSET = "ISO-8859-1";

    public static void setNetworkTypeInterceptor(NetworkTypeInterceptor interceptor) {
        sNetworkTypeInterceptor = interceptor;
    }

    public static boolean is2G(Context context) {
        NetworkType nt = NetworkUtils.getNetworkType(context);
        return nt == NetworkType.MOBILE || nt == NetworkType.MOBILE_2G;
    }

    public static boolean isWifi(Context context) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = manager.getActiveNetworkInfo();
            if (info == null || !info.isAvailable()) {
                return false;
            }
            if (sNetworkTypeInterceptor != null && sNetworkTypeInterceptor.getNetworkType() != NetworkType.NONE) {
                return sNetworkTypeInterceptor.getNetworkType() == NetworkType.WIFI;
            }
            return 1 == info.getType();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static boolean isNetworkAvailable(Context context) {
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = manager.getActiveNetworkInfo();
            return info != null && info.isConnected();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static void registerReceiver(Context context, BroadcastReceiver receiver) {
        if (receiver != null && context != null) {
            IntentFilter filter = new IntentFilter();
            filter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            filter.addAction("android.net.wifi.WIFI_STATE_CHANGED");
            filter.addAction("android.net.wifi.STATE_CHANGE");
            context.getApplicationContext().registerReceiver(receiver, filter);
        }
    }

    public static void unregisterReceiver(Context context, BroadcastReceiver receiver) {
        if (receiver != null && context != null) {
            context.getApplicationContext().unregisterReceiver(receiver);
        }
    }

    public static NetworkType getNetworkType(Context context) {
        if (sNetworkTypeInterceptor != null && sNetworkTypeInterceptor.getNetworkType() != NetworkType.NONE) {
            return sNetworkTypeInterceptor.getNetworkType();
        }
        try {
            ConnectivityManager manager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo info = manager.getActiveNetworkInfo();
            if (info == null || !info.isAvailable()) {
                return NetworkType.NONE;
            }
            int type = info.getType();
            debugInfo = "NetworkInfo type:" + type;
            if (1 == type) {
                return NetworkType.WIFI;
            }
            if (0 == type) {
                int networkTypeResult = -1;
                if (0 == ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.READ_PHONE_STATE")) {
                    debugInfo = debugInfo + " getNetworkType through TelephoneManager;";
                    networkTypeResult = NetworkUtils.getNetWorkTypeThroughBPEA(context);
                } else {
                    networkTypeResult = info.getSubtype();
                    debugInfo = debugInfo + " getNetworkType through ConnectivityManager;";
                }
                debugInfo = debugInfo + " TelephonyManager type:" + networkTypeResult;
                switch (networkTypeResult) {
                    case 0: {
                        return NetworkType.UNKNOWN;
                    }
                    case 1: 
                    case 2: 
                    case 4: 
                    case 7: 
                    case 11: 
                    case 16: {
                        return NetworkType.MOBILE_2G;
                    }
                    case 3: 
                    case 5: 
                    case 6: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 12: 
                    case 14: 
                    case 15: 
                    case 17: {
                        return NetworkType.MOBILE_3G;
                    }
                    case 13: 
                    case 18: {
                        return NetworkType.MOBILE_4G;
                    }
                    case 20: {
                        return NetworkType.MOBILE_5G;
                    }
                }
                return NetworkType.UNKNOWN;
            }
            return NetworkType.MOBILE;
        }
        catch (Throwable e) {
            debugInfo = e.toString();
            return NetworkType.UNKNOWN;
        }
    }

    public static String getDebugInfo() {
        return debugInfo;
    }

    public static String getNetworkAccessType(Context context) {
        return NetworkUtils.getNetworkAccessType(NetworkUtils.getNetworkType(context));
    }

    public static String getNetworkAccessType(NetworkType nt) {
        String access = "";
        try {
            switch (nt) {
                case WIFI: {
                    access = "wifi";
                    break;
                }
                case MOBILE_2G: {
                    access = "2g";
                    break;
                }
                case MOBILE_3G: {
                    access = "3g";
                    break;
                }
                case MOBILE_4G: {
                    access = "4g";
                    break;
                }
                case MOBILE_5G: {
                    access = "5g";
                    break;
                }
                case MOBILE: {
                    access = "mobile";
                    break;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return access;
    }

    public static String format(List<Pair<String, String>> params, String encoding) {
        StringBuilder result = new StringBuilder();
        for (Pair<String, String> p : params) {
            String encodedValue;
            String encodedName = NetworkUtils.encode((String)p.first, encoding);
            String value = (String)p.second;
            String string = encodedValue = value != null ? NetworkUtils.encode(value, encoding) : "";
            if (result.length() > 0) {
                result.append(PARAMETER_SEPARATOR);
            }
            result.append(encodedName);
            result.append(NAME_VALUE_SEPARATOR);
            result.append(encodedValue);
        }
        return result.toString();
    }

    private static String encode(String content, String encoding) {
        try {
            return URLEncoder.encode(content, encoding != null ? encoding : DEFAULT_CONTENT_CHARSET);
        }
        catch (UnsupportedEncodingException problem) {
            throw new IllegalArgumentException(problem);
        }
    }

    public static boolean isIpv4(String ip) {
        String pattern = "^(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]).(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]).(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5]).(\\d{1,2}|1\\d\\d|2[0-4]\\d|25[0-5])$";
        boolean isMatch = Pattern.matches(pattern, ip);
        return isMatch;
    }

    public static boolean isIpv6(String ip) {
        String pattern = "^\\s*((([0-9A-Fa-f]{1,4}:){7}([0-9A-Fa-f]{1,4}|:))|(([0-9A-Fa-f]{1,4}:){6}(:[0-9A-Fa-f]{1,4}|((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){5}(((:[0-9A-Fa-f]{1,4}){1,2})|:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3})|:))|(([0-9A-Fa-f]{1,4}:){4}(((:[0-9A-Fa-f]{1,4}){1,3})|((:[0-9A-Fa-f]{1,4})?:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){3}(((:[0-9A-Fa-f]{1,4}){1,4})|((:[0-9A-Fa-f]{1,4}){0,2}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){2}(((:[0-9A-Fa-f]{1,4}){1,5})|((:[0-9A-Fa-f]{1,4}){0,3}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(([0-9A-Fa-f]{1,4}:){1}(((:[0-9A-Fa-f]{1,4}){1,6})|((:[0-9A-Fa-f]{1,4}){0,4}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:))|(:(((:[0-9A-Fa-f]{1,4}){1,7})|((:[0-9A-Fa-f]{1,4}){0,5}:((25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)(\\.(25[0-5]|2[0-4]\\d|1\\d\\d|[1-9]?\\d)){3}))|:)))(%.+)?\\s*$";
        boolean isMatch = Pattern.matches(pattern, ip);
        return isMatch;
    }

    private static int getNetWorkTypeThroughBPEA(Context context) {
        int networkType = -1;
        TelephonyManager mgr = (TelephonyManager)context.getSystemService("phone");
        try {
            Class<?> clazzCertAuthEntry = Class.forName("com.bytedance.bpea.entry.api.device.info.TelephonyManagerEntry");
            Class<?> clazzCert = Class.forName("com.bytedance.bpea.basics.Cert");
            Class<?> clazzTokenCert = Class.forName("com.bytedance.bpea.cert.token.TokenCert");
            if (clazzCertAuthEntry != null && clazzCert != null && clazzTokenCert != null) {
                Method methodCheckSDKCert = clazzCertAuthEntry.getDeclaredMethod("getNetworkType", TelephonyManager.class, clazzCert);
                Method buildCert = clazzTokenCert.getDeclaredMethod("with", String.class);
                if (methodCheckSDKCert != null && buildCert != null) {
                    networkType = (Integer)methodCheckSDKCert.invoke(null, mgr, buildCert.invoke(null, "bpea-rtc_generic_device_info"));
                    debugInfo = debugInfo + " getNetworkType through BPEA;";
                }
            }
        }
        catch (Exception e) {
            Log.i((String)TAG, (String)"BPEA not exist");
        }
        if (networkType == -1) {
            networkType = mgr.getNetworkType();
            debugInfo = debugInfo + " getNetworkType through system;";
        }
        return networkType;
    }

    public static enum NetworkType {
        UNKNOWN(-1),
        NONE(0),
        MOBILE(1),
        MOBILE_2G(2),
        MOBILE_3G(3),
        WIFI(4),
        MOBILE_4G(5),
        MOBILE_5G(6);

        final int nativeInt;

        private NetworkType(int ni) {
            this.nativeInt = ni;
        }

        public int getValue() {
            return this.nativeInt;
        }

        public boolean isAvailable() {
            return this != NONE;
        }
    }

    public static enum CompressType {
        NONE(0),
        GZIP(1),
        DEFLATER(2);

        final int nativeInt;

        private CompressType(int ni) {
            this.nativeInt = ni;
        }
    }

    public static interface NetworkTypeInterceptor {
        public NetworkType getNetworkType();
    }
}

